/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.server.export.a800;

import com.google.common.collect.Lists;
import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.util.NumberUtils;
import com.huawei.ism.util.StringUtils;
import com.huawei.xve.entity.StepDetail;
import com.huawei.xve.entity.TaskEnv;
import com.huawei.xve.entity.a800.DMEParam;
import com.huawei.xve.entity.a800.DMESettingInfo;
import com.huawei.xve.entity.a800.HisPerstatException;
import com.huawei.xve.entity.a800.QueryDpcTaskDetail;
import com.huawei.xve.entity.a800.QueryTaskDetailStatus;
import com.huawei.xve.server.AbstractTask;
import com.huawei.xve.server.IStepTask;
import com.huawei.xve.server.a800.CollectRestUtils;
import com.huawei.xve.utils.DeviceInfo;
import com.huawei.xve.utils.HisPerfstatUtil;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.ThreadUtils;

public class ExportGlobalFile
extends AbstractTask
implements IStepTask {
    private static final Logger log = LoggerFactory.getLogger(ExportGlobalFile.class);
    private static final String EXPORT_DESC = HisResourceManager.getString("exporting.performance.files");
    private static final int ONE_BATCH_MAX_NUMBER = NumberUtils.parseIntDefault((String)HisResourceManager.getCfgProperties().getProperty("MAX_ONE_BATCH_FILE_SYSTEM_RESTRICTION_CONDITION"), (int)2000);
    private static final int TOTAL_PROGRESS = 90;
    private final DeviceInfo deviceInfo;
    private final AiDevNode aiDevNode;
    private int successBatch = 0;
    private int partSuccessBatch = 0;
    private int totalBatch;
    private StringJoiner errorMsg = new StringJoiner(System.lineSeparator());

    public ExportGlobalFile(TaskEnv env, double factor) {
        super(env, factor);
        this.initDetail(EXPORT_DESC);
        this.deviceInfo = env.getDeviceInfo();
        this.aiDevNode = (AiDevNode)this.deviceInfo.getDevNode();
    }

    public StepDetail doTask() {
        this.init();
        this.uiDetail.running();
        try {
            this.exportPerFile();
            this.handleResult();
        }
        catch (Exception e) {
            log.error("Export perf file failed.", (Throwable)e);
            this.uiDetail.fail(HisResourceManager.getString("REST_IO_EXCEPTION"));
        }
        return this.uiDetail;
    }

    private void handleResult() {
        int failBatch = this.totalBatch - this.successBatch - this.partSuccessBatch;
        log.info("failBatch is {}, successBatch is {}, partSuccessBatch is {}", new Object[]{failBatch, this.successBatch, this.partSuccessBatch});
        if (failBatch == this.totalBatch || this.successBatch == 0 && this.partSuccessBatch == 0) {
            log.error("Failed to collect global file system performance files. Dme ip is {}. errorMsg is {}", (Object)this.deviceInfo.getIp(), (Object)this.errorMsg);
            this.uiDetail.fail(this.errorMsg.toString());
            return;
        }
        if (this.totalBatch == this.successBatch && this.totalBatch != 0) {
            log.info("The global file system performance file is collected successfully. Dme ip is {}", (Object)this.deviceInfo.getIp());
            this.uiDetail.success();
            return;
        }
        log.warn("Collecting global file system performance files partially succeeded. Dme ip is {}. errorMsg is {}", (Object)this.deviceInfo.getIp(), (Object)this.errorMsg);
        this.uiDetail.partSuccess(this.errorMsg.toString());
    }

    private void exportPerFile() {
        this.uiDetail.update(0);
        DMESettingInfo settingInfo = this.deviceInfo.getDmeSettingInfo();
        int indicatorNum = settingInfo.getIndicatorIds().size();
        if (indicatorNum > ONE_BATCH_MAX_NUMBER) {
            log.error("Indicator setting error. Indicator number is {}. One batch max number is {}", (Object)indicatorNum, (Object)ONE_BATCH_MAX_NUMBER);
            this.errorMsg.add(HisResourceManager.getString("historydata.a800.export.dme.indicator.error"));
            return;
        }
        int maxOneBatchFileNum = ONE_BATCH_MAX_NUMBER / indicatorNum;
        int fileNum = settingInfo.getFileSystemIds().size();
        List fileSystemPartitions = Lists.partition(settingInfo.getFileSystemIds(), (int)maxOneBatchFileNum);
        this.totalBatch = fileSystemPartitions.size();
        log.info("Start collect per file. Dme is {}, file num is {}, indicator num is {}, total batch is {}, one batch file num is {}", new Object[]{this.deviceInfo.getIp(), fileNum, indicatorNum, this.totalBatch, maxOneBatchFileNum});
        for (int i = 1; i <= this.totalBatch; ++i) {
            this.exportOneBatch(i, (List)fileSystemPartitions.get(i - 1), settingInfo);
            this.uiDetail.update(90 / this.totalBatch * i);
        }
    }

    private void exportOneBatch(int currentBatch, List<String> currentBatchIds, DMESettingInfo settingInfo) {
        long taskStartTime = System.currentTimeMillis();
        StringBuilder currentErrorBuilder = new StringBuilder();
        try {
            String taskId = this.startPackage(currentBatch, currentBatchIds, settingInfo);
            this.uiDetail.update(90 / this.totalBatch * (currentBatch - 1) + 15 / this.totalBatch);
            log.info("Packing the {}th batch succeeded. task id is {}", (Object)currentBatch, (Object)taskId);
            int maxQueryProgress = 90 / this.totalBatch * (currentBatch - 1) + 75 / this.totalBatch;
            QueryTaskDetailStatus queryStatus = this.pollingQueryTask(taskId, currentErrorBuilder, taskStartTime, maxQueryProgress);
            if (queryStatus == QueryTaskDetailStatus.SUCCESS || queryStatus == QueryTaskDetailStatus.PART_SUCCESS) {
                log.info("The {}th batch of data is packed successfully and ready for download.", (Object)currentBatch);
                this.downloadPerFile(taskId, queryStatus);
            }
        }
        catch (ToolException e) {
            log.error("Failed to export the {}th batch of global file system performance files.", (Object)currentBatch, (Object)e);
            currentErrorBuilder.append(HisResourceManager.getString("historydata.a800.export.error"));
        }
        catch (HisPerstatException e) {
            String errorInfo = HisPerfstatUtil.spliceErrorInfo(e);
            currentErrorBuilder.append(errorInfo);
            log.error(errorInfo);
        }
        if (currentErrorBuilder.length() > 0) {
            this.saveErrorMsg(currentErrorBuilder, currentBatch, currentBatchIds);
        }
    }

    private void saveErrorMsg(StringBuilder currentErrorBuilder, int currentBatch, List<String> currentBatchIds) {
        log.error("The information collected in the {}th batch is incomplete. Error msg: {}. Failed file IDs are {}.", new Object[]{currentBatch, currentErrorBuilder, currentBatchIds});
        this.errorMsg.add(HisResourceManager.getStringWithParams("historydata.a800.export.dme.batch", currentBatchIds));
        this.errorMsg.add(HisResourceManager.getString("historydata.a800.export.dpc.failed.title") + currentErrorBuilder.toString());
    }

    private void downloadPerFile(String taskId, QueryTaskDetailStatus queryStatus) throws HisPerstatException, ToolException {
        boolean isDownload = CollectRestUtils.downloadFileSystems(this.aiDevNode, taskId, this.env.getDmeResultDir());
        log.info("Downloading the performance data of the global file system {}.", (Object)isDownload);
        if (!isDownload) {
            return;
        }
        if (queryStatus == QueryTaskDetailStatus.PART_SUCCESS) {
            ++this.partSuccessBatch;
            return;
        }
        ++this.successBatch;
    }

    private QueryTaskDetailStatus pollingQueryTask(String taskId, StringBuilder errMsg, long taskStartTime, int maxQueryProgress) throws HisPerstatException, ToolException {
        QueryDpcTaskDetail taskDetail;
        block3: {
            do {
                ThreadUtils.sleepSeconds((long)30L);
                Optional<QueryDpcTaskDetail> taskDetailOpt = CollectRestUtils.queryFileSystemsPackingTask(this.aiDevNode, taskId).stream().filter(detail -> taskId.equals(detail.getId())).findAny();
                if (this.uiDetail.getProgress() + 1 < maxQueryProgress) {
                    this.uiDetail.update(this.uiDetail.getProgress() + 1);
                }
                if (!taskDetailOpt.isPresent()) {
                    log.error("The progress of the specified task is not found. Task id is {}", (Object)taskId);
                    errMsg.append(HisResourceManager.getString("historydata.a800.export.dme.status.error"));
                    return QueryTaskDetailStatus.FAIL;
                }
                taskDetail = taskDetailOpt.get();
                if (!HisPerfstatUtil.isCollectingStatus(taskDetail.getStatus())) break block3;
            } while (System.currentTimeMillis() - taskStartTime <= HisPerfstatUtil.QUERY_DETAIL_OVERTIME_MILLS);
            log.error("Collection timed out, task id is {}", (Object)taskId);
            errMsg.append(HisResourceManager.getString("historydata.a800.export.time.out.error"));
            return QueryTaskDetailStatus.FAIL;
        }
        return this.dealStatus(taskId, errMsg, taskDetail);
    }

    private QueryTaskDetailStatus dealStatus(String taskId, StringBuilder errMsg, QueryDpcTaskDetail taskDetail) {
        int status = taskDetail.getStatus();
        log.info("Task id is {}. Task status code is {}", (Object)taskId, (Object)status);
        if (status == QueryTaskDetailStatus.SUCCESS.getStatus()) {
            return QueryTaskDetailStatus.SUCCESS;
        }
        String errorDetail = taskDetail.getDetail();
        if (!StringUtils.isNULLStr(errorDetail)) {
            log.warn("Task Details is: {}", (Object)errorDetail);
            errMsg.append(errorDetail);
        }
        return QueryTaskDetailStatus.of(status);
    }

    private String startPackage(int currentBatch, List<String> currentBatchIds, DMESettingInfo settingInfo) throws ToolException, HisPerstatException {
        long begin = settingInfo.getBeginTimeMills();
        long end = settingInfo.getEndTimeMills();
        List<String> indicatorIds = settingInfo.getIndicatorIds();
        log.info("Start packing the {}th batch. begin is {}, end is {}, file ids are {}, indicator ids are {}.", new Object[]{currentBatch, begin, end, currentBatchIds, indicatorIds});
        return CollectRestUtils.packFileSystems(this.aiDevNode, new DMEParam(begin, end, currentBatchIds, indicatorIds)).getTaskId();
    }
}

