/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.server.export.a800;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.xve.entity.StepDetail;
import com.huawei.xve.entity.TaskEnv;
import com.huawei.xve.entity.a800.ConfigParam;
import com.huawei.xve.entity.a800.ConfigProgressResponse;
import com.huawei.xve.entity.a800.HisPerstatException;
import com.huawei.xve.server.AbstractTask;
import com.huawei.xve.server.IStepTask;
import com.huawei.xve.server.a800.CollectRestUtils;
import com.huawei.xve.utils.HisPerfstatUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.FilesUtil;
import utils.ThreadUtils;

public class PostDmeCollect
extends AbstractTask
implements IStepTask {
    private static final Logger log = LoggerFactory.getLogger(PostDmeCollect.class);
    private static final String POST_HANDLE_DESC = HisResourceManager.getString("export.postHandle");
    private final AiDevNode aiDevNode;
    private long taskStartTime;
    private StringJoiner errorMsg = new StringJoiner(System.lineSeparator());

    public PostDmeCollect(TaskEnv env, double factor) {
        super(env, factor);
        this.initDetail(POST_HANDLE_DESC);
        this.aiDevNode = (AiDevNode)env.getDeviceInfo().getDevNode();
    }

    public StepDetail doTask() {
        this.init();
        this.uiDetail.running();
        try {
            this.collectConfig();
            this.clearEmptyDir(this.env.getDmeResultDir());
            if (this.errorMsg.length() == 0) {
                log.info("The DME performance data is collected and processed successfully.");
                this.uiDetail.success();
            } else {
                log.warn("The DME performance data post-processing are partially successful. errorMsg is {}", (Object)this.errorMsg);
                this.uiDetail.partSuccess(this.errorMsg.toString());
            }
        }
        catch (Exception e) {
            log.error("Unknown error.", (Throwable)e);
            this.uiDetail.fail(HisResourceManager.getString("unknown.error"));
        }
        return this.uiDetail;
    }

    private void collectConfig() {
        String sn = this.env.getDeviceInfo().getDmeSettingInfo().getConfigSn();
        ConfigParam param = ConfigParam.builder().storageSn(sn).build();
        log.info("Start collect config. The SN of the A800 cluster is {}.", (Object)sn);
        try {
            this.taskStartTime = System.currentTimeMillis();
            boolean isPackSuccess = CollectRestUtils.packConfig(this.aiDevNode, param);
            if (!isPackSuccess) {
                log.error("Failed to export the config file of the A800 cluster({}).", (Object)sn);
                this.errorMsg.add(HisResourceManager.getString("historydata.a800.download.config.failed"));
                return;
            }
            if (this.pollingQueryTask(param)) {
                CollectRestUtils.downloadConfig(this.aiDevNode, param, this.env.getA800ResultDir());
            }
        }
        catch (ToolException e) {
            log.error("Failed to export the config file of the A800 cluster({}).", (Object)sn, (Object)e);
            this.errorMsg.add(HisResourceManager.getString("historydata.a800.download.config.failed"));
        }
        catch (HisPerstatException e) {
            String errorInfo = HisPerfstatUtil.spliceErrorInfo(e);
            this.errorMsg.add(errorInfo);
            log.error(errorInfo);
        }
    }

    private boolean pollingQueryTask(ConfigParam param) throws HisPerstatException, ToolException {
        ConfigProgressResponse response;
        do {
            ThreadUtils.sleepSeconds((long)30L);
            response = CollectRestUtils.queryConfigTask(this.aiDevNode, param);
            if (response.getProgress() != 100) continue;
            log.info("The configuration file packing progress is 100.");
            return true;
        } while (System.currentTimeMillis() - this.taskStartTime <= HisPerfstatUtil.CONFIG_TASK_OVERTIME_MILLS);
        log.error("Collect dpc performance files timed out. progress is {}.", (Object)response.getProgress());
        this.errorMsg.add(HisResourceManager.getString("historydata.a800.download.config.time.out.failed"));
        return false;
    }

    private void clearEmptyDir(String resultDir) {
        File[] files = new File(resultDir).listFiles();
        if (Objects.isNull(files)) {
            log.warn("{} is empty.", (Object)resultDir);
            return;
        }
        Arrays.stream(files).filter(subFile -> Objects.nonNull(subFile) && subFile.isDirectory()).forEach(subDir -> {
            File[] children = subDir.listFiles();
            if (Objects.nonNull(children) && children.length == 0) {
                log.info("Sub dir {} is empty, delete it.", (Object)FilesUtil.getCanonicalPath((File)subDir));
                subDir.delete();
            }
        });
    }
}

