/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.server.export.a800;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.tool.base.utils.ZipUtils;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.xve.entity.StepDetail;
import com.huawei.xve.entity.TaskEnv;
import com.huawei.xve.server.AbstractTask;
import com.huawei.xve.server.IStepTask;
import com.huawei.xve.utils.DeviceInfo;
import com.huawei.xve.utils.FileUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.FilesUtil;

public class PostDpcCollect
extends AbstractTask
implements IStepTask {
    private static final Logger log = LoggerFactory.getLogger(PostDpcCollect.class);
    private static final String POST_HANDLE_DESC = HisResourceManager.getString("export.postHandle");
    private static final String PERF = "_Perf_";

    public PostDpcCollect(TaskEnv env, double factor) {
        super(env, factor);
        this.initDetail(POST_HANDLE_DESC);
    }

    public StepDetail doTask() {
        this.init();
        this.uiDetail.running();
        try {
            log.info("Start the collection post-processing.");
            this.saveCollectedNodes();
            this.clearEmptyDir(this.env.getDpcResultDir());
            this.compressResult(this.env.getDeviceInfo(), this.env.getDpcResultDir());
            this.uiDetail.success();
        }
        catch (Exception e) {
            log.error("Unknown error.", (Throwable)e);
            this.uiDetail.fail(HisResourceManager.getString("unknown.error"));
        }
        log.info("After the collection is complete, the result is as follows:{}", (Object)this.uiDetail.getStatus());
        return this.uiDetail;
    }

    private void saveCollectedNodes() {
        this.env.getDeviceInfo().getDataTurboSettingInfo().getDpcClusterNodes().stream().filter(ClusterNode::isSelected).forEach(node -> node.setCollected(true));
    }

    private void compressResult(DeviceInfo deviceInfo, String resultDir) {
        if (!(deviceInfo.getDataTurboSettingInfo().isCompress() || deviceInfo.isA800Cluster() && deviceInfo.isCompressA800())) {
            log.info("DPC performance data does not need to be compressed.");
            return;
        }
        File[] fileList = new File(resultDir).listFiles();
        if (Objects.isNull(fileList)) {
            log.warn("{} is empty. Can't compress.", (Object)resultDir);
            return;
        }
        Set<String> filter = Arrays.stream(fileList).map(File::getName).collect(Collectors.toSet());
        String destName = FileUtil.formatIpForPath(deviceInfo.getDeviceName() + PERF + System.currentTimeMillis() + ".zip");
        ZipUtils.compressByAnt((String)resultDir, (String)destName, filter);
        if (!new File(String.join((CharSequence)File.separator, resultDir, destName)).exists()) {
            log.warn("Failed to pack the {}.", (Object)destName);
            return;
        }
        this.clearSrc(resultDir, filter);
    }

    private void clearSrc(String resultDir, Set<String> filter) {
        filter.stream().map(name -> new File(String.join((CharSequence)File.separator, resultDir, name))).filter(File::exists).forEach(file -> FileUtil.deleteDir(FilesUtil.getCanonicalPath((File)file)));
    }

    private void clearEmptyDir(String resultDir) {
        File[] files = new File(resultDir).listFiles();
        if (Objects.isNull(files)) {
            log.warn("{} is empty.", (Object)resultDir);
            return;
        }
        Arrays.stream(files).filter(subFile -> Objects.nonNull(subFile) && subFile.isDirectory()).forEach(this::clearDir);
    }

    private void clearDir(File subDir) {
        File[] children = subDir.listFiles();
        if (Objects.nonNull(children) && children.length == 0) {
            log.info("Sub dir {} is empty, delete it.", (Object)FilesUtil.getCanonicalPath((File)subDir));
            subDir.delete();
        }
    }
}

