/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.server.export.a800;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.framework.platform.common.data.UserOpTaskResult;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.util.NumberUtils;
import com.huawei.ism.util.Utils;
import com.huawei.xve.entity.TaskEnv;
import com.huawei.xve.entity.a800.FileSystemListResponse;
import com.huawei.xve.entity.a800.FileSystemSummary;
import com.huawei.xve.entity.a800.HisPerstatException;
import com.huawei.xve.entity.a800.QueryFileSystemParam;
import com.huawei.xve.server.AbstractTask;
import com.huawei.xve.server.IStepTask;
import com.huawei.xve.server.a800.CollectRestUtils;
import com.huawei.xve.utils.DeviceInfo;
import com.huawei.xve.utils.HisPerfstatUtil;
import com.huawei.xve.utils.HisUserOpToolData;
import com.huawei.xve.utils.UserBehaviorUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreDmeCollect
extends AbstractTask
implements IStepTask {
    private static final Logger log = LoggerFactory.getLogger(PreDmeCollect.class);
    private static final String PREPROCESSING = HisResourceManager.getString("export.pretreatment");
    private static final int MAX_FILE_SYSTEM_PAGE_NUMBER = NumberUtils.parseIntDefault((String)HisResourceManager.getCfgProperties().getProperty("MAX_FILE_SYSTEM_PAGE_NUMBER"), (int)1000);

    public PreDmeCollect(TaskEnv env, double factor) {
        super(env, factor);
        this.initDetail(PREPROCESSING);
    }

    public Object doTask() {
        this.init();
        this.uiDetail.running();
        DeviceInfo deviceInfo = this.env.getDeviceInfo();
        try {
            FileUtils.clearDir((String)this.env.getDmeResultDir());
            this.initUserData(deviceInfo);
            List<String> fileSystemIds = this.queryFileSystemIds(deviceInfo);
            deviceInfo.getDmeSettingInfo().setFileSystemIds(fileSystemIds);
            this.uiDetail.success();
        }
        catch (HisPerstatException e) {
            String errorInfo = HisPerfstatUtil.spliceErrorInfo(e);
            log.error(errorInfo);
            UserBehaviorUtil.recordUserOpData(deviceInfo, UserOpTaskResult.FAILED);
            this.uiDetail.fail(errorInfo);
        }
        catch (ToolException e) {
            log.error("Failed to query the global file system.", (Throwable)e);
            UserBehaviorUtil.recordUserOpData(deviceInfo, UserOpTaskResult.FAILED);
            this.uiDetail.fail(HisResourceManager.getString("REST_IO_EXCEPTION"));
        }
        catch (Exception e) {
            log.error("DME pre-collection query failed.", (Throwable)e);
            UserBehaviorUtil.recordUserOpData(deviceInfo, UserOpTaskResult.FAILED);
            this.uiDetail.fail(HisResourceManager.getString("unknown.error"));
        }
        return this.uiDetail;
    }

    List<String> queryFileSystemIds(DeviceInfo deviceInfo) throws HisPerstatException, ToolException {
        AiDevNode aiDevNode = (AiDevNode)deviceInfo.getDevNode();
        FileSystemListResponse response = CollectRestUtils.queryFileSystems(aiDevNode, QueryFileSystemParam.builder().build());
        int totalNumber = response.getTotal();
        if (totalNumber == 0) {
            log.error("No global file system is found.");
            throw new HisPerstatException(HisResourceManager.getString("historydata.a800.query.file.system.number.0"));
        }
        log.info("file system total number is {}", (Object)totalNumber);
        if (totalNumber <= 1000) {
            return this.getFileSystemIds(response);
        }
        return this.batchQueryAllFileSystems(response, aiDevNode);
    }

    private List<String> getFileSystemIds(FileSystemListResponse response) {
        return response.getData().stream().map(FileSystemSummary::getId).collect(Collectors.toList());
    }

    List<String> batchQueryAllFileSystems(FileSystemListResponse response, AiDevNode aiDevNode) throws HisPerstatException, ToolException {
        ArrayList<String> fileSystemIds = new ArrayList<String>(this.getFileSystemIds(response));
        QueryFileSystemParam param = QueryFileSystemParam.builder().pageSize(MAX_FILE_SYSTEM_PAGE_NUMBER).build();
        int batchNumber = response.getTotal() / MAX_FILE_SYSTEM_PAGE_NUMBER + (response.getTotal() % MAX_FILE_SYSTEM_PAGE_NUMBER == 0 ? 0 : 1);
        for (int pageNo = 2; pageNo <= batchNumber; ++pageNo) {
            param.setPageNo(pageNo);
            FileSystemListResponse fileSystemListResponse = CollectRestUtils.queryFileSystems(aiDevNode, param);
            if (Utils.isNullList(fileSystemListResponse.getData())) {
                log.error("Query file systems error. pageNo is {}", (Object)pageNo);
                throw new ToolException("Query file systems error. Data is empty.");
            }
            fileSystemIds.addAll(this.getFileSystemIds(fileSystemListResponse));
        }
        log.info("Query file systems success. DME ip is {}. File system ids is {}.", (Object)aiDevNode.getIp(), fileSystemIds);
        return fileSystemIds;
    }

    void initUserData(DeviceInfo deviceInfo) {
        deviceInfo.getHisUserData().setExportDataType(HisUserOpToolData.ExportDataTypeEnum.EXPORTPERFDATA.getValue());
        deviceInfo.getHisUserData().setTaskStartTime(System.currentTimeMillis());
        deviceInfo.getHisUserData().setTaskResult(UserOpTaskResult.FAILED);
    }
}

