/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.server.export.a800;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.framework.platform.common.data.UserOpTaskResult;
import com.huawei.xve.entity.StepDetail;
import com.huawei.xve.entity.TaskEnv;
import com.huawei.xve.server.AbstractTask;
import com.huawei.xve.server.IStepTask;
import com.huawei.xve.utils.DeviceInfo;
import com.huawei.xve.utils.HisUserOpToolData;
import com.huawei.xve.utils.UserBehaviorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreDpcCollect
extends AbstractTask
implements IStepTask {
    private static final Logger log = LoggerFactory.getLogger(PreDpcCollect.class);
    private static final String PREPROCESSING = HisResourceManager.getString("export.pretreatment");

    public PreDpcCollect(TaskEnv env, double factor) {
        super(env, factor);
        this.initDetail(PREPROCESSING);
    }

    public StepDetail doTask() {
        this.init();
        this.uiDetail.running();
        DeviceInfo deviceInfo = this.env.getDeviceInfo();
        try {
            log.info("Start pre-collection processing.");
            FileUtils.clearDir((String)this.env.getDpcResultDir());
            this.initUserData(deviceInfo);
            this.uiDetail.success();
        }
        catch (Exception e) {
            log.error("Unknown error.", (Throwable)e);
            UserBehaviorUtil.recordUserOpData(deviceInfo, UserOpTaskResult.FAILED);
            this.uiDetail.fail(HisResourceManager.getString("unknown.error"));
        }
        log.info("The pre-collection processing is complete. The result is as follows:{}", (Object)this.uiDetail.getStatus());
        return this.uiDetail;
    }

    private void initUserData(DeviceInfo deviceInfo) {
        deviceInfo.getHisUserData().setExportDataType(HisUserOpToolData.ExportDataTypeEnum.EXPORTPERFDATA.getValue());
        deviceInfo.getHisUserData().setTaskStartTime(System.currentTimeMillis());
        deviceInfo.getHisUserData().setTaskResult(UserOpTaskResult.FAILED);
    }
}

