/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.ui;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.ZipUtils;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.Utils;
import com.huawei.xve.entity.Status;
import com.huawei.xve.entity.TaskDetail;
import com.huawei.xve.entity.TaskEnv;
import com.huawei.xve.monitor.perfstat.ExploreButtonListener;
import com.huawei.xve.server.BatchUIObserver;
import com.huawei.xve.server.IUIObserver;
import com.huawei.xve.server.TaskManager;
import com.huawei.xve.ui.BatchExportPerfLayout;
import com.huawei.xve.ui.SettingParamDialog;
import com.huawei.xve.ui.UIConstants;
import com.huawei.xve.ui.a800.DmeSettingParamDialog;
import com.huawei.xve.ui.a800.OmSettingParamDialog;
import com.huawei.xve.ui.a800.ZoneSettingParamDialog;
import com.huawei.xve.ui.listener.ListMouseAdapter;
import com.huawei.xve.utils.ConnManager;
import com.huawei.xve.utils.DeviceInfo;
import com.huawei.xve.utils.FileUtil;
import com.huawei.xve.utils.HisPerfstatUtil;
import com.huawei.xve.utils.QuerInfo;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.FilesUtil;

public class BatchExportPerfDialog
extends JDialog {
    private static final Logger log = LoggerFactory.getLogger(BatchExportPerfDialog.class);
    private static final String STATUS_PREFIX = "dev.status.";
    private final List<String> deviceIDList;
    private final IUIObserver obs;
    private static final int NUM = 0;
    private DeviceInfo showDev;
    private BatchExportPerfLayout layout;

    private void initGifObserver() {
        UIConstants.RUNNING_IMG.setImageObserver(this);
        UIConstants.ITEM_RUNNING_IMG.setImageObserver(this);
    }

    public BatchExportPerfDialog(List<String> devs, Window parent) {
        super(parent);
        this.setModal(true);
        this.deviceIDList = new ArrayList<String>(devs);
        this.obs = new BatchUIObserver(this);
        this.obs.initDetailList(this.deviceIDList.stream().map(ConnManager::getDeviceInfo).collect(Collectors.toList()));
        this.initUI();
        this.initData();
        this.bindListener();
        this.initGifObserver();
        this.layout.getDeviceTable().selectFirstRow();
    }

    protected void initUI() {
        this.layout = new BatchExportPerfLayout();
        this.add((Component)this.layout, "North");
        this.setTitle(HisResourceManager.getString("perfstat.dataFileMgmt.title"));
        this.setResizable(true);
        this.pack();
        this.initFrameSize();
        this.setDefaultCloseOperation(2);
        SwingUtil.putScreenCenter((Window)this);
    }

    public void initData() {
        this.layout.getDeviceTableModel().removeAll();
        this.deviceIDList.stream().map(ConnManager::getDeviceInfo).map(this::constructDeviceTableRow).forEach(arg_0 -> BatchExportPerfDialog.lambda$initData$0(this.layout.getDeviceTableModel(), arg_0));
    }

    public TableRow<DevNode, String> constructDeviceTableRow(DeviceInfo deviceInfo) {
        DefaultTableRow row = new DefaultTableRow(this.layout.getDeviceTableModel().getColumnCount(), (Object)deviceInfo.getDeviceID());
        int index = 0;
        row.setValueAt(index++, deviceInfo.getDeviceName());
        row.setValueAt(index++, deviceInfo.getdType());
        row.setValueAt(index++, deviceInfo.getDevNode().getProductVersion());
        row.setValueAt(index++, deviceInfo.getIp());
        row.setValueAt(index++, this.initTotalFiles(deviceInfo, 0));
        row.setValueAt(index++, new IsmTableCell.ProgressCell(0));
        row.setValueAt(index++, this.getStatusComponent(Status.WAITING));
        row.setValueAt(index++, new IsmTableCell.HyperlinkCell(HisResourceManager.getString("historydata.setup"), event -> this.openSettingDialog(deviceInfo)));
        return row;
    }

    private Object initTotalFiles(DeviceInfo deviceInfo, int count) {
        return HisPerfstatUtil.isa800Dme(deviceInfo) || HisPerfstatUtil.isA800Om(deviceInfo) ? "--" : Integer.valueOf(count);
    }

    private void openSettingDialog(DeviceInfo deviceInfo) {
        if (!this.couldClose(this.getDeviceStatus(deviceInfo))) {
            log.error("The device({}) being collected is not allowed to be set.", (Object)deviceInfo.getIp());
            DialogUtils.showErrorDialog((JDialog)this, (String)HisResourceManager.getString("setup.check"));
            return;
        }
        if (!HisPerfstatUtil.isSupportA800Scene()) {
            log.info("Device({}) initialization setting panel", (Object)deviceInfo.getIp());
            new SettingParamDialog(Collections.singletonList(deviceInfo), this).setVisible(true);
            return;
        }
        if (HisPerfstatUtil.isA800Zone(deviceInfo)) {
            log.info("A800 Zone Node({}) Initialization Setting Panel.", (Object)deviceInfo.getIp());
            new ZoneSettingParamDialog(Collections.singletonList(deviceInfo), this).setVisible(true);
            return;
        }
        if (HisPerfstatUtil.isA800Om(deviceInfo)) {
            log.info("A800 OM Node({}) Initialization Setting Panel.", (Object)deviceInfo.getIp());
            new OmSettingParamDialog(deviceInfo, this).setVisible(true);
            return;
        }
        log.info("A800 DME({}) Initialization Setting Panel.", (Object)deviceInfo.getIp());
        new DmeSettingParamDialog(deviceInfo, this).setVisible(true);
    }

    private Status getDeviceStatus(DeviceInfo deviceInfo) {
        return Status.ofByDesc(STATUS_PREFIX, this.findTableRow(deviceInfo).getValueAt(6).toString());
    }

    private List<TableRow> mapDevs2Rows(List<DeviceInfo> selectDevInfos) {
        return selectDevInfos.stream().map(this::findTableRow).collect(Collectors.toList());
    }

    public IsmTableCell.IconCell getStatusComponent(Status status) {
        return new IsmTableCell.IconCell((Icon)status.getIcon(), status.getDesc(STATUS_PREFIX));
    }

    public void bindListener() {
        this.layout.getExport().addActionListener(event -> this.doCollect());
        this.layout.getOpenResult().addActionListener(new ExploreButtonListener());
        this.layout.getDeviceTable().addListSelectionListener(this::updateWhenDevChange);
        this.layout.getBatchSetup().addActionListener(event -> this.batchSetup());
        this.layout.getDetailList().addMouseListener(new ListMouseAdapter(this));
    }

    private void batchSetup() {
        List<DeviceInfo> devs = this.getSelectDevInfos();
        if (devs.isEmpty()) {
            DialogUtils.showErrorDialog((JDialog)this, (String)HisResourceManager.getString("device.not.empty"));
            return;
        }
        List<TableRow> selectTableRows = this.mapDevs2Rows(devs);
        if (!this.couldClose(selectTableRows)) {
            DialogUtils.showErrorDialog((JDialog)this, (String)HisResourceManager.getString("setup.check"));
            return;
        }
        if (!HisPerfstatUtil.isSupportA800Scene()) {
            log.info("Open the Batch Settings panel.");
            new SettingParamDialog(devs, this).setVisible(true);
            return;
        }
        this.batchA800Setup(devs);
    }

    private void batchA800Setup(List<DeviceInfo> devs) {
        List<DeviceInfo> zones = HisPerfstatUtil.getA800Zones(devs);
        if (devs.stream().anyMatch(dev -> HisPerfstatUtil.isA800Om(dev) || HisPerfstatUtil.isa800Dme(dev))) {
            log.error("OM nodes or DME devices cannot be configured in batches.");
            DialogUtils.showErrorDialog((JDialog)this, (String)HisResourceManager.getString("set.up.a800.not.support.batch.set"));
            return;
        }
        new ZoneSettingParamDialog(zones, this).setVisible(true);
    }

    protected void updateWhenDevChange(ListSelectionEvent event) {
        if (event.getValueIsAdjusting()) {
            return;
        }
        this.updateDetail();
    }

    private void updateDetail() {
        List<DeviceInfo> selectNode = this.getSelectDevInfos();
        if (selectNode.isEmpty()) {
            return;
        }
        this.showDev = selectNode.get(0);
        this.obs.updateWhenDevChange(this.showDev.getDeviceID());
    }

    private void initFrameSize() {
        this.setPreferredSize(UIConstants.DEFAULT_TOOL_WINDOW_SIZE);
        this.setMinimumSize(UIConstants.DEFAULT_TOOL_WINDOW_SIZE);
    }

    private List<DeviceInfo> getSelectDevInfos() {
        return this.layout.getDeviceTable().getMarkedRows().stream().map(TableRow::getIdentifier).map(Object::toString).map(ConnManager::getDeviceInfo).collect(Collectors.toList());
    }

    public void doCollect() {
        if (!this.isPassCommonCheck()) {
            return;
        }
        if (HisPerfstatUtil.isSupportA800Scene() && !this.isPassPreCollectCheck()) {
            return;
        }
        this.saveDveInfo();
        List<DeviceInfo> selectDevInfos = this.getSelectDevInfos();
        this.obs.initDetailList(selectDevInfos);
        this.obs.updateWhenDevChange(this.showDev.getDeviceID());
        selectDevInfos.sort(this::compare);
        List<CompletableFuture> futures = selectDevInfos.stream().map(dev -> (CompletableFuture)TaskManager.INS.submitTask((DeviceInfo)dev, this.obs)).collect(Collectors.toList());
        CompletableFuture<Void> allOf = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        allOf.thenRun(() -> this.compress(selectDevInfos));
    }

    private void reOpenResult(boolean isEnabled) {
        this.layout.getOpenResult().setEnabled(isEnabled);
        this.layout.getOpenResult().repaint();
    }

    private void compress(List<DeviceInfo> selectDevInfos) {
        if (!HisPerfstatUtil.isSupportA800Scene()) {
            log.info("Post-collection compression is not required in non-A800 scenarios.");
            return;
        }
        List<DeviceInfo> dmeDevs = selectDevInfos.stream().filter(HisPerfstatUtil::isa800Dme).collect(Collectors.toList());
        if (this.isNotCompress(dmeDevs)) {
            log.info("A800 scenario where compression is not required.");
            this.checkA800ClusterCollecting();
            return;
        }
        String resultDir = QuerInfo.getA800ClusterPerfExportDir();
        File[] files = new File(resultDir).listFiles();
        if (Objects.isNull(files)) {
            log.warn("{} is empty. Can't compress.", (Object)resultDir);
            this.reOpenResult(true);
            return;
        }
        Set<String> filter = this.getFilesFilter(files);
        String destName = FileUtil.formatIpForPath("OceanStorA800_Perf_" + System.currentTimeMillis() + ".zip");
        ZipUtils.compressByAnt((String)resultDir, (String)destName, filter);
        this.clearA800ClusterInfo();
        if (!new File(String.join((CharSequence)File.separator, resultDir, destName)).exists()) {
            log.warn("Failed to pack the {}.", (Object)destName);
            this.reOpenResult(true);
            return;
        }
        this.clearSrc(files);
        this.reOpenResult(true);
    }

    private void checkA800ClusterCollecting() {
        if (!this.couldClose(this.mapDevs2Rows(this.deviceIDList.stream().map(ConnManager::getDeviceInfo).filter(DeviceInfo::isA800Cluster).collect(Collectors.toList())))) {
            log.info("The A800 cluster information collection is not complete. The Open Result button is dimmed.");
            return;
        }
        this.reOpenResult(true);
    }

    private Set<String> getFilesFilter(File[] files) {
        HashSet<String> filter = new HashSet<String>();
        Arrays.stream(files).forEach(file -> this.saveA800Files((Set<String>)filter, (File)file));
        return filter;
    }

    private void saveA800Files(Set<String> filter, File file) {
        if (file.isDirectory() && file.getName().endsWith("zone")) {
            File[] zoneFiles = new File(FilesUtil.getCanonicalPath((File)file)).listFiles();
            if (Objects.isNull(zoneFiles)) {
                return;
            }
            Arrays.stream(zoneFiles).forEach(zoneFile -> filter.add("zone" + File.separator + zoneFile.getName() + "/*"));
        }
        if (file.isDirectory()) {
            filter.add(file.getName() + "/*");
            return;
        }
        filter.add(file.getName());
    }

    private void clearSrc(File[] files) {
        Arrays.stream(files).filter(File::exists).forEach(file -> FileUtil.deleteDir(FilesUtil.getCanonicalPath((File)file)));
    }

    private boolean isNotCompress(List<DeviceInfo> dmeDevs) {
        return Utils.isNullList(dmeDevs) || dmeDevs.stream().anyMatch(dev -> Objects.isNull(dev.getDmeSettingInfo())) || dmeDevs.stream().noneMatch(dev -> dev.getDmeSettingInfo().isCompress());
    }

    private int compare(DeviceInfo deviceInfo1, DeviceInfo deviceInfo2) {
        if (HisPerfstatUtil.isa800Dme(deviceInfo1)) {
            return 1;
        }
        if (HisPerfstatUtil.isa800Dme(deviceInfo2)) {
            return -1;
        }
        return 0;
    }

    private void saveDveInfo() {
        if (!HisPerfstatUtil.isSupportA800Scene()) {
            return;
        }
        List<DeviceInfo> selectDevInfos = this.getSelectDevInfos();
        this.saveAiDevNodeToOm(selectDevInfos);
        if (selectDevInfos.stream().noneMatch(HisPerfstatUtil::isa800Dme)) {
            return;
        }
        this.clearA800ClusterInfo();
        FileUtils.clearDir((String)QuerInfo.getA800ClusterPerfExportDir());
        this.reOpenResult(false);
        this.saveNodesToDme(selectDevInfos);
    }

    private void clearA800ClusterInfo() {
        this.deviceIDList.stream().map(ConnManager::getDeviceInfo).forEach(dev -> dev.setA800Cluster(false));
    }

    private void saveNodesToDme(List<DeviceInfo> selectDevInfos) {
        List zoneList = selectDevInfos.stream().filter(HisPerfstatUtil::isA800Zone).collect(Collectors.toList());
        List omList = selectDevInfos.stream().filter(HisPerfstatUtil::isA800Om).collect(Collectors.toList());
        AtomicBoolean isCompress = new AtomicBoolean(false);
        selectDevInfos.stream().filter(HisPerfstatUtil::isa800Dme).forEach(dev -> {
            isCompress.set(dev.getDmeSettingInfo().isCompress());
            if (omList.size() > 0) {
                List<String> omIps = omList.stream().map(DeviceInfo::getIp).collect(Collectors.toList());
                log.info("DME is {}, omIps is {}", (Object)dev.getIp(), omIps);
                dev.getDmeSettingInfo().setOmIps(omIps);
            }
            if (zoneList.size() > 0) {
                List<String> zoneIps = zoneList.stream().map(DeviceInfo::getIp).collect(Collectors.toList());
                log.info("DME is {}, zoneIps is {}", (Object)dev.getIp(), zoneIps);
                dev.getDmeSettingInfo().setZoneIps(zoneIps);
            }
        });
        selectDevInfos.forEach(dev -> {
            dev.setA800Cluster(true);
            dev.setCompressA800(isCompress.get());
        });
    }

    private void saveAiDevNodeToOm(List<DeviceInfo> selectDevInfos) {
        List<DeviceInfo> unSetOmList = selectDevInfos.stream().filter(HisPerfstatUtil::isA800Om).filter(omDev -> Objects.isNull(omDev.getDataTurboSettingInfo().getAiDevNode())).collect(Collectors.toList());
        Optional<AiDevNode> aiDevNode = this.deviceIDList.stream().map(ConnManager::getDeviceInfo).filter(HisPerfstatUtil::isa800Dme).map(DeviceInfo::getDevNode).filter(AiDevNode.class::isInstance).map(AiDevNode.class::cast).findFirst();
        if (unSetOmList.size() > 0 && aiDevNode.isPresent()) {
            unSetOmList.forEach(om -> om.getDataTurboSettingInfo().setAiDevNode((AiDevNode)aiDevNode.get()));
        }
    }

    private boolean isPassPreCollectCheck() {
        if (!this.isSetting()) {
            return false;
        }
        return this.isSelectOtherNodes();
    }

    private boolean isSelectOtherNodes() {
        List<DeviceInfo> selectDevs = this.getSelectDevInfos();
        if (selectDevs.stream().noneMatch(HisPerfstatUtil::isa800Dme)) {
            log.info("Do not collect DME devices.");
            return true;
        }
        if (selectDevs.stream().allMatch(HisPerfstatUtil::isa800Dme)) {
            log.error("DME devices cannot be collected separately.");
            DialogUtils.showErrorDialog((JDialog)this, (String)HisResourceManager.getString("historydata.a800.pre.check.dataturbo.not.separately.collect.error"));
            return false;
        }
        return true;
    }

    private boolean isSetting() {
        List<DeviceInfo> notSetDmeDevices = this.getNotSetDmeDevices();
        if (!Utils.isNullList(notSetDmeDevices)) {
            List unSetDmeDevices = notSetDmeDevices.stream().map(DeviceInfo::getIp).collect(Collectors.toList());
            log.error("DME device is not set. device is {}", unSetDmeDevices);
            DialogUtils.showErrorDialog((JDialog)this, (String)HisResourceManager.getStringWithParams("historydata.a800.pre.check.dme.not.set.error", unSetDmeDevices));
            return false;
        }
        List<DeviceInfo> notSetOmDevices = this.getNotSetOmDevices();
        if (!Utils.isNullList(notSetOmDevices)) {
            List unSetOmDevices = notSetOmDevices.stream().map(DeviceInfo::getIp).collect(Collectors.toList());
            log.error("OceanStor DataTurbo device is not set. device is {}", unSetOmDevices);
            DialogUtils.showErrorDialog((JDialog)this, (String)HisResourceManager.getStringWithParams("historydata.a800.pre.check.dataturbo.not.set.error", unSetOmDevices));
            return false;
        }
        return true;
    }

    private List<DeviceInfo> getNotSetOmDevices() {
        return this.getSelectDevInfos().stream().filter(HisPerfstatUtil::isA800Om).filter(dev -> Objects.isNull(dev.getDataTurboSettingInfo()) || !dev.getDataTurboSettingInfo().isSetFinish()).collect(Collectors.toList());
    }

    private List<DeviceInfo> getNotSetDmeDevices() {
        return this.getSelectDevInfos().stream().filter(HisPerfstatUtil::isa800Dme).filter(dev -> Objects.isNull(dev.getDmeSettingInfo()) || !dev.getDmeSettingInfo().isSetFinish()).collect(Collectors.toList());
    }

    private boolean isPassCommonCheck() {
        List rows = this.layout.getDeviceTable().getMarkedRows();
        if (rows.isEmpty()) {
            log.error("Select device empty.");
            DialogUtils.showErrorDialog((JDialog)this, (String)HisResourceManager.getString("device.not.empty"));
            return false;
        }
        if (this.hasRunningStatus(rows)) {
            log.error("Some devices are collecting data and cannot be collected repeatedly.");
            DialogUtils.showErrorDialog((JDialog)this, (String)HisResourceManager.getString("reselect.devices.device.running"));
            return false;
        }
        if (this.hasSuccessStatus(rows)) {
            log.error("Cannot collect data repeatedly because some devices have been collected.");
            DialogUtils.showErrorDialog((JDialog)this, (String)HisResourceManager.getString("reselect.devices.device.success"));
            return false;
        }
        return true;
    }

    private boolean hasSuccessStatus(List<TableRow> rows) {
        return this.getDeviceStatus(rows).stream().anyMatch(status -> status == Status.SUCCESS);
    }

    private boolean hasRunningStatus(List<TableRow> rows) {
        return this.getDeviceStatus(rows).stream().anyMatch(status -> status == Status.RUNNING);
    }

    private List<Status> getDeviceStatus(List<TableRow> rows) {
        return rows.stream().map(row -> (IsmTableCell.IconCell)row.getValueAt(6)).map(cell -> Status.ofByDesc(STATUS_PREFIX, cell.toString())).collect(Collectors.toList());
    }

    private boolean couldClose(List<TableRow> rows) {
        return rows.stream().map(row -> (IsmTableCell.IconCell)row.getValueAt(6)).map(cell -> Status.ofByDesc(STATUS_PREFIX, cell.toString())).allMatch(this::couldClose);
    }

    private boolean couldExport(Status status) {
        return status == Status.FAILED || status == Status.ALREADY || status == Status.WAITING || status == Status.PART_SUCCESS;
    }

    private boolean couldClose(Status status) {
        return status != Status.RUNNING;
    }

    public void updateDeviceTable(TaskDetail detail) {
        try {
            DeviceInfo dev = detail.getEnv().getDeviceInfo();
            TableRow row = this.findTableRow(dev);
            IsmTableCell.ProgressCell cell = (IsmTableCell.ProgressCell)row.getValueAt(5);
            cell.setProgress(detail.getProgress());
            IsmTableCell.IconCell statusCell = (IsmTableCell.IconCell)row.getValueAt(6);
            Status old = Status.ofByDesc(STATUS_PREFIX, statusCell.toString());
            if (old != detail.getStatus()) {
                row.setValueAt(6, this.getStatusComponent(detail.getStatus()));
            }
            TaskEnv env = detail.getEnv();
            int count = (int)env.getFileCount();
            row.setValueAt(4, this.initTotalFiles(dev, count));
        }
        catch (Exception e) {
            log.error("Update device row failed.");
        }
    }

    private TableRow findTableRow(DeviceInfo dev) {
        String id = dev.getDeviceID();
        return this.layout.getDeviceTable().getAllRows().stream().filter(row -> row.getIdentifier().equals(id)).findFirst().get();
    }

    public JList getDetailList() {
        return this.layout.getDetailList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processWindowEvent(WindowEvent event) {
        if (event.getID() == 201 && !this.couldClose(this.layout.getDeviceTable().getAllRows())) {
            WarningDialog dialog = DialogUtils.showWarnConfirmDialog((Window)this, (String)HisResourceManager.getString("exit.waring"), (String)HisResourceManager.getString("mainFrame.exit.confirm"));
            if (0 != dialog.getValue()) {
                return;
            }
            try {
                super.dispose();
            }
            catch (Throwable e) {
                log.error("Close window error.", e);
            }
            finally {
                log.info("Close tool -> exit");
                Runtime.getRuntime().halt(0);
            }
        }
        super.processWindowEvent(event);
    }

    public void updateDevTableStatus(List<DeviceInfo> devices, Status status) {
        List<TableRow> rows = this.mapDevs2Rows(devices);
        SwingUtilities.invokeLater(() -> rows.forEach(row -> {
            this.obs.initDetailList(devices);
            row.setValueAt(6, this.getStatusComponent(status));
            row.setValueAt(4, this.initTotalFiles(this.findDeviceInfo(devices, (TableRow)row), 0));
            row.setValueAt(5, new IsmTableCell.ProgressCell(0));
            this.updateDetail();
        }));
    }

    private DeviceInfo findDeviceInfo(List<DeviceInfo> devices, TableRow row) {
        return devices.stream().filter(dev -> dev.getDeviceID().equals(row.getIdentifier())).findFirst().get();
    }

    public DeviceInfo getShowDev() {
        return this.showDev;
    }

    private static /* synthetic */ void lambda$initData$0(DefaultTableModel rec$, TableRow xva$0) {
        rec$.addRow(new TableRow[]{xva$0});
    }
}

