/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.ui;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.UCD;
import com.huawei.xve.ui.StepTaskDetailRenderer;
import com.huawei.xve.ui.UIConstants;
import com.huawei.xve.utils.HisPerfstatUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;

public class BatchExportPerfLayout
extends JPanel {
    private String[] deviceTableHead;
    private JButton export = UiMethod.createButton((String)HisResourceManager.getString("EXPORT_FILE.TXT.EXPORT"), (char)'e');
    private JButton openResult = UiMethod.createButton((String)HisResourceManager.getString("EXPORT_FILE.TXT.EXPLORE"), (char)'o');
    private JButton batchSetup = UiMethod.createButton((String)HisResourceManager.getString("historydata.batch.setup"), (char)'s');
    private IsmTable deviceTable;
    private DefaultTableModel deviceTableModel;
    private JList detailList;
    private TableScrollPane deviceScrollPane;
    private JScrollPane detailListScrollPane;

    public BatchExportPerfLayout() {
        this.setLayout(new BorderLayout());
        this.initUI();
    }

    private void initUI() {
        this.initDevicePanel();
        JComponent topTableComponent = this.initTopTableComponent();
        this.deviceScrollPane.addComponent2ButtonArea(new JComponent[]{topTableComponent});
        this.deviceScrollPane.setPreferredSize(UIConstants.DEVICE_TABLE_SIZE);
        JComponent topComponent = this.initTopComponent();
        Box bottomComponent = this.buildBottomFrameSpace(12, this.initBottomComponent());
        this.add((Component)topComponent, "Center");
        this.add((Component)bottomComponent, "South");
    }

    private void initDevicePanel() {
        this.deviceTableHead = new String[]{HisResourceManager.getString("hisperfstat.devicetable.head.hostname"), HisResourceManager.getString("hisperfstat.selectdevice.support.devmodel"), HisResourceManager.getString("hisperfstat.selectdevice.support.devversion"), HisResourceManager.getString("hisperfstat.devicetable.head.ip"), HisResourceManager.getString("hisperfstat.devicetable.head.filesnumber"), HisResourceManager.getString("hisperfstat.devicetable.head.progress"), HisResourceManager.getString("hisperfstat.devicetable.head.status"), HisResourceManager.getString("hisperfstat.devicetable.head.operation")};
        this.deviceTableModel = new DefaultTableModel(this.deviceTableHead, new int[0]);
        this.deviceTable = new IsmTable((TableModel)this.deviceTableModel);
        this.deviceScrollPane = TableScrollPane.createTablePane((IsmTable)this.deviceTable, (boolean)true, (TableScrollPane.CountArea)TableScrollPane.CountArea.TABLE_LEFT_DOWN, (TableScrollPane.FilterArea)TableScrollPane.FilterArea.TABLE_RIGHT_UP, (TableScrollPane.ButtonArea)TableScrollPane.ButtonArea.TABLE_LEFT_UP);
    }

    private JComponent initTopTableComponent() {
        return UiMethod.buildCompsLeft((int)12, (Component[])new Component[]{this.export, this.openResult, this.batchSetup});
    }

    private JComponent initTopComponent() {
        return UiMethod.buildFrameSpace((JComponent)UCD.buildVerticalBox(null, (int)12, (Component[])new Component[]{this.initTopLabel(), this.deviceScrollPane}), (int)12);
    }

    private Component initTopLabel() {
        return UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{new JLabel(this.getFrameDescription())});
    }

    private String getFrameDescription() {
        return HisPerfstatUtil.isSupportA800Scene() ? HisResourceManager.getString("historical_information_data_frame_A800_top") : HisResourceManager.getString("historical_information_data_frame_top");
    }

    private JComponent initBottomComponent() {
        this.detailList = new JList(new DefaultListModel());
        this.detailList.setSelectionMode(1);
        this.detailList.setCellRenderer(new StepTaskDetailRenderer());
        this.detailListScrollPane = new JScrollPane(this.detailList);
        this.detailListScrollPane.setPreferredSize(UIConstants.ITEM_DETAIL_PANE_SIZE);
        this.detailListScrollPane.setOpaque(true);
        return this.detailListScrollPane;
    }

    private Box buildBottomFrameSpace(int margin, JComponent component) {
        Box vBox = Box.createHorizontalBox();
        Box hBox = Box.createVerticalBox();
        hBox.add(Box.createVerticalStrut(15));
        vBox.add(Box.createHorizontalStrut(margin));
        vBox.add(component);
        vBox.add(Box.createHorizontalStrut(margin));
        return vBox;
    }

    public JButton getExport() {
        return this.export;
    }

    public JButton getOpenResult() {
        return this.openResult;
    }

    public JButton getBatchSetup() {
        return this.batchSetup;
    }

    public IsmTable getDeviceTable() {
        return this.deviceTable;
    }

    public DefaultTableModel getDeviceTableModel() {
        return this.deviceTableModel;
    }

    public JList getDetailList() {
        return this.detailList;
    }
}

