/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.ui;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.ui.swing.calendarpicker.CalendarPickerPopup;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.HisDialogUtils;
import com.huawei.ism.ui.swing.dialog.HisWarningDialog;
import com.huawei.ism.util.StringUtils;
import com.huawei.ism.util.SwingUtil;
import com.huawei.xve.entity.ExportParam;
import com.huawei.xve.entity.Status;
import com.huawei.xve.ui.BatchExportPerfDialog;
import com.huawei.xve.ui.SettingParamLayout;
import com.huawei.xve.utils.DeviceInfo;
import com.huawei.xve.utils.QuerInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingParamDialog
extends JDialog {
    private static final Logger log = LoggerFactory.getLogger(SettingParamDialog.class);
    private static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd");
    private static final int NUM = 0;
    private SettingParamLayout layout;
    private final List<DeviceInfo> devices;
    private BatchExportPerfDialog dialog;

    public SettingParamDialog(List<DeviceInfo> devices, BatchExportPerfDialog parent) {
        super((Dialog)parent, HisResourceManager.getString("historydata.devicesetup.title"));
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.dialog = parent;
        this.devices = devices;
        this.initUI();
        this.settingListener();
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        this.layout = new SettingParamLayout();
        this.add((Component)this.layout, "North");
        this.pack();
        this.setResizable(true);
        this.initSetting();
        SwingUtil.putScreenCenter((Window)this);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)this);
    }

    private void settingListener() {
        this.layout.getResetBtn().addActionListener(e -> this.layout.resetTime());
        this.layout.getStartBtn().addActionListener(new TimeChooserListener(this.layout.getStartBtn(), this.layout.getStartTime()));
        this.layout.getEndBtn().addActionListener(new TimeChooserListener(this.layout.getEndBtn(), this.layout.getEndTime()));
        this.layout.getOkBtn().addActionListener(e -> this.checkTimeSettingAndApply());
        this.layout.getCancelBtn().addActionListener(e -> this.dispose());
    }

    private void initSetting() {
        if (this.devices.size() != 1) {
            return;
        }
        ExportParam params = this.devices.get(0).getExportParam();
        if (params != null) {
            this.layout.getZipSup().setSelected(params.isCompress());
            this.layout.getStartTime().setText(this.formatDate(params.getStartTime()));
            this.layout.getEndTime().setText(this.formatDate(params.getEndTime()));
        }
    }

    private String formatDate(long time) {
        if (time == 0L) {
            return "";
        }
        Date date = new Date();
        date.setTime(time);
        return StringUtils.formatDate(date, "yyyy-MM-dd");
    }

    private void checkTimeSettingAndApply() {
        HisWarningDialog warningDialog;
        long begin = this.getBeginTime();
        long end = this.getEndTime();
        if (begin != 0L && end != 0L && begin > end) {
            DialogUtils.showInfoDialog((JDialog)this, (String)HisResourceManager.getString("EXPORT-FILE.TXT.QUERY_ERROR"));
            return;
        }
        if (end - begin > 604800000L && (1 == (warningDialog = HisDialogUtils.showcreateDialog(this, HisResourceManager.getString("EXPORT_TIME_MORE_SEVEN_DAY"))).getValue() || -1 == warningDialog.getValue())) {
            return;
        }
        this.applySetting();
        this.dispose();
    }

    private void applySetting() {
        ExportParam param = new ExportParam();
        param.setStartTime(this.getBeginTime());
        param.setEndTime(this.getEndTime());
        param.setCompress(this.layout.getZipSup().isSelected());
        param.setResultDir(QuerInfo.getPerfExportDir());
        this.devices.forEach(dev -> dev.setExportParam(param));
        this.dialog.updateDevTableStatus(this.devices, Status.WAITING);
        log.info("Apply export config {} for {}.", (Object)param, this.devices.stream().map(DeviceInfo::getIp).collect(Collectors.toList()));
    }

    public long getBeginTime() {
        JTextField startTime = this.layout.getStartTime();
        long begin = 0L;
        try {
            begin = startTime != null && !"".equals(startTime.getText()) ? DATE_FORMATTER.parse(startTime.getText()).getTime() : 0L;
        }
        catch (ParseException e1) {
            log.error("parse starttime faild.", (Throwable)e1);
        }
        return begin;
    }

    public long getEndTime() {
        JTextField endTime = this.layout.getEndTime();
        long end = 0L;
        try {
            end = endTime != null && !"".equals(endTime.getText()) ? DATE_FORMATTER.parse(endTime.getText()).getTime() + 86399000L : 0L;
        }
        catch (ParseException e1) {
            log.error("parse endtime faild.", (Throwable)e1);
        }
        return end;
    }

    public synchronized String formatTime(Date date) {
        return DATE_FORMATTER.format(date);
    }

    public synchronized Date parseTime(String str) throws ParseException {
        return DATE_FORMATTER.parse(str);
    }

    public List<DeviceInfo> getDevices() {
        return this.devices;
    }

    private class TimeChooserListener
    implements ActionListener {
        private final JButton btn;
        private final JTextField text;

        public TimeChooserListener(JButton btn, JTextField text) {
            this.btn = btn;
            this.text = text;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CalendarPickerPopup cPicker = CalendarPickerPopup.getInstance();
            Calendar cal = Calendar.getInstance();
            try {
                cal.setTime(SettingParamDialog.this.parseTime("2000-1-1"));
            }
            catch (ParseException ignored) {
                log.error("", (Object)e);
            }
            cPicker.show(cal, Calendar.getInstance(), (Component)this.btn, CalendarPickerPopup.initParam((int)0, (int)(this.btn.getY() + this.btn.getHeight()), (boolean)false, (boolean)false));
            cPicker.addCallBackClass(cal1 -> this.text.setText(SettingParamDialog.this.formatTime(cal1.getTime())));
        }
    }
}

