/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.ui;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.LayoutConstants;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class SettingParamLayout
extends JPanel {
    private JLabel descLabel;
    private final JButton okBtn = UiMethod.createButton((String)HisResourceManager.getString("historydata.button.ok"), (char)'O');
    private final JButton cancelBtn = UiMethod.createButton((String)HisResourceManager.getString("historydata.button.cancel"), (char)'C');
    private final JButton resetBtn = UiMethod.createButton((String)HisResourceManager.getString("EXPORT-FILE.TXT.QUERY_RESET"), (char)'R');
    private final JButton startBtn = UiMethod.createButton((String)HisResourceManager.getString("EXPORT-FILE.TXT.QUERY_CHOOSE"), (char)'S');
    private final JButton endBtn = UiMethod.createButton((String)HisResourceManager.getString("EXPORT-FILE.TXT.QUERY_CHOOSE"), (char)'E');
    private JTextField startTime;
    private JTextField endTime;
    private JCheckBox zipSup;
    private JLabel zipTips;
    private JComponent timeSel;

    public SettingParamLayout() {
        this.initUI();
    }

    private void initUI() {
        this.initComponents();
        this.layoutComponents();
    }

    private void initComponents() {
        this.descLabel = new JLabel(HisResourceManager.getString("historydata.setup.desc"));
        this.startTime = new JTextField(6);
        this.endTime = new JTextField(6);
        this.resetTime();
        this.zipSup = new JCheckBox(HisResourceManager.getString("EXPORT-FILE.TXT.QUERY_ZIP"), true);
        this.zipTips = new JLabel(HisResourceManager.getImage("tips.png"));
        this.zipTips.setToolTipText(HisResourceManager.getString("ZIP_TIPS"));
    }

    public void resetTime() {
        Calendar rightNow = Calendar.getInstance();
        rightNow.setTime(new Date());
        rightNow.add(6, -6);
        this.startTime.setText(new SimpleDateFormat("yyyy-MM-dd").format(rightNow.getTime()));
        this.startTime.setPreferredSize(new Dimension(6, 20));
        this.endTime.setText(new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        this.endTime.setPreferredSize(new Dimension(6, 20));
    }

    private void layoutComponents() {
        UCD.setJComponentWidth((JComponent)this.startTime, (int)75);
        UCD.setJComponentWidth((JComponent)this.endTime, (int)75);
        JComponent deviceComponent = this.initCompressComponent();
        this.initTimeSelectComponent();
        Box wholeBox = UCD.buildVBoxTop((int)LayoutConstants.LINE_MARGIN_PIXEL, (Component[])new Component[]{Box.createHorizontalStrut(30), UCD.buildHBoxLeft((Component[])new Component[]{this.descLabel}), Box.createHorizontalStrut(30), deviceComponent, Box.createHorizontalStrut(50), this.timeSel, Box.createHorizontalStrut(50), UCD.buildHBoxRight((Component[])new Component[]{this.okBtn, this.cancelBtn})});
        this.setLayout(new BorderLayout());
        this.add((Component)UiMethod.buildFrameSpace((JComponent)wholeBox, (int)12), "Center");
    }

    private void initTimeSelectComponent() {
        JLabel startLabel = new JLabel(HisResourceManager.getString("EXPORT-FILE.TXT.QUERY_STARTTIME") + ":");
        JLabel endLabel = new JLabel(HisResourceManager.getString("EXPORT-FILE.TXT.QUERY_ENDTIME") + ":");
        UiMethod.setComponentSameSize((JComponent[])new JComponent[]{startLabel, endLabel});
        JLabel timeHelpLabel = new JLabel(HisResourceManager.getString("EXPORT-FILE.IO.HELP_TIPS"));
        CompoundBorder border = BorderFactory.createCompoundBorder(new TitledBorder(HisResourceManager.getString("historydata.setup.time.select")), new EmptyBorder(16, 0, 16, 0));
        this.timeSel = UCD.buildVerticalBox((Border)border, (int)LayoutConstants.LINE_MARGIN_PIXEL, (Component[])new Component[]{UCD.buildHBoxLeft((int)12, (Component[])new Component[]{Box.createHorizontalStrut(12), startLabel, this.startTime, this.startBtn}), UCD.buildHBoxLeft((int)12, (Component[])new Component[]{Box.createHorizontalStrut(12), endLabel, this.endTime, this.endBtn, this.resetBtn}), UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), timeHelpLabel})});
    }

    private JComponent initCompressComponent() {
        CompoundBorder border = BorderFactory.createCompoundBorder(new TitledBorder(HisResourceManager.getString("historydata.setup.zip")), new EmptyBorder(16, 0, 16, 0));
        return UCD.buildVerticalBox((Border)border, (int)LayoutConstants.LINE_MARGIN_PIXEL, (Component[])new Component[]{UCD.buildHBoxLeft((int)0, (Component[])new Component[]{Box.createHorizontalStrut(12), UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), this.zipSup, this.zipTips})})});
    }

    public JButton getOkBtn() {
        return this.okBtn;
    }

    public JButton getCancelBtn() {
        return this.cancelBtn;
    }

    public JButton getResetBtn() {
        return this.resetBtn;
    }

    public JButton getStartBtn() {
        return this.startBtn;
    }

    public JButton getEndBtn() {
        return this.endBtn;
    }

    public JTextField getStartTime() {
        return this.startTime;
    }

    public void setStartTime(JTextField startTime) {
        this.startTime = startTime;
    }

    public JTextField getEndTime() {
        return this.endTime;
    }

    public void setEndTime(JTextField endTime) {
        this.endTime = endTime;
    }

    public JCheckBox getZipSup() {
        return this.zipSup;
    }

    public JComponent getTimeSel() {
        return this.timeSel;
    }
}

