/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.ui;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.util.UCD;
import com.huawei.xve.entity.StepDetail;
import com.huawei.xve.ui.ProgressBox;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class StepTaskDetailRenderer
extends DefaultListCellRenderer {
    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value instanceof StepDetail) {
            return this.initStepRow(list, (StepDetail)value);
        }
        return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
    }

    private Component initStepRow(JList list, StepDetail detail) {
        JPanel viewPan = new JPanel();
        viewPan.setLayout(new BorderLayout());
        viewPan.add(this.createStepDesc(detail));
        viewPan.setComponentOrientation(list.getComponentOrientation());
        viewPan.setEnabled(list.isEnabled());
        viewPan.setFont(list.getFont());
        viewPan.setBackground(list.getBackground());
        viewPan.setForeground(list.getForeground());
        return viewPan;
    }

    private JComponent createStepDesc(StepDetail detail) {
        JLabel startTime = new JLabel(detail.getStartTime());
        JLabel msg = new JLabel(detail.getName());
        JLabel status = new JLabel(detail.getStatus().getDesc("step.status."), detail.getStatus().getIcon(), 2);
        ToolHyperLinkLabel detailLink = new ToolHyperLinkLabel("  ");
        JLabel remainTime = new JLabel(detail.getRemainingDesc());
        UCD.setSameWidth((int)30, (JComponent[])new JComponent[]{detailLink});
        if (detail.isRunning()) {
            return new ProgressBox(null, detail.getProgress(), new Component[]{startTime, msg, Box.createGlue(), remainTime, Box.createHorizontalStrut(8), status, detailLink, Box.createHorizontalStrut(8)});
        }
        if (detail.isAbnormal()) {
            detailLink.setText(HisResourceManager.getString("export.status.detail"));
        }
        return UCD.buildHorizotalBox(null, (Component[])new Component[]{startTime, msg, Box.createGlue(), status, detailLink, Box.createHorizontalStrut(8)});
    }
}

