/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.ui.a800;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckTreeNode;
import com.huawei.ism.ui.swing.dialog.HisDialogUtils;
import com.huawei.ism.ui.swing.dialog.HisWarningDialog;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.Utils;
import com.huawei.xve.entity.a800.DMESettingInfo;
import com.huawei.xve.entity.a800.Indicator;
import com.huawei.xve.ui.BatchExportPerfDialog;
import com.huawei.xve.ui.a800.DmeSettingParamLayout;
import com.huawei.xve.ui.listener.TimeChooserListener;
import com.huawei.xve.ui.listener.a800.DmeSaveSettingListener;
import com.huawei.xve.utils.DeviceInfo;
import com.huawei.xve.utils.HisPerfstatUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmeSettingParamDialog
extends JDialog {
    private static final Logger log = LoggerFactory.getLogger(DmeSettingParamDialog.class);
    private final DeviceInfo device;
    private final BatchExportPerfDialog parentDialog;
    private final DmeSettingParamLayout dmeSettingParamLayout;

    public DmeSettingParamDialog(DeviceInfo device, BatchExportPerfDialog parent) {
        super((Dialog)parent, HisResourceManager.getString("historydata.devicesetup.title"));
        this.device = device;
        this.parentDialog = parent;
        this.dmeSettingParamLayout = new DmeSettingParamLayout(device);
        this.initUI();
        this.initSetting();
        this.initListener();
    }

    private void initUI() {
        this.setModal(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.dmeSettingParamLayout, "North");
        this.pack();
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
        SwingUtil.putScreenCenter((Window)this);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)this);
    }

    private void initSetting() {
        this.initTime();
        this.initItemTree();
    }

    private void initTime() {
        DMESettingInfo dmeSettingInfo = this.device.getDmeSettingInfo();
        if (Objects.isNull(dmeSettingInfo) || !dmeSettingInfo.isSetFinish()) {
            log.info("The device({}) is not initialized.", (Object)this.device.getIp());
            return;
        }
        this.dmeSettingParamLayout.getStartTime().setText(HisPerfstatUtil.formatDate(dmeSettingInfo.getBeginTimeMills(), "yyyy-MM-dd HH:mm:ss"));
        this.dmeSettingParamLayout.getEndTime().setText(HisPerfstatUtil.formatDate(dmeSettingInfo.getEndTimeMills(), "yyyy-MM-dd HH:mm:ss"));
    }

    private void initItemTree() {
        this.attachItemTreeNode();
        DefaultTreeModel newTreeModel = new DefaultTreeModel((TreeNode)this.dmeSettingParamLayout.getItemRootNode(), true);
        this.dmeSettingParamLayout.getItemTree().setModel((TreeModel)newTreeModel);
        this.dmeSettingParamLayout.getItemTree().setRootVisible(true);
        this.dmeSettingParamLayout.getItemTree().setShowsRootHandles(true);
        this.dmeSettingParamLayout.getItemTree().expandAll(true);
        this.initSelectIndicators();
    }

    private void initSelectIndicators() {
        if (this.dmeSettingParamLayout.getItemRootNode().getChildCount() == 0) {
            log.error("Performance indicators is null.");
            return;
        }
        DMESettingInfo dmeSettingInfo = this.device.getDmeSettingInfo();
        if (Objects.isNull(dmeSettingInfo) || !dmeSettingInfo.isSetFinish()) {
            log.info("The device({}) is not initialized.", (Object)this.device.getIp());
            return;
        }
        Enumeration enumeration = this.dmeSettingParamLayout.getItemRootNode().postorderEnumeration();
        while (enumeration.hasMoreElements()) {
            CheckTreeNode currentNode;
            Object userObject;
            Object currentObj = enumeration.nextElement();
            if (!(currentObj instanceof CheckTreeNode) || !((userObject = (currentNode = (CheckTreeNode)CheckTreeNode.class.cast(currentObj)).getUserObject()) instanceof Indicator)) continue;
            currentNode.setSelected(dmeSettingInfo.getIndicatorIds().contains(((Indicator)userObject).getIndicatorId()));
        }
    }

    private void attachItemTreeNode() {
        this.dmeSettingParamLayout.getItemRootNode().removeAllChildren();
        List<String> indicators = Arrays.stream(HisResourceManager.getCfgProperties().getProperty("A800_SYSTEM_FILE_PERFORMANCE_INDICATORS").split(",")).map(String::trim).collect(Collectors.toList());
        if (Utils.isNullList(indicators)) {
            log.error("Performance indicators is null. Check whether the configuration file is damaged.");
            String notSupportDesc = HisResourceManager.getString("historydata.setup.a800.dme.no.indicators");
            this.dmeSettingParamLayout.getItemRootNode().setToolTips(notSupportDesc);
            this.dmeSettingParamLayout.getItemRootNode().setUserObject((Object)notSupportDesc);
            this.dmeSettingParamLayout.getOkBtn().setVisible(false);
            return;
        }
        String indicatorTitle = HisResourceManager.getString("historydata.setup.a800.dme.indicator.title");
        this.dmeSettingParamLayout.getItemRootNode().setToolTips(indicatorTitle);
        this.dmeSettingParamLayout.getItemRootNode().setUserObject((Object)indicatorTitle);
        indicators.forEach(this::buildCheckTreeNode);
    }

    private void buildCheckTreeNode(String indicatorId) {
        Indicator indicator = Indicator.valueOf(indicatorId);
        CheckTreeNode moduleNode = new CheckTreeNode((Object)indicator, false, true);
        moduleNode.setToolTips(indicator.toString());
        this.dmeSettingParamLayout.getItemRootNode().add((MutableTreeNode)moduleNode);
    }

    private void initListener() {
        this.dmeSettingParamLayout.getResetBtn().addActionListener(e -> this.dmeSettingParamLayout.resetTime());
        this.dmeSettingParamLayout.getOkBtn().addActionListener(new DmeSaveSettingListener(this));
        this.dmeSettingParamLayout.getCancelBtn().addActionListener(e -> this.dispose());
        this.dmeSettingParamLayout.getStartBtn().addActionListener(new TimeChooserListener(this.dmeSettingParamLayout.getStartBtn(), this.dmeSettingParamLayout.getStartTime(), HisPerfstatUtil.DATE_FORMATTER_BY_SEC, "2000-1-1 00:00:00"));
        this.dmeSettingParamLayout.getEndBtn().addActionListener(new TimeChooserListener(this.dmeSettingParamLayout.getEndBtn(), this.dmeSettingParamLayout.getEndTime(), HisPerfstatUtil.DATE_FORMATTER_BY_SEC, "2000-1-1 00:00:00"));
        this.dmeSettingParamLayout.getZipSup().addActionListener(e -> this.compressSelect());
    }

    private void compressSelect() {
        if (this.dmeSettingParamLayout.getZipSup().isSelected()) {
            log.info("Compress the file to a .zip file.");
            return;
        }
        HisWarningDialog warningDialog = HisDialogUtils.showcreateDialog(this, HisResourceManager.getString("historydata.setup.zip.deselect"));
        if (warningDialog.getValue() == 1 || warningDialog.getValue() == -1) {
            log.info("Click Cancel or Close. Value is {}.", (Object)warningDialog.getValue());
            this.dmeSettingParamLayout.getZipSup().setSelected(true);
            return;
        }
        log.info("Deselect Compress the .zip file on the DME setting page.");
    }

    public DeviceInfo getDevice() {
        return this.device;
    }

    public BatchExportPerfDialog getParentDialog() {
        return this.parentDialog;
    }

    public DmeSettingParamLayout getDmeSettingParamLayout() {
        return this.dmeSettingParamLayout;
    }
}

