/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.ui.a800;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.tool.obase.entity.A800Node;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckBoxTree;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckTreeNode;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.LayoutConstants;
import com.huawei.ism.util.UCD;
import com.huawei.xve.utils.DeviceInfo;
import com.huawei.xve.utils.HisPerfstatUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmeSettingParamLayout
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(DmeSettingParamLayout.class);
    private final JLabel descLabel = new JLabel(HisResourceManager.getString("historydata.setup.a800.dme.desc"));
    private final JButton okBtn = UiMethod.createButton((String)HisResourceManager.getString("historydata.button.ok"), (char)'O');
    private final JButton cancelBtn = UiMethod.createButton((String)HisResourceManager.getString("historydata.button.cancel"), (char)'C');
    private final JButton resetBtn = UiMethod.createButton((String)HisResourceManager.getString("EXPORT-FILE.TXT.QUERY_RESET"), (char)'R');
    private final JButton startBtn = UiMethod.createButton((String)HisResourceManager.getString("EXPORT-FILE.TXT.QUERY_CHOOSE"), (char)'S');
    private final JButton endBtn = UiMethod.createButton((String)HisResourceManager.getString("EXPORT-FILE.TXT.QUERY_CHOOSE"), (char)'E');
    private JTextField startTime;
    private JTextField endTime;
    private CheckBoxTree itemTree;
    private CheckTreeNode itemRootNode;
    private JCheckBox zipSup = new JCheckBox(HisResourceManager.getString("EXPORT-FILE.TXT.QUERY_ZIP"), true);
    private JLabel zipTips = new JLabel(HisResourceManager.getImage("tips.png"));
    private JComponent configSel;
    private ButtonGroup buttonGroup = new ButtonGroup();
    private JComponent zipSel;
    private JComponent timeSel;
    private JComponent indicatorSel;

    public DmeSettingParamLayout(DeviceInfo device) {
        this.initZipComponent();
        this.initTimeComponent();
        this.initConfigClusterComponent(device);
        this.initIndicatorComponent();
        this.layoutSettingComponents();
    }

    private void initConfigClusterComponent(DeviceInfo device) {
        AiDevNode aiDevNode = (AiDevNode)device.getDevNode();
        List a800Nodes = aiDevNode.getA800Nodes();
        CompoundBorder border = BorderFactory.createCompoundBorder(new TitledBorder(HisResourceManager.getString("historydata.setup.a800.dme.config.title")), new EmptyBorder(16, 0, 16, 0));
        if (a800Nodes.size() == 1) {
            log.info("There is only one A800 cluster, and the device IP address is displayed.");
            this.initOneIpRadioButton(a800Nodes, border);
            return;
        }
        log.info("There are multiple sn options.");
        Box box = UCD.buildVBoxTop((int)0, (Component[])new Component[]{Box.createHorizontalStrut(12)});
        this.initMultipleSNRadioButtons(a800Nodes, box);
        this.configSel = UCD.buildVerticalBox((Border)border, (int)LayoutConstants.LINE_MARGIN_PIXEL, (Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{box})});
    }

    private void initMultipleSNRadioButtons(List<A800Node> a800Nodes, Box box) {
        List snRadioButtons = a800Nodes.stream().map(DevNode::getDeviceSerialNumber).map(JRadioButton::new).collect(Collectors.toList());
        for (int i = 0; i < snRadioButtons.size(); ++i) {
            JRadioButton radioButton = (JRadioButton)snRadioButtons.get(i);
            radioButton.setActionCommand(radioButton.getText());
            box.add(radioButton);
            if (i < snRadioButtons.size() - 1) {
                box.add(Box.createHorizontalStrut(30));
            }
            this.buttonGroup.add(radioButton);
            if (i != 0) continue;
            this.buttonGroup.setSelected(radioButton.getModel(), true);
        }
    }

    private void initOneIpRadioButton(List<A800Node> a800Nodes, CompoundBorder border) {
        JRadioButton ipRadioButton = new JRadioButton(a800Nodes.get(0).getIp());
        ipRadioButton.setActionCommand(a800Nodes.get(0).getDeviceSerialNumber());
        this.buttonGroup.add(ipRadioButton);
        this.buttonGroup.setSelected(ipRadioButton.getModel(), true);
        this.configSel = UCD.buildVerticalBox((Border)border, (int)LayoutConstants.LINE_MARGIN_PIXEL, (Component[])new Component[]{UCD.buildHBoxLeft((int)0, (Component[])new Component[]{Box.createHorizontalStrut(12), ipRadioButton})});
    }

    private void initZipComponent() {
        this.zipTips.setToolTipText(HisResourceManager.getString("historydata.setup.a800.dme.zip.desc"));
        CompoundBorder border = BorderFactory.createCompoundBorder(new TitledBorder(HisResourceManager.getString("historydata.setup.zip")), new EmptyBorder(16, 0, 16, 0));
        this.zipSel = UCD.buildVerticalBox((Border)border, (int)LayoutConstants.LINE_MARGIN_PIXEL, (Component[])new Component[]{UCD.buildHBoxLeft((int)0, (Component[])new Component[]{Box.createHorizontalStrut(12), UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), this.zipSup, this.zipTips})})});
    }

    private void initTimeComponent() {
        this.startTime = new JTextField(11);
        this.endTime = new JTextField(11);
        UCD.setJComponentWidth((JComponent)this.startTime, (int)125);
        UCD.setJComponentWidth((JComponent)this.endTime, (int)125);
        this.resetTime();
        JLabel startLabel = new JLabel(HisResourceManager.getString("EXPORT-FILE.IO.QUERY_STARTTIME") + ":");
        JLabel endLabel = new JLabel(HisResourceManager.getString("EXPORT-FILE.IO.QUERY_ENDTIME") + ":");
        UiMethod.setComponentSameSize((JComponent[])new JComponent[]{startLabel, endLabel});
        CompoundBorder border = BorderFactory.createCompoundBorder(new TitledBorder(HisResourceManager.getString("historydata.setup.time.select")), new EmptyBorder(16, 0, 16, 0));
        this.timeSel = UCD.buildVerticalBox((Border)border, (int)LayoutConstants.LINE_MARGIN_PIXEL, (Component[])new Component[]{UCD.buildHBoxLeft((int)12, (Component[])new Component[]{Box.createHorizontalStrut(12), startLabel, this.startTime, this.startBtn}), UCD.buildHBoxLeft((int)12, (Component[])new Component[]{Box.createHorizontalStrut(12), endLabel, this.endTime, this.endBtn, this.resetBtn})});
    }

    public void resetTime() {
        Calendar rightNow = Calendar.getInstance();
        rightNow.setTime(new Date());
        rightNow.add(6, -7);
        this.startTime.setText(HisPerfstatUtil.DATE_FORMATTER_BY_SEC.format(rightNow.getTime()));
        this.startTime.setPreferredSize(new Dimension(11, 20));
        this.endTime.setText(HisPerfstatUtil.DATE_FORMATTER_BY_SEC.format(new Date()));
        this.endTime.setPreferredSize(new Dimension(11, 20));
    }

    private void initIndicatorComponent() {
        this.itemRootNode = new CheckTreeNode(new Object(), true, true);
        this.itemTree = new CheckBoxTree(this.itemRootNode, true);
        JScrollPane itemArea = new JScrollPane((Component)this.itemTree);
        itemArea.setPreferredSize(new Dimension(350, 200));
        itemArea.setHorizontalScrollBarPolicy(30);
        itemArea.setVerticalScrollBarPolicy(22);
        CompoundBorder border = BorderFactory.createCompoundBorder(new TitledBorder(HisResourceManager.getString("historydata.setup.a800.dme.item.select")), new EmptyBorder(16, 0, 16, 0));
        this.indicatorSel = UCD.buildVerticalBox((Border)border, (int)LayoutConstants.LINE_MARGIN_PIXEL, (Component[])new Component[]{UCD.buildHBoxLeft((int)12, (Component[])new Component[]{Box.createHorizontalStrut(12), itemArea})});
    }

    private void layoutSettingComponents() {
        Box wholeBox = UCD.buildVBoxTop((int)LayoutConstants.LINE_MARGIN_PIXEL, (Component[])new Component[]{Box.createHorizontalStrut(30), UCD.buildHBoxLeft((Component[])new Component[]{this.descLabel}), Box.createHorizontalStrut(30), this.zipSel, Box.createHorizontalStrut(50), this.timeSel, Box.createHorizontalStrut(30), this.configSel, Box.createHorizontalStrut(30), this.indicatorSel, Box.createHorizontalStrut(50), UCD.buildHBoxRight((Component[])new Component[]{this.okBtn, this.cancelBtn})});
        this.setLayout(new BorderLayout());
        this.add((Component)UiMethod.buildFrameSpace((JComponent)wholeBox, (int)12), "Center");
    }

    public JLabel getDescLabel() {
        return this.descLabel;
    }

    public JButton getOkBtn() {
        return this.okBtn;
    }

    public JButton getCancelBtn() {
        return this.cancelBtn;
    }

    public JButton getResetBtn() {
        return this.resetBtn;
    }

    public JButton getStartBtn() {
        return this.startBtn;
    }

    public JButton getEndBtn() {
        return this.endBtn;
    }

    public JTextField getStartTime() {
        return this.startTime;
    }

    public JTextField getEndTime() {
        return this.endTime;
    }

    public CheckBoxTree getItemTree() {
        return this.itemTree;
    }

    public CheckTreeNode getItemRootNode() {
        return this.itemRootNode;
    }

    public JCheckBox getZipSup() {
        return this.zipSup;
    }

    public JLabel getZipTips() {
        return this.zipTips;
    }

    public JComponent getConfigSel() {
        return this.configSel;
    }

    public ButtonGroup getButtonGroup() {
        return this.buttonGroup;
    }

    public JComponent getZipSel() {
        return this.zipSel;
    }

    public JComponent getTimeSel() {
        return this.timeSel;
    }

    public JComponent getIndicatorSel() {
        return this.indicatorSel;
    }

    public void setStartTime(JTextField startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(JTextField endTime) {
        this.endTime = endTime;
    }
}

