/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.ui.a800;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.StringUtils;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.Utils;
import com.huawei.xve.entity.a800.DataTurboSettingInfo;
import com.huawei.xve.entity.a800.DpcClusterNode;
import com.huawei.xve.server.a800.QueryDpcNodesTask;
import com.huawei.xve.ui.BatchExportPerfDialog;
import com.huawei.xve.ui.a800.OmSettingParamLayout;
import com.huawei.xve.ui.listener.TimeChooserListener;
import com.huawei.xve.ui.listener.a800.NodesSelectListener;
import com.huawei.xve.ui.listener.a800.OmSaveSettingListener;
import com.huawei.xve.ui.listener.a800.RemoveCollectedListener;
import com.huawei.xve.utils.DeviceInfo;
import com.huawei.xve.utils.HisPerfstatUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmSettingParamDialog
extends JDialog {
    private static final Logger log = LoggerFactory.getLogger(OmSettingParamDialog.class);
    private final DeviceInfo device;
    private final BatchExportPerfDialog parentDialog;
    private final OmSettingParamLayout omSettingParamLayout;
    private final DataTurboSettingInfo preSettingInfo;
    private DataTurboSettingInfo dataTurboSettingInfo;
    private String queryDpsErrorMsg;

    public OmSettingParamDialog(DeviceInfo device, BatchExportPerfDialog parent) {
        super((Dialog)parent, HisResourceManager.getString("historydata.devicesetup.title"));
        this.device = device;
        this.parentDialog = parent;
        this.omSettingParamLayout = new OmSettingParamLayout();
        this.preSettingInfo = device.getDataTurboSettingInfo();
        this.initUI();
        this.initDataTurboSettingInfo();
        this.initSetting();
        this.initListener();
    }

    private void initUI() {
        this.setModal(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.omSettingParamLayout, "North");
        this.pack();
        this.setDefaultCloseOperation(2);
        this.setResizable(true);
        SwingUtil.putScreenCenter((Window)this);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)this);
    }

    private void initSetting() {
        if (Objects.isNull(this.dataTurboSettingInfo) || Utils.isNullList(this.dataTurboSettingInfo.getDpcClusterNodes())) {
            log.error("dpc nodes is null. errorMsg is {}", (Object)this.queryDpsErrorMsg);
            this.omSettingParamLayout.getNodesScroll().removeAll();
            this.omSettingParamLayout.getNodesScroll().add((Component)new JLabel("<html>" + this.getErrorInfo() + "</html>", 0));
            this.omSettingParamLayout.getOkBtn().setVisible(false);
            return;
        }
        this.initTimeSetting();
        this.addDpcNodesToTable();
    }

    private String getErrorInfo() {
        return StringUtils.isNULLStr(this.queryDpsErrorMsg) ? HisResourceManager.getString("historydata.setup.options.error") : this.queryDpsErrorMsg;
    }

    private void addDpcNodesToTable() {
        this.dataTurboSettingInfo.getDpcClusterNodes().forEach(this::addDpcNode);
        this.markRowIfClusterIsSelected();
    }

    private void addDpcNode(DpcClusterNode node) {
        TableRow<DpcClusterNode, DpcClusterNode> row = this.constructDpcNodeRow(node);
        this.omSettingParamLayout.getClusterNodesTableModel().addRow(new TableRow[]{row});
    }

    private TableRow<DpcClusterNode, DpcClusterNode> constructDpcNodeRow(DpcClusterNode node) {
        DefaultTableRow row = new DefaultTableRow(this.omSettingParamLayout.getClusterNodesTableModel().getColumnCount(), (Object)node, (Object)node);
        int index = 0;
        row.setValueAt(index++, node.getDpcNodeId());
        row.setValueAt(index++, node.getManagementIp());
        row.setValueAt(index++, node.getOmNodeIp());
        row.setValueAt(index++, node.getManageStatus().getDesc());
        row.setValueAt(index, node.getServiceStatus().getDesc());
        return row;
    }

    private void initTimeSetting() {
        if (Objects.isNull(this.preSettingInfo) || !this.preSettingInfo.isSetFinish()) {
            log.info("No last setup information.");
            return;
        }
        this.omSettingParamLayout.getStartTime().setText(this.preSettingInfo.getStartTime().toString());
        this.omSettingParamLayout.getEndTime().setText(this.preSettingInfo.getEndTime().toString());
    }

    private void initDataTurboSettingInfo() {
        Optional<DataTurboSettingInfo> settingInfo = this.queryDpcClusterNodes();
        if (!settingInfo.isPresent() || Utils.isNullList(settingInfo.get().getDpcClusterNodes())) {
            log.error("query dpc nodes error, dpc node is null");
            return;
        }
        this.dataTurboSettingInfo = settingInfo.get();
        if (this.dataTurboSettingInfo.isSetFinish()) {
            return;
        }
        log.info("Initialize the default DPC node.");
        this.dataTurboSettingInfo.getDpcClusterNodes().subList(0, Math.min(200, this.dataTurboSettingInfo.getDpcClusterNodes().size())).forEach(node -> node.setSelected(true));
    }

    private Optional<DataTurboSettingInfo> queryDpcClusterNodes() {
        ProgressDialog progressDialog = new ProgressDialog((Window)this);
        Future queryDpcNodesFuture = AsyncExcutor.submit((Callable)new QueryDpcNodesTask(progressDialog, this));
        if (progressDialog.isDisplayable()) {
            progressDialog.setVisible(true);
        }
        try {
            return (Optional)queryDpcNodesFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("Query dpc nodes future failed.", (Throwable)e);
            return Optional.empty();
        }
    }

    private void initListener() {
        this.omSettingParamLayout.getCancelBtn().addActionListener(e -> this.dispose());
        if (Objects.isNull(this.dataTurboSettingInfo) || Utils.isNullList(this.dataTurboSettingInfo.getDpcClusterNodes())) {
            log.error("dpc nodes is null.");
            return;
        }
        this.omSettingParamLayout.getResetBtn().addActionListener(e -> this.omSettingParamLayout.resetTime());
        this.omSettingParamLayout.getStartBtn().addActionListener(new TimeChooserListener(this.omSettingParamLayout.getStartBtn(), this.omSettingParamLayout.getStartTime(), HisPerfstatUtil.DATE_FORMATTER_BY_DAY, "2000-1-1"));
        this.omSettingParamLayout.getEndBtn().addActionListener(new TimeChooserListener(this.omSettingParamLayout.getEndBtn(), this.omSettingParamLayout.getEndTime(), HisPerfstatUtil.DATE_FORMATTER_BY_DAY, "2000-1-1"));
        this.omSettingParamLayout.getOkBtn().addActionListener(new OmSaveSettingListener(this));
        NodesSelectListener listener = new NodesSelectListener(this);
        this.omSettingParamLayout.getClusterNodesTable().addListSelectionListener((ListSelectionListener)listener);
        this.omSettingParamLayout.getFilterNodeCombo().addActionListener(new RemoveCollectedListener(this));
        this.omSettingParamLayout.getNodesScroll().getFilterFiled().addEndChangeListener(e -> this.markRowIfClusterIsSelected());
    }

    private void markRowIfClusterIsSelected() {
        List selectNodes = this.dataTurboSettingInfo.getDpcClusterNodes().stream().filter(ClusterNode::isSelected).collect(Collectors.toList());
        List<TableRow> rows = this.omSettingParamLayout.getClusterNodesTable().getAllRows().stream().filter(row -> selectNodes.contains(row.getIdentifier())).collect(Collectors.toList());
        this.omSettingParamLayout.getClusterNodesTable().markTableRow(rows.toArray(new TableRow[0]));
    }

    public Optional<LocalDate> parseData(JTextField time) {
        try {
            return Optional.of(LocalDate.parse(time.getText(), HisPerfstatUtil.DATE_TIME_FORMATTER_BY_DAY));
        }
        catch (DateTimeParseException e) {
            log.error("parse time failed.  Time text is {}", (Object)time.getText(), (Object)e);
            return Optional.empty();
        }
    }

    public DeviceInfo getDevice() {
        return this.device;
    }

    public BatchExportPerfDialog getParentDialog() {
        return this.parentDialog;
    }

    public OmSettingParamLayout getOmSettingParamLayout() {
        return this.omSettingParamLayout;
    }

    public DataTurboSettingInfo getPreSettingInfo() {
        return this.preSettingInfo;
    }

    public DataTurboSettingInfo getDataTurboSettingInfo() {
        return this.dataTurboSettingInfo;
    }

    public String getQueryDpsErrorMsg() {
        return this.queryDpsErrorMsg;
    }

    public void setQueryDpsErrorMsg(String queryDpsErrorMsg) {
        this.queryDpsErrorMsg = queryDpsErrorMsg;
    }
}

