/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.ui.a800;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.LayoutConstants;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.UCD;
import com.huawei.xve.utils.HisPerfstatUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmSettingParamLayout
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(OmSettingParamLayout.class);
    private final JLabel descLabel = new JLabel(HisResourceManager.getString("historydata.setup.a800.om.desc"));
    private final JButton okBtn = UiMethod.createButton((String)HisResourceManager.getString("historydata.button.ok"), (char)'O');
    private final JButton cancelBtn = UiMethod.createButton((String)HisResourceManager.getString("historydata.button.cancel"), (char)'C');
    private final JButton resetBtn = UiMethod.createButton((String)HisResourceManager.getString("EXPORT-FILE.TXT.QUERY_RESET"), (char)'R');
    private final JButton startBtn = UiMethod.createButton((String)HisResourceManager.getString("EXPORT-FILE.TXT.QUERY_CHOOSE"), (char)'S');
    private final JButton endBtn = UiMethod.createButton((String)HisResourceManager.getString("EXPORT-FILE.TXT.QUERY_CHOOSE"), (char)'E');
    private JTextField startTime;
    private JTextField endTime;
    private JComponent timeSel;
    private JComponent nodeSel;
    private TableScrollPane nodesScroll;
    private IsmTable clusterNodesTable;
    private DefaultTableModel clusterNodesTableModel;
    private JComboBox filterNodeCombo;

    public OmSettingParamLayout() {
        this.initTimeComponent();
        this.initNodesComponent();
        this.layoutSettingComponents();
    }

    private void initTimeComponent() {
        this.initTimeComponentLength();
        this.resetTime();
        this.layoutTimeSelectComponent();
    }

    private void layoutTimeSelectComponent() {
        JLabel startLabel = new JLabel(HisResourceManager.getString("EXPORT-FILE.IO.QUERY_STARTTIME") + ":");
        JLabel endLabel = new JLabel(HisResourceManager.getString("EXPORT-FILE.IO.QUERY_ENDTIME") + ":");
        UiMethod.setComponentSameSize((JComponent[])new JComponent[]{startLabel, endLabel});
        JLabel timeHelpLabel = new JLabel(HisResourceManager.getString("historydata.setup.a800.om.time.help"));
        CompoundBorder border = BorderFactory.createCompoundBorder(new TitledBorder(HisResourceManager.getString("historydata.setup.time.select")), new EmptyBorder(16, 0, 16, 0));
        this.timeSel = UCD.buildVerticalBox((Border)border, (int)LayoutConstants.LINE_MARGIN_PIXEL, (Component[])new Component[]{UCD.buildHBoxLeft((int)12, (Component[])new Component[]{Box.createHorizontalStrut(12), startLabel, this.startTime, this.startBtn}), UCD.buildHBoxLeft((int)12, (Component[])new Component[]{Box.createHorizontalStrut(12), endLabel, this.endTime, this.endBtn, this.resetBtn}), UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), timeHelpLabel})});
    }

    private void initTimeComponentLength() {
        this.startTime = new JTextField(6);
        this.endTime = new JTextField(6);
        UCD.setJComponentWidth((JComponent)this.startTime, (int)75);
        UCD.setJComponentWidth((JComponent)this.endTime, (int)75);
    }

    public void resetTime() {
        Calendar rightNow = Calendar.getInstance();
        rightNow.setTime(new Date());
        rightNow.add(6, -6);
        this.startTime.setText(HisPerfstatUtil.DATE_FORMATTER_BY_DAY.format(rightNow.getTime()));
        this.startTime.setPreferredSize(new Dimension(6, 20));
        this.endTime.setText(HisPerfstatUtil.DATE_FORMATTER_BY_DAY.format(new Date()));
        this.endTime.setPreferredSize(new Dimension(6, 20));
    }

    private void initNodesComponent() {
        JComponent filterBox = this.buildFilterBox();
        this.buildNodeSelectBox();
        CompoundBorder border = BorderFactory.createCompoundBorder(new TitledBorder(HisResourceManager.getString("historydata.setup.a800.om.dpc.select")), new EmptyBorder(16, 0, 16, 0));
        this.nodeSel = UCD.buildVerticalBox((Border)border, (int)LayoutConstants.LINE_MARGIN_PIXEL, (Component[])new Component[]{UCD.buildHBoxLeft((int)12, (Component[])new Component[]{Box.createHorizontalStrut(12), filterBox}), UCD.buildHBoxLeft((int)12, (Component[])new Component[]{Box.createHorizontalStrut(12), this.nodesScroll, Box.createHorizontalStrut(12)})});
    }

    private void buildNodeSelectBox() {
        this.buildNodesScrollPane();
        this.setTableHeaderSize();
    }

    private void setTableHeaderSize() {
        if (Objects.isNull(this.clusterNodesTable)) {
            log.info("clusterNodesTbl is null.");
            return;
        }
        TableColumnModel colModel = this.clusterNodesTable.getColumnModel();
        colModel.getColumn(0).setPreferredWidth(150);
        colModel.getColumn(1).setPreferredWidth(60);
        colModel.getColumn(2).setPreferredWidth(110);
        colModel.getColumn(3).setPreferredWidth(60);
        colModel.getColumn(4).setPreferredWidth(40);
    }

    private void buildNodesScrollPane() {
        this.clusterNodesTableModel = new DefaultTableModel(this.getTableHeader(), new int[]{0, 1, 2, 3, 4});
        this.clusterNodesTable = new IsmTable((TableModel)this.clusterNodesTableModel);
        this.nodesScroll = new TableScrollPane(this.clusterNodesTable, true, false, true);
        this.nodesScroll.setPreferredSize(new Dimension(670, 300));
        this.nodesScroll.getFilterFiled().setClearSelection(false);
    }

    private String[] getTableHeader() {
        return new String[]{HisResourceManager.getString("historydata.setup.a800.om.dpc.id"), HisResourceManager.getString("historydata.setup.a800.om.dpc.ip"), HisResourceManager.getString("historydata.setup.a800.om.ip"), HisResourceManager.getString("historydata.setup.a800.om.dpc.mgmt.status"), HisResourceManager.getString("historydata.setup.a800.om.dpc.status")};
    }

    private JComponent buildFilterBox() {
        this.filterNodeCombo = new JComboBox<String>(this.getFilter());
        JLabel filterConditionTitle = UiMethod.createColonLabel((String)HisResourceManager.getString("EXPORT-FILE.TXT.QUERY_TITLE"));
        JLabel filterNodeTitle = UiMethod.createColonLabel((String)HisResourceManager.getString("historydata.setup.a800.om.dpc.filter"));
        return UCD.buildHorizotalBox(null, (Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{filterConditionTitle, Box.createHorizontalStrut(20), filterNodeTitle, this.filterNodeCombo})});
    }

    private String[] getFilter() {
        return new String[]{HisResourceManager.getString("HYPERMIRROR_PROPERTY_DIALOG_NO"), HisResourceManager.getString("HYPERMIRROR_PROPERTY_DIALOG_YES")};
    }

    private void layoutSettingComponents() {
        Box wholeBox = UCD.buildVBoxTop((int)LayoutConstants.LINE_MARGIN_PIXEL, (Component[])new Component[]{Box.createHorizontalStrut(30), UCD.buildHBoxLeft((Component[])new Component[]{this.descLabel}), Box.createHorizontalStrut(50), this.timeSel, Box.createHorizontalStrut(50), this.nodeSel, Box.createHorizontalStrut(50), UCD.buildHBoxRight((Component[])new Component[]{this.okBtn, this.cancelBtn})});
        this.setLayout(new BorderLayout());
        this.add((Component)UiMethod.buildFrameSpace((JComponent)wholeBox, (int)12), "Center");
    }

    public JLabel getDescLabel() {
        return this.descLabel;
    }

    public JButton getOkBtn() {
        return this.okBtn;
    }

    public JButton getCancelBtn() {
        return this.cancelBtn;
    }

    public JButton getResetBtn() {
        return this.resetBtn;
    }

    public JButton getStartBtn() {
        return this.startBtn;
    }

    public JButton getEndBtn() {
        return this.endBtn;
    }

    public JTextField getStartTime() {
        return this.startTime;
    }

    public JTextField getEndTime() {
        return this.endTime;
    }

    public JComponent getTimeSel() {
        return this.timeSel;
    }

    public JComponent getNodeSel() {
        return this.nodeSel;
    }

    public TableScrollPane getNodesScroll() {
        return this.nodesScroll;
    }

    public IsmTable getClusterNodesTable() {
        return this.clusterNodesTable;
    }

    public DefaultTableModel getClusterNodesTableModel() {
        return this.clusterNodesTableModel;
    }

    public JComboBox getFilterNodeCombo() {
        return this.filterNodeCombo;
    }

    public void setStartTime(JTextField startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(JTextField endTime) {
        this.endTime = endTime;
    }
}

