/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.ui.a800;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.HisDialogUtils;
import com.huawei.ism.ui.swing.dialog.HisWarningDialog;
import com.huawei.ism.util.StringUtils;
import com.huawei.ism.util.SwingUtil;
import com.huawei.xve.entity.ExportParam;
import com.huawei.xve.entity.Status;
import com.huawei.xve.ui.BatchExportPerfDialog;
import com.huawei.xve.ui.a800.ZoneSettingParamLayout;
import com.huawei.xve.ui.listener.TimeChooserListener;
import com.huawei.xve.utils.DeviceInfo;
import com.huawei.xve.utils.HisPerfstatUtil;
import com.huawei.xve.utils.QuerInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.text.ParseException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZoneSettingParamDialog
extends JDialog {
    private static final Logger log = LoggerFactory.getLogger(ZoneSettingParamDialog.class);
    private ZoneSettingParamLayout layout;
    private final List<DeviceInfo> devices;
    private BatchExportPerfDialog parentDialog;

    public ZoneSettingParamDialog(List<DeviceInfo> devices, BatchExportPerfDialog parent) {
        super((Dialog)parent, HisResourceManager.getString("historydata.devicesetup.title"));
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.parentDialog = parent;
        this.devices = devices;
        this.initUI();
        this.settingListener();
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        this.layout = new ZoneSettingParamLayout();
        this.add((Component)this.layout, "North");
        this.pack();
        this.setResizable(true);
        this.initSetting();
        SwingUtil.putScreenCenter((Window)this);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)this);
    }

    private void initSetting() {
        if (this.devices.size() != 1) {
            log.info("Batch Setting Scenarios");
            return;
        }
        ExportParam params = this.devices.get(0).getExportParam();
        if (params != null) {
            this.layout.getZipSup().setSelected(params.isCompress());
            this.layout.getStartTime().setText(HisPerfstatUtil.formatDate(params.getStartTime(), "yyyy-MM-dd HH:mm:ss"));
            this.layout.getEndTime().setText(HisPerfstatUtil.formatDate(params.getEndTime(), "yyyy-MM-dd HH:mm:ss"));
        }
    }

    private void settingListener() {
        this.layout.getResetBtn().addActionListener(e -> this.layout.resetTime());
        this.layout.getStartBtn().addActionListener(new TimeChooserListener(this.layout.getStartBtn(), this.layout.getStartTime(), HisPerfstatUtil.DATE_FORMATTER_BY_SEC, "2000-1-1 00:00:00"));
        this.layout.getEndBtn().addActionListener(new TimeChooserListener(this.layout.getEndBtn(), this.layout.getEndTime(), HisPerfstatUtil.DATE_FORMATTER_BY_SEC, "2000-1-1 00:00:00"));
        this.layout.getOkBtn().addActionListener(e -> this.checkTimeSettingAndApply());
        this.layout.getCancelBtn().addActionListener(e -> this.dispose());
    }

    private void checkTimeSettingAndApply() {
        long begin = this.getTime(this.layout.getStartTime());
        long end = this.getTime(this.layout.getEndTime());
        if (begin == 0L || end == 0L) {
            log.error("The start time or end time is 0. Start time :{}, end time :{}", (Object)begin, (Object)end);
            DialogUtils.showErrorDialog((JDialog)this, (String)HisResourceManager.getString("EXPORT_TIME_NOT_SET"));
            return;
        }
        if (end - begin < HisPerfstatUtil.ONE_HOUR_MS) {
            log.error("The end time minus start time is less than 1 hour. Start time :{}, end time :{}", (Object)begin, (Object)end);
            DialogUtils.showErrorDialog((JDialog)this, (String)HisResourceManager.getString("EXPORT_TIME_LESS_ONE_HOUR"));
            return;
        }
        if (end - begin > 604800000L) {
            HisWarningDialog warningDialog = HisDialogUtils.showcreateDialog(this, HisResourceManager.getString("EXPORT_TIME_MORE_SEVEN_DAY"));
            if (1 == warningDialog.getValue() || -1 == warningDialog.getValue()) {
                log.info("Click Cancel or Close. Value is {}.", (Object)warningDialog.getValue());
                return;
            }
            log.info("The collection period is longer than seven days.");
        }
        this.applySetting();
        this.dispose();
    }

    private long getTime(JTextField time) {
        try {
            return this.nonNullTime(time) ? HisPerfstatUtil.DATE_FORMATTER_BY_SEC.parse(time.getText()).getTime() : 0L;
        }
        catch (ParseException e) {
            log.error("parse time failed.", (Throwable)e);
            return 0L;
        }
    }

    private boolean nonNullTime(JTextField time) {
        return Objects.nonNull(time) && !StringUtils.isNULLStr(time.getText());
    }

    private void applySetting() {
        ExportParam param = new ExportParam();
        param.setStartTime(this.getTime(this.layout.getStartTime()));
        param.setEndTime(this.getTime(this.layout.getEndTime()));
        param.setCompress(this.layout.getZipSup().isSelected());
        param.setResultDir(QuerInfo.getPerfExportDir());
        this.devices.forEach(dev -> dev.setExportParam(param));
        this.parentDialog.updateDevTableStatus(this.devices, Status.WAITING);
        log.info("Apply export config {} for {}.", (Object)param, this.devices.stream().map(DeviceInfo::getIp).collect(Collectors.toList()));
    }

    public List<DeviceInfo> getDevices() {
        return this.devices;
    }
}

