/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.ui.listener;

import com.huawei.ism.ui.swing.plaf.armor.ArmorListUI;
import com.huawei.xve.entity.StepDetail;
import com.huawei.xve.ui.BatchExportPerfDialog;
import com.huawei.xve.ui.DetailInfoDialog;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ListUI;

public class ListMouseAdapter
extends MouseAdapter {
    private BatchExportPerfDialog dialog;

    public ListMouseAdapter(BatchExportPerfDialog dialog) {
        this.dialog = dialog;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent) || mouseEvent.getClickCount() > 1) {
            return;
        }
        int index = this.getListIndex(mouseEvent.getPoint(), this.dialog.getDetailList());
        if (-1 == index) {
            return;
        }
        DefaultListModel model = (DefaultListModel)this.dialog.getDetailList().getModel();
        StepDetail detail = (StepDetail)model.getElementAt(index);
        if (!detail.isAbnormal()) {
            return;
        }
        DetailInfoDialog detailInfoDialog = new DetailInfoDialog(detail.getErrMsg(), this.dialog);
        detailInfoDialog.setVisible(true);
    }

    private int getListIndex(Point point, JList detailList) {
        int index;
        ListUI obj = detailList.getUI();
        if (obj instanceof ArmorListUI) {
            ArmorListUI ui = (ArmorListUI)detailList.getUI();
            index = ui.locationToRow(point);
        } else {
            index = detailList.getSelectedIndex();
        }
        return index;
    }
}

