/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.ui.listener;

import com.huawei.ism.ui.swing.calendarpicker.CalendarPickerPopup;
import com.huawei.xve.utils.HisPerfstatUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeChooserListener
implements ActionListener {
    private static final Logger log = LoggerFactory.getLogger(TimeChooserListener.class);
    private final JButton btn;
    private final JTextField text;
    private final SimpleDateFormat simpleDateFormat;
    private final String earliestTime;

    @Override
    public void actionPerformed(ActionEvent e) {
        CalendarPickerPopup cPicker = CalendarPickerPopup.getInstance();
        Calendar cal = Calendar.getInstance();
        try {
            cal.setTime(this.parseTime(this.earliestTime));
        }
        catch (ParseException parseException) {
            log.error("parse time failed.", (Throwable)parseException);
        }
        cPicker.show(cal, Calendar.getInstance(), (Component)this.btn, CalendarPickerPopup.initParam((int)0, (int)(this.btn.getY() + this.btn.getHeight()), (boolean)this.isDisplaySeconds(), (boolean)false));
        cPicker.addCallBackClass(cal1 -> this.text.setText(this.formatTime(cal1.getTime())));
    }

    public synchronized String formatTime(Date date) {
        return this.simpleDateFormat.format(date);
    }

    public synchronized Date parseTime(String str) throws ParseException {
        return this.simpleDateFormat.parse(str);
    }

    public synchronized boolean isDisplaySeconds() {
        return this.simpleDateFormat.equals(HisPerfstatUtil.DATE_FORMATTER_BY_SEC);
    }

    public TimeChooserListener(JButton btn, JTextField text, SimpleDateFormat simpleDateFormat, String earliestTime) {
        this.btn = btn;
        this.text = text;
        this.simpleDateFormat = simpleDateFormat;
        this.earliestTime = earliestTime;
    }
}

