/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.ui.listener.a800;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckTreeNode;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.HisDialogUtils;
import com.huawei.ism.ui.swing.dialog.HisWarningDialog;
import com.huawei.xve.entity.Status;
import com.huawei.xve.entity.a800.DMESettingInfo;
import com.huawei.xve.entity.a800.Indicator;
import com.huawei.xve.ui.a800.DmeSettingParamDialog;
import com.huawei.xve.ui.a800.DmeSettingParamLayout;
import com.huawei.xve.utils.HisPerfstatUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmeSaveSettingListener
implements ActionListener {
    private static final Logger log = LoggerFactory.getLogger(DmeSaveSettingListener.class);
    private final DmeSettingParamDialog dmeSettingParamDialog;
    private final DmeSettingParamLayout dmeSettingParamLayout;

    public DmeSaveSettingListener(DmeSettingParamDialog dmeSettingParamDialog) {
        this.dmeSettingParamDialog = dmeSettingParamDialog;
        this.dmeSettingParamLayout = dmeSettingParamDialog.getDmeSettingParamLayout();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.info("Start to save the dme selected information.");
        List<Indicator> indicators = this.parseIndicator();
        if (!this.isRightChoose(indicators)) {
            return;
        }
        this.saveSettingInfo(indicators);
        log.info("Saving the setting info of the device({}) succeeded.", (Object)this.dmeSettingParamDialog.getDevice().getIp());
        this.dmeSettingParamDialog.dispose();
        log.info("dispose dialog:{}", (Object)this.dmeSettingParamDialog);
    }

    private void saveSettingInfo(List<Indicator> indicators) {
        DMESettingInfo info = new DMESettingInfo();
        info.setBeginTimeMills(HisPerfstatUtil.getTimeMills(this.dmeSettingParamLayout.getStartTime()));
        info.setEndTimeMills(HisPerfstatUtil.getTimeMills(this.dmeSettingParamLayout.getEndTime()));
        info.setIndicatorIds(indicators.stream().map(Indicator::getIndicatorId).collect(Collectors.toList()));
        info.setCompress(this.dmeSettingParamLayout.getZipSup().isSelected());
        info.setConfigSn(this.dmeSettingParamLayout.getButtonGroup().getSelection().getActionCommand());
        info.setSetFinish(true);
        this.dmeSettingParamDialog.getDevice().setDmeSettingInfo(info);
        log.info("save dme setting info success. startTime is {}, endTime is {}, indicators is {}", new Object[]{info.getBeginTimeMills(), info.getEndTimeMills(), indicators});
        this.dmeSettingParamDialog.getParentDialog().updateDevTableStatus(Collections.singletonList(this.dmeSettingParamDialog.getDevice()), Status.WAITING);
    }

    private List<Indicator> parseIndicator() {
        if (this.dmeSettingParamLayout.getItemRootNode().getChildCount() == 0) {
            log.error("Performance indicators is null.");
            return Collections.emptyList();
        }
        ArrayList<Indicator> indicators = new ArrayList<Indicator>();
        Enumeration enumeration = this.dmeSettingParamLayout.getItemRootNode().postorderEnumeration();
        while (enumeration.hasMoreElements()) {
            Object currentElement = enumeration.nextElement();
            if (!(currentElement instanceof CheckTreeNode)) continue;
            CheckTreeNode currentNode = (CheckTreeNode)currentElement;
            Object userObject = currentNode.getUserObject();
            if (!currentNode.isSelected() || !(userObject instanceof Indicator)) continue;
            Indicator indicator = (Indicator)userObject;
            indicators.add(indicator);
        }
        log.info("Select indicators is :{}", indicators);
        return indicators;
    }

    private boolean isRightChoose(List<Indicator> indicators) {
        return this.checkSettingInfoNotEmpty(indicators) && this.checkTimeSetting();
    }

    private boolean checkSettingInfoNotEmpty(List<Indicator> indicators) {
        if (CollectionUtil.isEmpty(indicators)) {
            log.error("No performance indicator is selected for the device({}).", (Object)this.dmeSettingParamDialog.getDevice().getIp());
            DialogUtils.showErrorDialog((JDialog)this.dmeSettingParamDialog, (String)HisResourceManager.getString("setup.no.select.indicator.error"));
            return false;
        }
        if (StringUtils.hasNULLStr((String[])new String[]{this.dmeSettingParamLayout.getStartTime().getText(), this.dmeSettingParamLayout.getEndTime().getText()})) {
            log.error("The start time or end time is 0.");
            DialogUtils.showErrorDialog((JDialog)this.dmeSettingParamDialog, (String)HisResourceManager.getString("EXPORT_TIME_NOT_SET"));
            return false;
        }
        return true;
    }

    private boolean checkTimeSetting() {
        HisWarningDialog warningDialog;
        Optional<LocalDateTime> startTime = this.parseDataTime(this.dmeSettingParamLayout.getStartTime());
        if (!startTime.isPresent()) {
            log.error("The format of the start time is incorrect.");
            DialogUtils.showErrorDialog((JDialog)this.dmeSettingParamDialog, (String)HisResourceManager.getString("setup.time.format.start.time.error"));
            return false;
        }
        Optional<LocalDateTime> endTime = this.parseDataTime(this.dmeSettingParamLayout.getEndTime());
        if (!endTime.isPresent()) {
            log.error("The format of the end time is incorrect.");
            DialogUtils.showErrorDialog((JDialog)this.dmeSettingParamDialog, (String)HisResourceManager.getString("setup.time.format.end.time.error"));
            return false;
        }
        if (startTime.get().isAfter(endTime.get())) {
            log.error("The start time is later than the end time. Start time :{}, end time :{}", startTime, endTime);
            DialogUtils.showErrorDialog((JDialog)this.dmeSettingParamDialog, (String)HisResourceManager.getString("EXPORT-FILE.TXT.QUERY_ERROR"));
            return false;
        }
        LocalDateTime currentTime = LocalDateTime.now();
        if (startTime.get().isAfter(currentTime)) {
            log.info("The start time is later than current time. Start time :{}, end time :{}, current time is :{}", new Object[]{startTime, endTime, currentTime});
            warningDialog = HisDialogUtils.showcreateDialog(this.dmeSettingParamDialog, HisResourceManager.getString("setup.start.later.than.now.warn"));
            if (1 == warningDialog.getValue() || -1 == warningDialog.getValue()) {
                log.info("Click Cancel or Close. Value is {}.", (Object)warningDialog.getValue());
                return false;
            }
        }
        if (endTime.get().isBefore(currentTime.minusDays(6L))) {
            log.info("The end time is 7 days earlier than the current time. Start time :{}, end time :{}", startTime, endTime);
            warningDialog = HisDialogUtils.showcreateDialog(this.dmeSettingParamDialog, HisResourceManager.getString("setup.end.earlier.than.now.seven.day.warn"));
            if (1 == warningDialog.getValue() || -1 == warningDialog.getValue()) {
                log.info("Click Cancel or Close. Value is {}.", (Object)warningDialog.getValue());
                return false;
            }
        }
        return true;
    }

    private Optional<LocalDateTime> parseDataTime(JTextField time) {
        try {
            return Optional.of(LocalDateTime.parse(time.getText(), HisPerfstatUtil.DATE_TIME_FORMATTER_BY_SEC));
        }
        catch (DateTimeParseException e) {
            log.error("parse time failed.  Time text is {}", (Object)time.getText(), (Object)e);
            return Optional.empty();
        }
    }
}

