/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.ui.listener.a800;

import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.xve.ui.a800.OmSettingParamDialog;
import com.huawei.xve.ui.a800.OmSettingParamLayout;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class NodesSelectListener
implements ListSelectionListener {
    private static final String ISM_SORTER_CLS_NAME = "IsmTableRowSorter";
    private final OmSettingParamDialog omSettingParamDialog;
    private final OmSettingParamLayout omSettingParamLayout;

    public NodesSelectListener(OmSettingParamDialog omSettingParamDialog) {
        this.omSettingParamDialog = omSettingParamDialog;
        this.omSettingParamLayout = omSettingParamDialog.getOmSettingParamLayout();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        ActionType actionType = this.getActionType();
        if (ActionType.FILTER_CHANGE.equals((Object)actionType) || ActionType.SORTER_CHANGE.equals((Object)actionType)) {
            return;
        }
        this.clearViewClusterNodeSelection();
        this.syncSelectRowToClusterNode();
    }

    private void clearViewClusterNodeSelection() {
        List viewRows = IntStream.range(0, this.omSettingParamLayout.getClusterNodesTable().getRowCount()).mapToObj(this::getRowData).collect(Collectors.toList());
        List identifierList = viewRows.stream().map(TableRow::getIdentifier).collect(Collectors.toList());
        this.omSettingParamDialog.getDataTurboSettingInfo().getDpcClusterNodes().stream().filter(identifierList::contains).forEach(clusterNode -> clusterNode.setSelected(false));
    }

    private TableRow getRowData(int index) {
        return this.omSettingParamLayout.getClusterNodesTableModel().getRow(this.omSettingParamLayout.getClusterNodesTable().convertRowIndexToModel(index));
    }

    private void syncSelectRowToClusterNode() {
        List identifierList = this.omSettingParamLayout.getClusterNodesTable().getMarkedRows().stream().map(TableRow::getIdentifier).collect(Collectors.toList());
        this.omSettingParamDialog.getDataTurboSettingInfo().getDpcClusterNodes().stream().filter(identifierList::contains).forEach(node -> node.setSelected(true));
    }

    ActionType getActionType() {
        StackTraceElement[] stackTraces = Thread.currentThread().getStackTrace();
        return Arrays.stream(stackTraces).anyMatch(stackTrace -> stackTrace.getClassName().contains(ISM_SORTER_CLS_NAME)) ? ActionType.SORTER_CHANGE : ActionType.SINGLE_SELECT;
    }

    static enum ActionType {
        FILTER_CHANGE,
        SORTER_CHANGE,
        SINGLE_SELECT;

    }
}

