/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.ui.listener.a800;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.HisDialogUtils;
import com.huawei.ism.ui.swing.dialog.HisWarningDialog;
import com.huawei.ism.util.StringUtils;
import com.huawei.xve.entity.Status;
import com.huawei.xve.entity.a800.DataTurboSettingInfo;
import com.huawei.xve.ui.a800.OmSettingParamDialog;
import com.huawei.xve.ui.a800.OmSettingParamLayout;
import com.huawei.xve.utils.HisPerfstatUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Optional;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmSaveSettingListener
implements ActionListener {
    private static final Logger log = LoggerFactory.getLogger(OmSaveSettingListener.class);
    private final OmSettingParamDialog omSettingParamDialog;
    private final OmSettingParamLayout omSettingParamLayout;
    private final DataTurboSettingInfo settingInfo;

    public OmSaveSettingListener(OmSettingParamDialog omSettingParamDialog) {
        this.omSettingParamDialog = omSettingParamDialog;
        this.omSettingParamLayout = omSettingParamDialog.getOmSettingParamLayout();
        this.settingInfo = omSettingParamDialog.getDataTurboSettingInfo();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.info("Start to save the dpc nodes selected information.");
        if (!this.isRightChoose()) {
            return;
        }
        LocalDate startTime = this.omSettingParamDialog.parseData(this.omSettingParamLayout.getStartTime()).get();
        LocalDate endTime = this.omSettingParamDialog.parseData(this.omSettingParamLayout.getEndTime()).get();
        this.settingInfo.setStartTime(startTime);
        this.settingInfo.setEndTime(endTime);
        this.settingInfo.setSetFinish(true);
        this.omSettingParamDialog.getDevice().setDataTurboSettingInfo(this.settingInfo);
        log.info("Save the dpc nodes selected information success. startTime is {}, endTime is {}, dpcNodes id is {}.", new Object[]{startTime, endTime, HisPerfstatUtil.getDpcSelectNodeIds(this.settingInfo)});
        this.omSettingParamDialog.getParentDialog().updateDevTableStatus(Collections.singletonList(this.omSettingParamDialog.getDevice()), Status.WAITING);
        this.omSettingParamDialog.dispose();
        log.info("close omSettingParamDialog.");
    }

    private boolean isRightChoose() {
        return this.checkNodesSetting() && this.checkTimeSetting();
    }

    private boolean checkNodesSetting() {
        if (this.settingInfo.getDpcClusterNodes().stream().noneMatch(ClusterNode::isSelected)) {
            log.error("No DPC node is selected.");
            DialogUtils.showErrorDialog((JDialog)this.omSettingParamDialog, (String)HisResourceManager.getString("historydata.setup.node.empty.error"));
            return false;
        }
        long count = this.settingInfo.getDpcClusterNodes().stream().filter(ClusterNode::isSelected).count();
        if (count > 200L) {
            log.error("More than 200 DPC nodes are selected. nodes number is {}.", (Object)count);
            DialogUtils.showErrorDialog((JDialog)this.omSettingParamDialog, (String)HisResourceManager.getString("historydata.setup.node.too.many.error"));
            return false;
        }
        return true;
    }

    private boolean checkTimeSetting() {
        String endTime;
        String startTime = this.omSettingParamLayout.getStartTime().getText();
        if (StringUtils.hasNULLStr(startTime, endTime = this.omSettingParamLayout.getEndTime().getText())) {
            log.error("The start time and end time cannot be empty. startTime:{}, endTime:{}", (Object)startTime, (Object)endTime);
            DialogUtils.showErrorDialog((JDialog)this.omSettingParamDialog, (String)HisResourceManager.getString("EXPORT_TIME_NOT_SET"));
            return false;
        }
        Optional<LocalDate> startData = this.omSettingParamDialog.parseData(this.omSettingParamLayout.getStartTime());
        if (!startData.isPresent()) {
            log.error("The format of the start time is incorrect. startTime:{}", (Object)startTime);
            DialogUtils.showErrorDialog((JDialog)this.omSettingParamDialog, (String)HisResourceManager.getString("setup.time.format.start.time.error"));
            return false;
        }
        Optional<LocalDate> endData = this.omSettingParamDialog.parseData(this.omSettingParamLayout.getEndTime());
        if (!endData.isPresent()) {
            log.error("The format of the end time is incorrect. endTime:{}", (Object)endTime);
            DialogUtils.showErrorDialog((JDialog)this.omSettingParamDialog, (String)HisResourceManager.getString("setup.time.format.end.time.error"));
            return false;
        }
        if (startData.get().isAfter(endData.get())) {
            log.error("The start time is later than the end time. Start time :{}, end time :{}", (Object)startTime, (Object)endTime);
            DialogUtils.showErrorDialog((JDialog)this.omSettingParamDialog, (String)HisResourceManager.getString("EXPORT-FILE.TXT.QUERY_ERROR"));
            return false;
        }
        if (startData.get().isBefore(endData.get().minusDays(6L))) {
            log.info("The end time is 7 days earlier than the current time. Start time :{}, end time :{}", (Object)startTime, (Object)endTime);
            DialogUtils.showErrorDialog((JDialog)this.omSettingParamDialog, (String)HisResourceManager.getString("historydata.setup.time.more.than.seven.days.error"));
            return false;
        }
        LocalDate currentData = LocalDate.now();
        if (startData.get().isAfter(currentData)) {
            log.info("The start time is later than current time. Start time :{}, end time :{}, current time is :{}", new Object[]{startTime, endTime, currentData});
            HisWarningDialog warningDialog = HisDialogUtils.showcreateDialog(this.omSettingParamDialog, HisResourceManager.getString("setup.start.later.than.now.warn"));
            if (1 == warningDialog.getValue() || -1 == warningDialog.getValue()) {
                log.info("Click Cancel or Close. Value is {}.", (Object)warningDialog.getValue());
                return false;
            }
        }
        return true;
    }
}

