/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.ui.listener.a800;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.KeywordRowFilter;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.xve.entity.a800.DpcClusterNode;
import com.huawei.xve.ui.a800.OmSettingParamDialog;
import com.huawei.xve.ui.a800.OmSettingParamLayout;
import com.huawei.xve.ui.listener.a800.RemoveCollectedFilter;
import com.huawei.xve.utils.HisPerfstatUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.RowFilter;
import javax.swing.table.TableRowSorter;

public class RemoveCollectedListener
implements ActionListener {
    private final OmSettingParamDialog omSettingParamDialog;
    private final OmSettingParamLayout omSettingParamLayout;

    public RemoveCollectedListener(OmSettingParamDialog omSettingParamDialog) {
        this.omSettingParamDialog = omSettingParamDialog;
        this.omSettingParamLayout = omSettingParamDialog.getOmSettingParamLayout();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isFilterUncollectedDpc()) {
            this.clearClusterNodeSelection();
        }
        this.updateFilter();
        this.markRowIfClusterIsSelected();
    }

    private void markRowIfClusterIsSelected() {
        List<DpcClusterNode> selectedNodes = HisPerfstatUtil.getDpcSelectNodes(this.omSettingParamDialog.getDataTurboSettingInfo());
        this.omSettingParamLayout.getClusterNodesTable().markTableRow(this.getTableRows(selectedNodes));
    }

    private void updateFilter() {
        RemoveCollectedFilter rowFilter = new RemoveCollectedFilter(this.getCollectedDpcIds());
        this.omSettingParamLayout.getNodesScroll().getFilterFiled().setExtFilter(new RowFilter[]{rowFilter});
        this.omSettingParamLayout.getNodesScroll().getFilterFiled().setAfterFilter(true);
        String text = this.omSettingParamLayout.getNodesScroll().getFilterFiled().getKeyword();
        IsmTable source = this.omSettingParamLayout.getClusterNodesTable();
        TableRowSorter sorter = (TableRowSorter)source.getRowSorter();
        if (StringUtils.isNULLStr((String)text)) {
            sorter.setRowFilter(rowFilter);
            return;
        }
        KeywordRowFilter keywordRowFilter = new KeywordRowFilter(text, new int[0]);
        sorter.setRowFilter(RowFilter.andFilter(Arrays.asList(keywordRowFilter, rowFilter)));
    }

    private void clearClusterNodeSelection() {
        List<DpcClusterNode> collectedNodes = this.omSettingParamDialog.getDataTurboSettingInfo().getDpcClusterNodes().stream().filter(DpcClusterNode::isCollected).collect(Collectors.toList());
        collectedNodes.forEach(node -> node.setSelected(false));
        this.omSettingParamLayout.getClusterNodesTable().unmarkTableRow(this.getTableRows(collectedNodes));
    }

    private List<String> getCollectedDpcIds() {
        if (!this.isFilterUncollectedDpc()) {
            return Collections.emptyList();
        }
        return HisPerfstatUtil.getCollectedDpcIds(this.omSettingParamDialog.getDataTurboSettingInfo());
    }

    private TableRow[] getTableRows(List<DpcClusterNode> nodes) {
        return (TableRow[])this.omSettingParamLayout.getClusterNodesTable().getAllRows().stream().filter(row -> nodes.contains(row.getIdentifier())).toArray(TableRow[]::new);
    }

    private boolean isFilterUncollectedDpc() {
        return Objects.requireNonNull(this.omSettingParamLayout.getFilterNodeCombo().getSelectedItem()).toString().equals(HisResourceManager.getString("HYPERMIRROR_PROPERTY_DIALOG_YES"));
    }
}

