/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.utils;

import com.huawei.ism.common.bean.User;
import com.huawei.ism.connection.HisTLVConnection;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DmeNode;
import com.huawei.ism.util.CopyUtil;
import com.huawei.ism.util.Utils;
import com.huawei.ism.util.VerifyUtil;
import com.huawei.sftp.AbstractSftp;
import com.huawei.sftp.PerfStatHisSftp;
import com.huawei.sftp.ShellCMDExecutor;
import com.huawei.tool.framwork.util.func.LocalHostUtil;
import com.huawei.xve.monitor.eservice.ParamHander;
import com.huawei.xve.utils.DeviceInfo;
import com.huawei.xve.utils.DeviceVersion;
import com.huawei.xve.utils.HisPerfstatUtil;
import com.huawei.xve.utils.UserBehaviorUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.LineIterator;
import org.apache.sshd.sftp.client.SftpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnManager {
    private static final Logger log = LoggerFactory.getLogger(ConnManager.class);
    private static final String RUN_ALONE = "standaloneRun";
    private static final String QUERY_DEVICE_INFO = "show system general \n";
    private static final String PRODUCT_MODEL = "Product Model";
    private static final String PRODUCT_VERSION = "Product Version";
    private static final String PATCH_VERSION = "Patch Version";
    private static final Map<String, DeviceInfo> DEVICE_MAP = new Hashtable<String, DeviceInfo>(0);
    private static final Map<String, DeviceInfo> NOT_SUPPORT_DEVICE_MAP = new Hashtable<String, DeviceInfo>(0);

    public static void init(String[] args) throws IsmException {
        ConnManager.devNodeToDeviceInfo();
        DeviceInfo di = null;
        try {
            if (args != null && args.length == 8 && args[0].equals(RUN_ALONE)) {
                di = ConnManager.initDeviceInfoByConfig(args);
                ConnManager.checkUser(di);
                AbstractSftp.initSystemInfo(di);
                UserBehaviorUtil.initUserOpData(di);
            }
            if (args != null && args.length == 6 && args[0].equals(RUN_ALONE)) {
                di = ConnManager.initDeviceInfoByConfigNew(args);
                ConnManager.checkUser(di);
                ConnManager.updatedVersion(di);
                UserBehaviorUtil.initUserOpData(di);
            }
        }
        catch (Exception e) {
            throw new IsmException(e.getMessage(), (Throwable)e);
        }
    }

    private static void devNodeToDeviceInfo() {
        List<DevNode> nodePool = ConnManager.getAllDevNodes();
        for (DevNode devNode : nodePool) {
            DeviceInfo info = new DeviceInfo();
            info.setDevNode(devNode);
            String deviceID = devNode.getDeviceSerialNumber();
            String deviceName = devNode.getDeviceName();
            String userName = devNode.getLoginUser().getUserName();
            String pwd = devNode.getLoginUser().getPassword();
            String deviceVersion = devNode.getProductVersion();
            int devicePort = devNode.getPort();
            String deviceIP = devNode.getIp();
            String devType = devNode.getDeviceType().toString();
            List innerIPs = devNode.getIpList();
            if (ConnManager.isEmpty(deviceIP) || ConnManager.isEmpty(deviceID) || ConnManager.isEmpty(userName) || ConnManager.isEmpty(pwd) || ConnManager.isEmpty(deviceName)) {
                log.error("initDevInfo failed. The deviceInfo is null or empty.");
                return;
            }
            info.setDeviceName("(" + deviceIP + ")" + deviceName);
            if (LocalHostUtil.isRunInSvp() && innerIPs != null && !innerIPs.isEmpty()) {
                deviceIP = ConnManager.getCtlIp(innerIPs, devicePort);
                if ("V300R003C20".equals(deviceVersion)) {
                    deviceVersion = deviceVersion + "SPC100";
                }
            }
            info.setDeviceVersion(DeviceVersion.getDeviceVersion(deviceVersion, devType));
            info.setIp(deviceIP);
            log.info("The deviceID: {}", (Object)deviceID);
            log.info("The deviceName: {} The decDeviceName is: {}. The input device manageIP is: {}", new Object[]{deviceName, deviceName, deviceIP});
            log.info("The deviceVersion: {}", (Object)info.getdVersion());
            log.info("The devType:{}", (Object)devType);
            DEVICE_MAP.put(deviceID, info);
            UserBehaviorUtil.initUserOpData(info);
        }
    }

    static List<DevNode> getAllDevNodes() {
        List nodePool = DefaultNodeProviderImpl.getInstance().getNodeList();
        if (!HisPerfstatUtil.isSupportA800Scene()) {
            return nodePool;
        }
        log.info("current scene is A800 hisPerfstat");
        List<AiDevNode> aiDevNodes = ConnManager.getAiDevNodes(nodePool);
        List<DevNode> allNodes = Stream.concat(ConnManager.getZoneNodes(aiDevNodes).stream(), ConnManager.getOmNodes(aiDevNodes).stream()).collect(Collectors.toList());
        allNodes.addAll(aiDevNodes);
        return allNodes;
    }

    private static List<DmeNode> getOmNodes(List<AiDevNode> aiDevNodes) {
        List omNodes = aiDevNodes.stream().flatMap(dev -> dev.getOmNodes().stream()).filter(DmeNode::isSelect).filter(dev -> ConnManager.nonNullUser(dev.getLoginUser())).collect(Collectors.toList());
        return Utils.isNullList(omNodes) ? Collections.emptyList() : Collections.singletonList(omNodes.get(0));
    }

    private static List<DmeNode> getZoneNodes(List<AiDevNode> aiDevNodes) {
        return aiDevNodes.stream().flatMap(dev -> dev.getA800Nodes().stream()).filter(DmeNode::isSelect).flatMap(node -> node.getZones().stream()).filter(dev -> ConnManager.nonNullUser(dev.getLoginUser())).collect(Collectors.toList());
    }

    private static boolean nonNullUser(com.huawei.ism.tool.obase.entity.User loginUser) {
        return Objects.nonNull(loginUser) && !StringUtils.hasNULLStr((String[])new String[]{loginUser.getUserName(), loginUser.getPassword()});
    }

    private static List<AiDevNode> getAiDevNodes(List<DevNode> nodePool) {
        return nodePool.stream().filter(AiDevNode.class::isInstance).map(AiDevNode.class::cast).collect(Collectors.toList());
    }

    private static void updatedVersion(DeviceInfo di) {
        log.info("start update high device dVersion");
        if (di == null || VerifyUtil.isEmpty(di.getIp())) {
            return;
        }
        ShellCMDExecutor exe = null;
        DeviceInfo cloneDi = null;
        try {
            cloneDi = ConnManager.getCloneDi(di);
            exe = ShellCMDExecutor.getInstance(cloneDi);
            exe.execCmd(QUERY_DEVICE_INFO, true);
            String result = exe.wait4Result(100L);
            if (VerifyUtil.isEmpty(result)) {
                return;
            }
            String[] infos = result.split("\n");
            String verison = "";
            String patchVerison = "";
            for (String info : infos) {
                String patchVerisons;
                if (info.contains(PRODUCT_MODEL)) {
                    String dType = info.split(":")[1].trim();
                    di.setdType(dType);
                    continue;
                }
                if (info.contains(PRODUCT_VERSION)) {
                    verison = info.split(":")[1].trim();
                    continue;
                }
                if (!info.contains(PATCH_VERSION) || VerifyUtil.isEmpty(patchVerisons = info.split(":")[1].trim())) continue;
                String[] pvArr = patchVerisons.split(" ");
                patchVerison = pvArr[pvArr.length - 1];
            }
            if (!VerifyUtil.isMultiEmpty(verison, patchVerison)) {
                verison = verison + patchVerison;
                di.setdVersion(verison);
            }
            if (log.isInfoEnabled()) {
                log.info("end update high device dVersion = {}", (Object)verison);
                log.info("device info : {}", (Object)di.toString());
            }
        }
        catch (Exception e) {
            log.error("connect failed.DeviceInfo:" + di + ",", (Throwable)e);
        }
    }

    private static DeviceInfo getCloneDi(DeviceInfo di) {
        DeviceInfo cloneDi;
        if (LocalHostUtil.isRunInSvp()) {
            String[] ips = di.getIp().split(",");
            cloneDi = CopyUtil.copyDevInfo(di, ips[0]);
        } else {
            cloneDi = di;
        }
        return cloneDi;
    }

    private static void checkIps(DeviceInfo deviceInfo) {
        String ips = deviceInfo.getIp();
        ips = Normalizer.normalize(ips, Normalizer.Form.NFKC);
        String[] ip = ips.split(",");
        StringBuffer sb = new StringBuffer();
        HashSet<String> repeat = new HashSet<String>();
        for (String i : ip) {
            String last = i.substring(i.lastIndexOf(".") + 1);
            if (repeat.contains(last)) continue;
            repeat.add(last);
            if (!PerfStatHisSftp.isSftpCanConnected(i, deviceInfo.getPort(), 300)) continue;
            sb.append(i);
            sb.append(',');
        }
        deviceInfo.setIp(sb.toString());
    }

    private static DeviceInfo initDeviceInfoByConfigNew(String[] args) {
        String ips = ConnManager.getValueFromConfig(args[4], args[5]);
        String port = args[3];
        String userName = args[1];
        String pwd = args[2];
        if (ConnManager.isEmpty(ips) || ConnManager.isEmpty(userName) || ConnManager.isEmpty(pwd) || ConnManager.isEmpty(port)) {
            log.error("initDevInfo by device config failed. The deviceInfo is null or the format is error.");
            return null;
        }
        DeviceInfo di = new DeviceInfo();
        DevNode devNode = new DevNode();
        com.huawei.ism.tool.obase.entity.User user = null;
        user = new com.huawei.ism.tool.obase.entity.User(userName, pwd);
        devNode.setLoginUser(user);
        di.setDeviceID(DeviceVersion.T18000.name());
        String deviceName = ConnManager.getValueFromConfig(args[4], "app.specific.device.type");
        if (deviceName == null) {
            log.error("deviceName is null.");
            deviceName = "";
        }
        di.setDeviceName(deviceName);
        di.setPort(Integer.parseInt(port));
        di.setIp(ips);
        di.setDeviceVersion(DeviceVersion.T18000);
        di.setdVersion(DeviceVersion.T18000.name());
        ConnManager.checkIps(di);
        DEVICE_MAP.put(DeviceVersion.T18000.name(), di);
        return di;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getValueFromConfig(String cfgPath, String key) {
        cfgPath = Normalizer.normalize(cfgPath, Normalizer.Form.NFKC);
        key = Normalizer.normalize(key, Normalizer.Form.NFKC);
        File cfgFile = new File(FilePathUtils.filterPath((String)cfgPath));
        FileInputStream is = null;
        BufferedReader br = null;
        String ips = null;
        LineIterator line = null;
        try {
            is = new FileInputStream(cfgFile);
            br = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
            line = new LineIterator(br);
            while (line.hasNext()) {
                ips = line.nextLine();
                if (ips == null || !ips.contains(key)) continue;
                String[] s = ips.split("=");
                if (s.length != 2) continue;
                String string = s[1];
                return string;
            }
        }
        catch (FileNotFoundException e) {
            log.error("the config file is not found. Path:{}", (Object)cfgFile.getName());
        }
        catch (IOException e) {
            log.error("get the key from configfile failed.key:{}", (Object)StringUtils.getCleanMessage((String)key), (Object)e);
        }
        finally {
            try {
                if (line != null) {
                    line.close();
                }
                if (br != null) {
                    br.close();
                }
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e2) {
                log.error("close the io failed.");
            }
        }
        return null;
    }

    public static DeviceInfo initDeviceInfoByConfig(String[] args) {
        String deviceIP = args[1];
        String port = args[2];
        String deviceName = args[3];
        String deviceID = args[4];
        String userName = args[5];
        String pwd = args[6];
        if (ConnManager.isEmpty(deviceIP) || ConnManager.isEmpty(deviceID) || ConnManager.isEmpty(userName) || ConnManager.isEmpty(pwd)) {
            log.error("initDevInfo by device config failed. The deviceInfo is null or the format is error.");
            return null;
        }
        if (ConnManager.isEmpty(port) || ConnManager.isEmpty(deviceName)) {
            log.error("initDevInfo by device config failed. The deviceInfo is null or the format is error.");
            return null;
        }
        DeviceInfo info = new DeviceInfo();
        DevNode devNode = new DevNode();
        com.huawei.ism.tool.obase.entity.User user = null;
        user = new com.huawei.ism.tool.obase.entity.User(userName, pwd);
        devNode.setLoginUser(user);
        info.setDeviceID(deviceID);
        info.setDeviceName("(" + deviceIP + ")" + deviceName);
        info.setIp(deviceIP);
        info.setDeviceVersion(DeviceVersion.getDeviceVersion(args[7]));
        info.setdVersion(args[7]);
        ConnManager.setDevicePort(port, info);
        DEVICE_MAP.put(deviceID, info);
        return info;
    }

    private static void checkUser(DeviceInfo info) {
        if (info == null) {
            log.error("user info is null.");
            throw new IsmException("Invalid parameters.Please check your input value!");
        }
        SftpClient ch = null;
        try {
            String firstIp = null;
            if (info.getDeviceVersion() == DeviceVersion.T18000) {
                String[] ips = info.getIp().split(",");
                firstIp = ips[0];
            } else {
                firstIp = info.getIp();
            }
            ch = PerfStatHisSftp.connect(firstIp, info.getUserName(), info.getPassword(), info.getPort());
            PerfStatHisSftp.releaseConn(ch);
        }
        catch (Exception e) {
            log.error("connect failed.DeviceInfo:" + info + ",", (Throwable)e);
        }
    }

    private static void setDevicePort(String devicePort, DeviceInfo info) {
        if (!ConnManager.isEmpty(devicePort)) {
            try {
                info.setPort(Integer.parseInt(devicePort));
            }
            catch (NumberFormatException ne) {
                log.error("device port is invaild.");
            }
        }
    }

    private static String getCtlIp(List<String> innerIP, int port) {
        String ip = "";
        for (String string : innerIP) {
            ip = string;
            if (!AbstractSftp.isSftpCanConnected(ip, port, 1)) continue;
            return ip;
        }
        if ("".equals(ip)) {
            log.error("no inner ip can use.");
            throw new IsmException("no inner ip can use.");
        }
        return ip;
    }

    private static boolean isEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }

    public static List<String> getDeviceIDList() {
        return new ArrayList<String>(DEVICE_MAP.keySet());
    }

    public static List<String> getNotSupporDeviceIDList() {
        return new ArrayList<String>(NOT_SUPPORT_DEVICE_MAP.keySet());
    }

    public static HisTLVConnection getConnection(String deviceID) {
        return DEVICE_MAP.get(deviceID).getConn();
    }

    public static User getUser(String deviceID) {
        return DEVICE_MAP.get(deviceID).getUser();
    }

    public static String getDeviceName(String deviceID) {
        return DEVICE_MAP.get(deviceID).getDeviceName();
    }

    public static boolean getIsNewVersionHasManageIp(String deviceID) {
        return DEVICE_MAP.get(deviceID).isNewVersionHasManageIp();
    }

    public static void setIsNewVersionHasManageIp(String deviceID) {
        DEVICE_MAP.get(deviceID).setIsNewVersionHasManageIp(true);
    }

    public static DeviceInfo getDeviceInfo(String deviceID) {
        return DEVICE_MAP.get(deviceID);
    }

    public static Optional<DeviceInfo> getDeviceInfoByIp(String ip) {
        return DEVICE_MAP.values().stream().filter(entry -> entry.getIp().equals(ip)).findFirst();
    }

    public static DeviceInfo getNotSupportDeviceInfo(String deviceID) {
        return NOT_SUPPORT_DEVICE_MAP.get(deviceID);
    }

    public static void setDeviceInfo(DeviceInfo device) {
        DEVICE_MAP.put(device.getDeviceID(), device);
    }

    public static void setNotSupportDeviceInfo(DeviceInfo device) {
        NOT_SUPPORT_DEVICE_MAP.put(device.getDeviceID(), device);
    }

    public static int findRealByteNum(byte[] buff, int bpos, int c) throws IOException {
        if (c >= 65 && c <= 90) {
            buff[bpos++] = (byte)(c - 65);
        } else if (c >= 97 && c <= 122) {
            buff[bpos++] = (byte)(c - 97 + 26);
        } else if (c >= 48 && c <= 57) {
            buff[bpos++] = (byte)(c - 48 + 52);
        } else if (c == 43) {
            buff[bpos++] = 62;
        } else if (c == 47) {
            buff[bpos++] = 63;
        } else if (c == 61) {
            buff[bpos++] = 64;
        } else {
            throw new IOException("Illegal char in base64 code.");
        }
        return bpos;
    }

    private static String getValue(String key) {
        try {
            String value = key.substring(key.indexOf(61) + 1, key.length());
            return value;
        }
        catch (Exception e) {
            log.error("getValue exceptinon:", (Throwable)e);
            throw new IsmException("invalid param!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initWithEService(String[] args) {
        InputStream ins = null;
        File taskFile = null;
        try {
            String sec = ConnManager.getValue(args[2]);
            String xml = ConnManager.getValue(args[1]);
            taskFile = new File(FilePathUtils.filterPath((String)xml));
            ins = new FileInputStream(taskFile);
            ParamHander hander = new ParamHander(ins);
            hander.initLanguage();
            hander.regDevices(sec);
            hander.initParam();
            hander.initWorkPath();
        }
        catch (Exception e) {
            log.error("initWithEService exception:", (Throwable)e);
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException e) {
                    log.error("", (Throwable)e);
                }
            }
            if (taskFile != null && !taskFile.delete()) {
                log.error("delete taskFile error!");
            }
        }
    }

    public static void removeDevice(String id) {
        DEVICE_MAP.remove(id);
    }
}

