/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.utils;

import com.huawei.ism.common.bean.DeviceTypeIsm;
import com.huawei.ism.common.bean.User;
import com.huawei.ism.connection.ConnectionManager;
import com.huawei.ism.connection.HisTLVConnection;
import com.huawei.ism.connection.IConnection;
import com.huawei.ism.connection.SocketPool;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.xve.entity.ExportParam;
import com.huawei.xve.entity.a800.DMESettingInfo;
import com.huawei.xve.entity.a800.DataTurboSettingInfo;
import com.huawei.xve.monitor.eservice.PermanentConnectionMannage;
import com.huawei.xve.utils.ConnManager;
import com.huawei.xve.utils.ControllerInfo;
import com.huawei.xve.utils.DeviceVersion;
import com.huawei.xve.utils.DownloadTime;
import com.huawei.xve.utils.HisUserOpToolData;
import com.huawei.xve.utils.IOTraceParam;
import com.huawei.xve.utils.QuerInfo;
import java.io.Serializable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class DeviceInfo
implements Serializable {
    private static final long serialVersionUID = -2424168480550232345L;
    private DevNode devNode = new DevNode();
    private DeviceVersion deviceVersion;
    private HisTLVConnection iConn;
    private User userIsm;
    private String deviceName;
    String ip;
    private String pubKey;
    private String pubKeyFile;
    private int useSSL = 1;
    private User.USER_SCOPE scope = User.USER_SCOPE.LOCAL;
    private boolean isHasManageIp = true;
    private boolean login = false;
    private Properties properties;
    private DownloadTime downloadTime = new DownloadTime();
    private IOTraceParam ioTraceParam;
    private HisUserOpToolData hisUserData;
    private int controllerNum = 1;
    private String primaryControllerIP;
    private Map<String, ControllerInfo> controllerMap = new Hashtable<String, ControllerInfo>(0);
    private boolean collectionSwitch = false;
    private boolean archiveSwitch = false;
    private Boolean belongSuperAdmin = null;
    private ExportParam exportParam;
    private List<String> notConnectIPBy22 = new ArrayList<String>();
    private List<String> connectIPBy22 = new ArrayList<String>();
    private boolean isEServiceHisCollect = false;
    private DataTurboSettingInfo dataTurboSettingInfo;
    private DMESettingInfo dmeSettingInfo;
    private boolean isA800Cluster = false;
    private boolean isCompressA800 = false;

    public List<String> getConnectIPBy22() {
        return this.connectIPBy22;
    }

    public void addConnectIPBy22(String dvip) {
        this.connectIPBy22.add(dvip);
    }

    public String connectIPBy22toString() {
        StringBuffer name = new StringBuffer();
        for (String string : this.connectIPBy22) {
            name.append(string).append(",");
        }
        return name.substring(0, name.length() - 1);
    }

    public List<String> getNotConnectIPBy22() {
        return this.notConnectIPBy22;
    }

    public void addNotConnectIPBy22(String dvip) {
        this.notConnectIPBy22.add(dvip);
    }

    public String notConnectIPBy22toString() {
        StringBuffer name = new StringBuffer();
        for (String string : this.notConnectIPBy22) {
            name.append(string).append(",");
        }
        return name.substring(0, name.length() - 1);
    }

    public void cleanConnectIPBy22() {
        this.notConnectIPBy22.clear();
        this.connectIPBy22.clear();
    }

    public Boolean isBelongSuperAdmin() {
        if (this.belongSuperAdmin == null) {
            this.belongSuperAdmin = QuerInfo.isSuperrAdmin(this);
        }
        return this.belongSuperAdmin;
    }

    public void setBelongSuperAdmin(Boolean belongSuperAdmin) {
        this.belongSuperAdmin = belongSuperAdmin;
    }

    public String getPrimaryControllerIP() {
        return this.primaryControllerIP;
    }

    public void setPrimaryControllerIP(String primaryControllerIP) {
        this.primaryControllerIP = primaryControllerIP;
    }

    public Map<String, ControllerInfo> getControllerMap() {
        return this.controllerMap;
    }

    public void setControllerMap(Map<String, ControllerInfo> controllerMap) {
        this.controllerMap = controllerMap;
    }

    public boolean isCollectionSwitch() {
        return this.collectionSwitch;
    }

    public void setCollectionSwitch(boolean collectionSwitch) {
        this.collectionSwitch = collectionSwitch;
    }

    public boolean isArchiveSwitch() {
        return this.archiveSwitch;
    }

    public void setArchiveSwitch(boolean archiveSwitch) {
        this.archiveSwitch = archiveSwitch;
    }

    public DevNode getDevNode() {
        return this.devNode;
    }

    public void setDevNode(DevNode devNode) {
        this.devNode = devNode;
    }

    public int getControllerNum() {
        return this.controllerNum;
    }

    public void setControllerNum(int controllerNum) {
        this.controllerNum = controllerNum;
    }

    private void conn() {
        this.creatConn(false);
    }

    public void creatConn(boolean usePermanent) {
        Properties prop = new Properties();
        prop.put("USER_NAME", ConnManager.getDeviceInfo(this.devNode.getDeviceSerialNumber()).getUserName());
        prop.put("USER_WORD", ConnManager.getDeviceInfo(this.devNode.getDeviceSerialNumber()).getPassword());
        prop.put("USERSCOPE", String.valueOf(0));
        prop.put("IP_OR_NAME", ConnManager.getDeviceInfo(this.devNode.getDeviceSerialNumber()).getIp());
        prop.put("PORT", "8080");
        prop.put("CONN_PROTOCOL", String.valueOf(1));
        prop.put("TIME_OUT_PROPERTY", String.valueOf(30));
        HisTLVConnection conn = (HisTLVConnection)ConnectionManager.getInstance().buildConnection(DeviceTypeIsm.C3.name(), prop);
        SocketPool socketPool = new SocketPool(this.getIp(), 8080, this.getUseSSL(), 2);
        conn.setSocketPool(socketPool);
        User user = null;
        user = usePermanent ? PermanentConnectionMannage.getInstance().authenticateByTlvInfo(this, conn) : conn.authenticate();
        if (user == null) {
            return;
        }
        ConnectionManager.getInstance().setConnection(this.devNode.getDeviceSerialNumber(), (IConnection)conn);
        ConnectionManager.getInstance().setSocketPoolByDeviceID(this.devNode.getDeviceSerialNumber(), socketPool);
        this.setConn(conn);
        this.setUser(user);
        this.login = true;
    }

    public IOTraceParam getIoTraceParam() {
        return this.ioTraceParam;
    }

    public void setIoTraceParam(IOTraceParam ioTraceParam) {
        this.ioTraceParam = ioTraceParam;
    }

    public DownloadTime getDownloadTime() {
        return this.downloadTime;
    }

    public void setDownloadTime(DownloadTime downloadTime) {
        this.downloadTime = downloadTime;
    }

    public HisTLVConnection getConn() {
        if (this.iConn == null) {
            this.conn();
        }
        return this.iConn;
    }

    public boolean hasTlvConn() {
        return this.iConn != null;
    }

    public User getUser() {
        if (this.userIsm == null) {
            this.conn();
        }
        return this.userIsm;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getIp() {
        return this.ip;
    }

    public void setConn(HisTLVConnection conn) {
        this.iConn = conn;
    }

    public void setUser(User user) {
        this.userIsm = user;
    }

    public void setDeviceName(String deviceName) {
        this.devNode.setDeviceName(Normalizer.normalize(deviceName, Normalizer.Form.NFKC));
        this.deviceName = Normalizer.normalize(deviceName, Normalizer.Form.NFKC);
    }

    public void setIp(String ip) {
        this.devNode.setIp(Normalizer.normalize(ip, Normalizer.Form.NFKC));
        this.ip = Normalizer.normalize(ip, Normalizer.Form.NFKC);
    }

    public String getDeviceID() {
        return this.devNode.getDeviceSerialNumber();
    }

    public String getUserName() {
        return this.devNode.getLoginUser().getUserName();
    }

    public String getPassword() {
        return this.devNode.getLoginUser().getPassword();
    }

    public int getUseSSL() {
        return this.useSSL;
    }

    public User.USER_SCOPE getScope() {
        return this.scope;
    }

    public void setDeviceID(String deviceID) {
        this.devNode.setDeviceSerialNumber(Normalizer.normalize(deviceID, Normalizer.Form.NFKC));
    }

    public void setUserName(String userName) {
        this.devNode.getLoginUser().setUserName(Normalizer.normalize(userName, Normalizer.Form.NFKC));
    }

    public void setPassword(String password) {
        this.devNode.getLoginUser().setPassword(password);
    }

    public void setUseSSL(int useSSL) {
        this.useSSL = useSSL;
    }

    public void setScope(User.USER_SCOPE scope) {
        this.scope = scope;
    }

    public boolean isNewVersionHasManageIp() {
        return this.isHasManageIp;
    }

    public void setIsNewVersionHasManageIp(boolean isHasManageIp1) {
        this.isHasManageIp = isHasManageIp1;
    }

    public String getPubKey() {
        return this.pubKey;
    }

    public void setPubKey(String pubKey) {
        this.pubKey = pubKey;
    }

    public String getPubKeyFile() {
        return this.pubKeyFile;
    }

    public void setPubKeyFile(String pubKeyFile) {
        this.pubKeyFile = pubKeyFile;
    }

    public int getPort() {
        return this.devNode.getPort();
    }

    public void setPort(int port) {
        this.devNode.setPort(port);
    }

    public boolean isLogin() {
        return this.login;
    }

    public void setLogin(boolean login1) {
        this.login = login1;
    }

    public DeviceVersion getDeviceVersion() {
        return this.deviceVersion;
    }

    public void setDeviceVersion(DeviceVersion deviceVersion) {
        this.deviceVersion = deviceVersion;
    }

    public String toString() {
        return "DeviceInfo [deviceVersion=" + (Object)((Object)this.deviceVersion) + ", deviceID=" + this.devNode.getDeviceSerialNumber() + ", userName=" + this.devNode.getLoginUser().getUserName() + ", deviceName=" + this.deviceName + ", password=********, port=" + this.devNode.getPort() + "]";
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setdVersion(String version) {
        this.devNode.setProductVersion(Normalizer.normalize(version, Normalizer.Form.NFKC));
    }

    public String getdVersion() {
        return this.devNode.getProductVersion();
    }

    public String getdType() {
        return this.devNode.getDeviceType().toString();
    }

    public void setdType(String type) {
        this.devNode.setDeviceType(DeviceType.valueOf((String)Normalizer.normalize(type, Normalizer.Form.NFKC)));
    }

    public String getIOTraceErrMsg() {
        if (this.ioTraceParam == null || this.ioTraceParam.getIOTraceErrMsg() == null) {
            return null;
        }
        return this.ioTraceParam.getIOTraceErrMsg().getErrMsg();
    }

    public void setIOTraceErrMsg(String msg) {
        if (this.ioTraceParam == null) {
            return;
        }
        this.ioTraceParam.setIOTraceErrMsg(msg);
    }

    public HisUserOpToolData getHisUserData() {
        return this.hisUserData;
    }

    public void setHisUserData(HisUserOpToolData hisUserData) {
        this.hisUserData = hisUserData;
    }

    public ExportParam getExportParam() {
        return this.exportParam;
    }

    public void setExportParam(ExportParam exportParam) {
        this.exportParam = exportParam;
    }

    public boolean isEServiceHisCollect() {
        return this.isEServiceHisCollect;
    }

    public void setEServiceHisCollect(boolean isEServiceHisCollect) {
        this.isEServiceHisCollect = isEServiceHisCollect;
    }

    public DataTurboSettingInfo getDataTurboSettingInfo() {
        return this.dataTurboSettingInfo;
    }

    public void setDataTurboSettingInfo(DataTurboSettingInfo dataTurboSettingInfo) {
        this.dataTurboSettingInfo = dataTurboSettingInfo;
    }

    public DMESettingInfo getDmeSettingInfo() {
        return this.dmeSettingInfo;
    }

    public void setDmeSettingInfo(DMESettingInfo dmeSettingInfo) {
        this.dmeSettingInfo = dmeSettingInfo;
    }

    public boolean isA800Cluster() {
        return this.isA800Cluster;
    }

    public void setA800Cluster(boolean isA800Cluster) {
        this.isA800Cluster = isA800Cluster;
    }

    public boolean isCompressA800() {
        return this.isCompressA800;
    }

    public void setCompressA800(boolean isCompressA800) {
        this.isCompressA800 = isCompressA800;
    }
}

