/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.utils;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.util.VerifyUtil;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import com.huawei.xve.monitor.perfstat.PerfStatHistoryPane;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DeviceVersion {
    V3R3,
    V3R1,
    T18000,
    V3R3C20,
    TV1;

    private static final Logger log;
    private static final org.apache.log4j.Logger LOGGER;
    private static String v3r3Support;
    private static String TV1Support;
    private static String specialDeviceType;
    private static String doradoV6;
    private static String oceanProtectV1;

    public static DeviceVersion getDeviceVersion(String version, String devType) {
        if (DeviceVersion.checkSpecialDev(version = Normalizer.normalize(version, Normalizer.Form.NFKC).toUpperCase(Locale.ENGLISH), devType, specialDeviceType)) {
            return V3R3;
        }
        if (DeviceVersion.checkSpecialDev(version, devType, doradoV6)) {
            return V3R3;
        }
        if (DeviceVersion.checkSpecialDev(version, devType, oceanProtectV1)) {
            return V3R3;
        }
        if (DeviceVersion.checkDevIsTV1(version, devType)) {
            return TV1;
        }
        return DeviceVersion.getDeviceVersion(version);
    }

    public static DeviceVersion getDeviceVersion(String version) {
        if (!VerifyUtil.isEmpty(v3r3Support) && PerfStatHistoryPane.isVersionAfter(version, v3r3Support)) {
            return V3R3;
        }
        if (VerifyUtil.isEmpty(version)) {
            return V3R1;
        }
        if (version.contains("T18000")) {
            return T18000;
        }
        return V3R1;
    }

    private static boolean checkDevIsTV1(String version, String devType) {
        if (devType.contains("HVS")) {
            return false;
        }
        return devType.contains("T") && !VerifyUtil.isEmpty(TV1Support) && version.contains("V100") && PerfStatHistoryPane.isVersionAfter(version, TV1Support);
    }

    public static boolean checkSpecialDev(String version, String devType, String rule) {
        boolean isSpecialDev = false;
        JSONObject jo = null;
        try {
            jo = new JSONObject(rule);
            if (jo == null || jo.length() < 1) {
                LOGGER.info((Object)"no special devType config.");
                return isSpecialDev;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"invalid specialDevType config.please check the config file.", (Throwable)e);
            return isSpecialDev;
        }
        Iterator keys = jo.keys();
        String key = null;
        while (keys.hasNext()) {
            key = (String)keys.next();
            try {
                if (!devType.contains(key) || !PerfStatHistoryPane.isVersionAfter(version, jo.getString(key))) continue;
                isSpecialDev = true;
                break;
            }
            catch (JSONException e) {
                LOGGER.error((Object)"invalid specialDevType config.check the config file.", (Throwable)e);
            }
        }
        return isSpecialDev;
    }

    public static boolean isMayUsePmsCollectDevice(String devType) {
        return Arrays.stream(HisResourceManager.getCfgProperties().getProperty("MAY_USE_PMS_COLLECT_DEVICE_MODELS").split(",")).anyMatch(type -> type.trim().equals(devType));
    }

    public static boolean isCollectByPmsDevice(String devType) {
        return Arrays.stream(HisResourceManager.getCfgProperties().getProperty("COLLECT_BY_PMS_DEVICE_MODELS").split(",")).anyMatch(type -> type.trim().equals(devType));
    }

    public static boolean needCollectByPms(String productVersion) {
        return productVersion.matches("\\d+\\.\\d+.*") ? PerfStatHistoryPane.isVersionAfter(productVersion, "6.0.1") : PerfStatHistoryPane.isVersionAfter(productVersion, "V700R001C00");
    }

    static {
        log = LoggerFactory.getLogger(DeviceVersion.class);
        LOGGER = org.apache.log4j.Logger.getLogger(DeviceVersion.class);
        v3r3Support = HisResourceManager.getCfgProperties().getProperty("V3R3_SUPPORT_VERSION");
        TV1Support = HisResourceManager.getCfgProperties().getProperty("TV1_VERSION");
        specialDeviceType = HisResourceManager.getCfgProperties().getProperty("WORKLOAD_SPECIAL_DEVICETYPE_VERSION");
        doradoV6 = HisResourceManager.getCfgProperties().getProperty("DORADO_V6");
        oceanProtectV1 = HisResourceManager.getCfgProperties().getProperty("OCEANPROTECT_V1");
    }
}

