/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.utils;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class DownloadTime
implements Serializable {
    private static final long serialVersionUID = -479803326475064011L;
    private static final String FINISH = HisResourceManager.getString("FINISH_PERF_TIMELEFT");
    private static final String NOT_FINISH = HisResourceManager.getString("NOT_FINISH_PERF_TIMELEFT");
    private long download = 5000L;
    private AtomicInteger remainingFileNum = new AtomicInteger(0);
    private int totalFileNum;
    private int downloadFileCount;
    private volatile long lastSuccessTime = 0L;
    private final List<Long> downloadTimes = new ArrayList<Long>();

    public long getRemainTime() {
        return (long)this.remainingFileNum.get() * this.download;
    }

    public String getRemainTimeStr() {
        long remainTimeMS = this.getRemainTime();
        if (remainTimeMS == 0L) {
            return FINISH;
        }
        long remainTime = remainTimeMS / 1000L;
        return DownloadTime.timeLeftToString(remainTime);
    }

    public static String timeLeftToString(long remainTime) {
        long day = 0L;
        long hour = remainTime / 3600L;
        long min = remainTime % 3600L / 60L;
        long secend = remainTime % 3600L % 60L;
        if (hour >= 24L) {
            day = hour / 24L;
            hour %= 24L;
        }
        if (day > 0L) {
            return day + HisResourceManager.getString("DAY_PERF_TIMELEFT") + hour + HisResourceManager.getString("HOUE_PERF_TIMELEFT") + min + HisResourceManager.getString("MINUTE_PERF_TIMELEFT") + secend + HisResourceManager.getString("SECOND_PERF_TIMELEFT");
        }
        if (DownloadTime.notFinish(hour, min, secend)) {
            return NOT_FINISH;
        }
        return hour + HisResourceManager.getString("HOUE_PERF_TIMELEFT") + min + HisResourceManager.getString("MINUTE_PERF_TIMELEFT") + secend + HisResourceManager.getString("SECOND_PERF_TIMELEFT");
    }

    public synchronized int addCount() {
        return ++this.downloadFileCount;
    }

    public int getTotalFileNum() {
        return this.totalFileNum;
    }

    public void setTotalFileNum(int totalFileNum) {
        this.totalFileNum = totalFileNum;
    }

    public void init(int totalFileNum) {
        this.init(totalFileNum, totalFileNum);
    }

    public void init(int totalFileNum, int needDownload) {
        this.totalFileNum = totalFileNum;
        this.remainingFileNum.set(needDownload);
        this.downloadFileCount = totalFileNum - needDownload;
        this.lastSuccessTime = System.currentTimeMillis();
    }

    public synchronized boolean addDownloadTimes(Long downloadTime) {
        return this.downloadTimes.add(downloadTime);
    }

    public AtomicInteger getRemainingFileNum() {
        return this.remainingFileNum;
    }

    public void setRemainingFileNum(AtomicInteger remainingFileNum) {
        this.remainingFileNum = remainingFileNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refresh() {
        List<Long> list = this.downloadTimes;
        synchronized (list) {
            if (!this.downloadTimes.isEmpty()) {
                this.download = this.avgTime(this.downloadTimes);
                this.downloadTimes.clear();
            }
        }
    }

    public long getDownload() {
        return this.download;
    }

    private synchronized long avgTime(List<Long> downloadTime) {
        long sum = 0L;
        for (Long time : downloadTime) {
            sum += time.longValue();
        }
        return sum / (long)downloadTime.size();
    }

    public int getProgress() {
        return this.downloadFileCount * 100 / this.totalFileNum;
    }

    private static boolean notFinish(long hour, long min, long s) {
        return hour == 0L && min == 0L && s == 0L;
    }

    public long getLastSuccessTime() {
        return this.lastSuccessTime;
    }

    public void setLastSuccessTime(long lastSuccessTime) {
        this.lastSuccessTime = lastSuccessTime;
    }
}

