/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.utils;

import com.huawei.ism.connection.HisTLVConnection;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.tlv.EnumDefine;
import com.huawei.ism.tlv.TLVMsgDefine;
import com.huawei.ism.tlv.TLVTag;
import com.huawei.ism.tlv.TLVUtils;
import com.huawei.ism.tlv.bean.Param;
import com.huawei.ism.tlv.docoder.ParamType;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.log4j.Logger;

public class ExportUtil {
    private static final Logger LOGGER = Logger.getLogger(ExportUtil.class);
    public static final int SUCCESS = 0;
    public static final int FAIL = 1;
    public static final long RECORD_OPERATION_LOG = 55847747739L;

    public static void closeStream(Closeable stre) {
        if (null != stre) {
            try {
                stre.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"Close inputStream error", (Throwable)e);
            }
            finally {
                stre = null;
            }
        }
    }

    public static void closeStream(OutputStream osm) {
        if (null != osm) {
            try {
                osm.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"Close outputStream error", (Throwable)e);
            }
            finally {
                osm = null;
            }
        }
    }

    public static void sendOperLog(HisTLVConnection conn, String filename, EnumDefine.FILE_ID_E fileType, int ret) {
        filename = filename.substring(filename.lastIndexOf("/") + 1);
        try {
            conn.invoke(55847747739L, (List<Param>)TLVUtils.paramList((Param[])new Param[]{TLVUtils.newParam((TLVTag)OPERATIONLOG.FILENAME, (String)filename), TLVUtils.newParam((TLVTag)OPERATIONLOG.FILETYPE, (int)fileType.getValue()), TLVUtils.newParam((TLVTag)OPERATIONLOG.OPERTYPE, (int)1), TLVUtils.newParam((TLVTag)OPERATIONLOG.RETVALUE, (int)ret)}), 10);
        }
        catch (IsmException e) {
            LOGGER.error((Object)("sendoperlog failed. filename" + filename + "result:" + ret), (Throwable)e);
        }
    }

    public static enum ExportResourceOperatorEnum {
        RUNNING_DATA,
        CONFIG_FILE;

    }

    public static class OPERATIONLOG
    extends TLVMsgDefine {
        public static final TLVTag OPERTYPE = new TLVTag("OPERTYPE", 0, ParamType.UNSIGN_INT);
        public static final TLVTag FILETYPE = new TLVTag("FILETYPE", 1, ParamType.ENUM);
        public static final TLVTag FILENAME = new TLVTag("FILENAME", 2, ParamType.STRING);
        public static final TLVTag RETVALUE = new TLVTag("RETVALUE", 3, ParamType.UNSIGN_INT);
    }
}

