/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.utils;

import com.huawei.ism.util.VerifyUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUtil.class);
    private static final org.apache.log4j.Logger LOGGER = org.apache.log4j.Logger.getLogger(FileUtil.class);

    public static boolean deleteDir(String folder) {
        try {
            File file = new File(folder);
            if (!file.isDirectory()) {
                if (!file.delete()) {
                    log.error("delete file:{} failed.", (Object)file.getName());
                }
            } else if (file.isDirectory()) {
                FileUtil.conditionForList(folder, file);
            }
            return true;
        }
        catch (Exception e) {
            log.error("delete {} failed.", (Object)folder, (Object)e);
            return false;
        }
    }

    private static void conditionForList(String folder, File file) {
        String[] filelist = file.list();
        if (filelist != null) {
            for (int i = 0; i < filelist.length; ++i) {
                File delfile = new File(folder + File.separator + filelist[i]);
                if (!delfile.isDirectory()) {
                    if (delfile.delete()) continue;
                    LOGGER.error((Object)("delete file:" + delfile.getName() + " failed."));
                    continue;
                }
                if (!delfile.isDirectory()) continue;
                FileUtil.deleteDir(folder + File.separator + filelist[i]);
            }
        }
        if (!file.delete()) {
            LOGGER.error((Object)("delete file:" + file.getName() + " failed."));
        }
    }

    public static boolean mkdirs(String path) {
        if (path == null) {
            return false;
        }
        try {
            File file = new File(path);
            if (file.exists()) {
                return file.isDirectory();
            }
            return file.mkdirs();
        }
        catch (Exception e) {
            LOGGER.error((Object)("error when create dir " + path), (Throwable)e);
            return false;
        }
    }

    public static void closeStream(Closeable closeable) {
        if (VerifyUtil.isEmpty(closeable)) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException e) {
            LOGGER.error((Object)"close stream failed.", (Throwable)e);
        }
    }

    public static String formatIpForPath(String ip) {
        return ip.replace(":", "_");
    }
}

