/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.utils;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.util.StringUtils;
import com.huawei.xve.entity.a800.DataTurboSettingInfo;
import com.huawei.xve.entity.a800.DpcClusterNode;
import com.huawei.xve.entity.a800.ErrorResponse;
import com.huawei.xve.entity.a800.HisPerstatException;
import com.huawei.xve.entity.a800.QueryTaskDetailStatus;
import com.huawei.xve.utils.DeviceInfo;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HisPerfstatUtil {
    private static final Logger log = LoggerFactory.getLogger(HisPerfstatUtil.class);
    public static final String TEMP = "temp";
    public static final SimpleDateFormat DATE_FORMATTER_BY_DAY = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat DATE_FORMATTER_BY_SEC = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter DATE_TIME_FORMATTER_BY_SEC = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter DATE_TIME_FORMATTER_BY_DAY = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter DATE_TIME_FORMATTER_YMD = DateTimeFormatter.ofPattern("yyyyMMdd");
    public static final String EARLIEST_TIME_SEC = "2000-1-1 00:00:00";
    public static final String EARLIEST_TIME_DAY = "2000-1-1";
    public static final int INIT_TIME = 0;
    public static final long ONE_HOUR_MS = TimeUnit.HOURS.toMillis(1L);
    public static final String A800_DEVICE_TYPE = "OceanStor A800";
    public static final String A800_MAIN_SCENE = "Troubleshooting";
    public static final String A800_SUB_SCENE = "IntelligentCompute_A800_History";
    public static final String SCENE_INFO_KEY = "jsonScene";
    public static final int MAX_DPC_NUMBER = 200;
    public static final int MAX_PAGE_NUMBER = 1000;
    public static final long QUERY_DETAIL_OVERTIME_MILLS = TimeUnit.MINUTES.toMillis(90L);
    public static final long CONFIG_TASK_OVERTIME_MILLS = TimeUnit.MINUTES.toMillis(20L);
    public static final int POLLING_SLEEP_TIME_SECONDS = 30;
    public static final String ZIP_SUFFIX = ".zip";
    public static final String ALL_FILES = "/*";

    public static String getAndClearTempFile(String ip) {
        String tempPath = String.join((CharSequence)File.separator, ApplicationContext.getInstance().getWorkPath(), TEMP, ip.replaceAll(":", "_"));
        FileUtils.deleteFile((File)new File(tempPath));
        return tempPath;
    }

    public static synchronized String formatDate(long time, String timeFormat) {
        if (time == 0L) {
            return "";
        }
        Date date = new Date();
        date.setTime(time);
        return StringUtils.formatDate(date, timeFormat);
    }

    public static boolean isA800Zone(DeviceInfo deviceInfo) {
        return Optional.ofNullable(deviceInfo).map(DeviceInfo::getDevNode).map(DevNode::getDeviceType).map(Object::toString).filter(deviceType -> Objects.equals(deviceType, ItDeviceType.A800_NODE.getName())).isPresent();
    }

    public static boolean isA800Om(DeviceInfo deviceInfo) {
        return Optional.ofNullable(deviceInfo).map(DeviceInfo::getDevNode).map(DevNode::getDeviceType).map(Object::toString).filter(deviceType -> Objects.equals(deviceType, ItDeviceType.A800_OM.getName())).isPresent();
    }

    public static List<DeviceInfo> getA800Zones(List<DeviceInfo> devices) {
        return devices.stream().filter(HisPerfstatUtil::isA800Zone).collect(Collectors.toList());
    }

    public static boolean isa800Dme(DeviceInfo deviceInfo) {
        return Optional.ofNullable(deviceInfo).map(DeviceInfo::getDevNode).map(DevNode::getDeviceType).map(Object::toString).filter(deviceType -> Objects.equals(deviceType, ItDeviceType.DME_NODE.getName())).isPresent();
    }

    public static boolean isSupportA800Scene() {
        return SceneUtils.isScene() && SceneUtils.isSpecialScence((String)System.getenv(SCENE_INFO_KEY), (String[])new String[]{A800_MAIN_SCENE}) && SceneUtils.isSpecialScence((String)SceneUtils.getCurrentSubScene(), (String[])new String[]{A800_SUB_SCENE});
    }

    public static long getTimeMills(JTextField time) {
        try {
            return HisPerfstatUtil.nonNullTime(time) ? DATE_FORMATTER_BY_SEC.parse(time.getText()).getTime() : 0L;
        }
        catch (ParseException e) {
            log.error("parse time failed.", (Throwable)e);
            return 0L;
        }
    }

    private static boolean nonNullTime(JTextField time) {
        return Objects.nonNull(time) && !StringUtils.isNULLStr(time.getText());
    }

    public static List<String> getDpcSelectNodeIds(DataTurboSettingInfo settingInfo) {
        return settingInfo.getDpcClusterNodes().stream().filter(ClusterNode::isSelected).map(DpcClusterNode::getDpcNodeId).collect(Collectors.toList());
    }

    public static List<DpcClusterNode> getDpcSelectNodes(DataTurboSettingInfo settingInfo) {
        return settingInfo.getDpcClusterNodes().stream().filter(ClusterNode::isSelected).collect(Collectors.toList());
    }

    public static List<String> getCollectedDpcIds(DataTurboSettingInfo settingInfo) {
        return settingInfo.getDpcClusterNodes().stream().filter(DpcClusterNode::isCollected).map(DpcClusterNode::getDpcNodeId).collect(Collectors.toList());
    }

    public static boolean isCollectingStatus(int status) {
        return status == QueryTaskDetailStatus.INIT.getStatus() || status == QueryTaskDetailStatus.RUNNING.getStatus();
    }

    public static String spliceErrorInfo(HisPerstatException exception) {
        ErrorResponse errorResponse;
        StringBuilder errorInfo = new StringBuilder(exception.getErrorMsg());
        int statusCode = exception.getStatusCode();
        if (statusCode != -1) {
            errorInfo.append(HisResourceManager.getStringWithParams("historydata.a800.export.dme.status.code.error", statusCode));
        }
        if (Objects.nonNull(errorResponse = exception.getErrorResponse()) && !StringUtils.hasNULLStr(errorResponse.getErrorCode(), errorResponse.getErrorMsg())) {
            errorInfo.append(HisResourceManager.getStringWithParams("historydata.a800.export.response.error", errorResponse.getErrorCode(), errorResponse.getErrorMsg()));
        }
        return errorInfo.toString();
    }
}

