/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.utils;

import com.huawei.ism.util.VerifyUtil;
import com.huawei.xve.utils.IOTaceErrMsg;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class IOTraceParam
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(IOTraceParam.class);
    private static final long serialVersionUID = 6921443407155065176L;
    private static final long ONE_MIN = 60000L;
    private static final int TWO_HOUR = 120;
    private static final long IMMEDIAT = 0L;
    private static final long TASK_PREPARE_TIME = TimeUnit.SECONDS.toMillis(15L);
    private AtomicInteger downloadFileNum = new AtomicInteger(0);
    private List<Long> lunIDList;
    private long startTime;
    private int duration;
    private String localPath;
    private String parentFileName;
    private List<String> errorIdList = new ArrayList<String>();
    private IOTaceErrMsg ioTraceErrMsg;
    private boolean haveIOTraceFileProduce = false;

    public long getProgress(boolean isError) {
        long curr = System.currentTimeMillis();
        long progress = 0L;
        if (curr <= this.startTime) {
            return progress;
        }
        if (curr >= this.getEndTime()) {
            progress = 100L;
            return isError ? progress - 1L : progress;
        }
        long runTime = (curr - this.startTime) / 60000L;
        return runTime * 100L / (long)this.duration;
    }

    public List<String> getErrorIdList() {
        if (this.errorIdList == null) {
            this.errorIdList = new ArrayList<String>();
        }
        return this.errorIdList;
    }

    public void setErrorIdList(List<String> errorIdList) {
        this.errorIdList = errorIdList;
    }

    public long getEndTime() {
        return this.startTime + this.getDurationMills();
    }

    public List<Long> getLunIDList() {
        return this.lunIDList;
    }

    public void setLunIDList(String lunIDs) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("start process lunId String. lunIds = " + lunIDs));
        }
        String[] idStrList = lunIDs.split(",");
        ArrayList<Long> idList = new ArrayList<Long>();
        for (String id : idStrList) {
            try {
                Long longID = Long.parseLong(id);
                if (16384L <= longID) {
                    this.errorIdList.add(id);
                    continue;
                }
                if (idList.contains(longID)) continue;
                idList.add(longID);
            }
            catch (Exception e) {
                this.getErrorIdList().add(id);
                LOGGER.error((Object)("parse resource id failed, id : " + id));
            }
        }
        this.setLunIDList(idList);
        LOGGER.info((Object)"end process lunId String.");
    }

    public void setLunIDList(List<Long> lunIDList) {
        this.lunIDList = lunIDList;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        if (0L == startTime) {
            startTime = System.currentTimeMillis() + TASK_PREPARE_TIME;
        }
        this.startTime = startTime;
    }

    public int getDuration() {
        return this.duration;
    }

    public long getDurationMills() {
        return (long)this.duration * 60000L;
    }

    public void setDuration(int duration) {
        if (0 > duration) {
            this.duration = 0;
            return;
        }
        if (duration > 120) {
            this.duration = 120;
            return;
        }
        this.duration = duration;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    public IOTaceErrMsg getIOTraceErrMsg() {
        if (VerifyUtil.isEmpty(this.ioTraceErrMsg)) {
            this.ioTraceErrMsg = new IOTaceErrMsg();
        }
        return this.ioTraceErrMsg;
    }

    public void setIOTraceErrMsg(String msg) {
        if (this.ioTraceErrMsg == null) {
            this.ioTraceErrMsg = new IOTaceErrMsg();
        }
        this.ioTraceErrMsg.setErrMsg(msg);
    }

    public String getParentFileName() {
        return this.parentFileName;
    }

    public void setParentFileName(String parentFileName) {
        this.parentFileName = parentFileName;
    }

    public AtomicInteger getDownloadFileNum() {
        return this.downloadFileNum;
    }

    public void setDownloadFileNum(AtomicInteger downloadFileNum) {
        this.downloadFileNum = downloadFileNum;
    }

    public int incrementDownloadFileNum() {
        return this.downloadFileNum.incrementAndGet();
    }

    public boolean isHaveIOTraceFileProduce() {
        return this.haveIOTraceFileProduce;
    }

    public void setHaveIOTraceFileProduce(boolean haveIOTraceFileProduce) {
        this.haveIOTraceFileProduce = haveIOTraceFileProduce;
    }
}

