/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.utils;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.xve.monitor.perfstat.PerfStatHistoryPane;
import com.huawei.xve.utils.DeviceInfo;
import org.apache.log4j.Logger;

public class IOTraceUtil {
    private static final Logger LOGGER = Logger.getLogger(IOTraceUtil.class);
    private static final String SOURCE_FILE_PATH = "/OSM/coffer_log/";
    private static final String V5R7C10_DIR_FILE_PATH = "/OSM/coffer_data/";
    private static final String V5R7C10_SOURCE_FILE_PATH = "/OSM/coffer_data/iotrace/";
    private static final String V5R7_BEGIN_VERSION = HisResourceManager.getCfgProperties().getProperty("IOTRACE_V5R7_SPECIEL_VERSION");
    private static final String GB = "G";
    private static final String MB = "M";
    private static final double AFTER_V5R7C10_SIZE = 2.5;
    private static final double BEFORE_V5R7C10_SIZE = 550.0;

    public static String getSourceFilePath(DeviceInfo di) {
        boolean isV5R7C10 = IOTraceUtil.isV5R7C10OrAfter(di);
        return isV5R7C10 ? V5R7C10_SOURCE_FILE_PATH : SOURCE_FILE_PATH;
    }

    public static String getSourceDirPath(DeviceInfo di) {
        boolean isV5R7C10 = IOTraceUtil.isV5R7C10OrAfter(di);
        return isV5R7C10 ? V5R7C10_DIR_FILE_PATH : SOURCE_FILE_PATH;
    }

    public static boolean isCouldCreateFile(DeviceInfo di, String useSize) {
        String sizeNum = useSize.substring(0, useSize.length() - 1);
        String sizeUnit = useSize.substring(useSize.length() - 1);
        boolean isV5R7C10 = IOTraceUtil.isV5R7C10OrAfter(di);
        double num = -1.0;
        try {
            num = Double.parseDouble(sizeNum);
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)("parse useSize failed. useSzie : " + sizeNum));
        }
        if (-1.0 == num) {
            return false;
        }
        return !(isV5R7C10 ? GB.equals(sizeUnit) && 2.5 < num : MB.equals(sizeUnit) && 550.0 < num);
    }

    public static boolean isV5R7C10OrAfter(DeviceInfo di) {
        return PerfStatHistoryPane.isVersionAfter(di.getdVersion(), V5R7_BEGIN_VERSION);
    }
}

