/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.utils;

import com.huawei.ism.common.bean.User;
import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.connection.HisTLVConnection;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tlv.TLV;
import com.huawei.ism.tlv.TLVMsgDefine;
import com.huawei.ism.tlv.TLVUtils;
import com.huawei.ism.tlv.bean.Param;
import com.huawei.ism.tlv.bean.Record;
import com.huawei.ism.tlv.docoder.ParamType;
import com.huawei.ism.ui.module.perfhis.pojo.HisPerfStatHisFileInfo;
import com.huawei.ism.ui.module.perfhis.service.PerfStatHisFileService;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.ui2.perfstat.util.ISftpTransfer;
import com.huawei.ism.ui2.perfstat.util.PerfStatFile;
import com.huawei.ism.util.Pair;
import com.huawei.ism.util.TimeUtil;
import com.huawei.ism.util.UCD;
import com.huawei.ism.util.VerifyUtil;
import com.huawei.sftp.HisSftpTransfer;
import com.huawei.xve.monitor.perfstat.XVESftpTransfer;
import com.huawei.xve.utils.ConnManager;
import com.huawei.xve.utils.DeviceInfo;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public final class PerfStatUtils {
    private static final Logger LOGGER = Logger.getLogger(PerfStatUtils.class);

    private PerfStatUtils() {
    }

    public static void checkResult(List<?> resultList) {
        if (resultList == null) {
            return;
        }
        for (Object obj : resultList) {
            if (!(obj instanceof Exception)) continue;
            IsmException ismException = null;
            ismException = obj instanceof IsmException ? (IsmException)((Object)obj) : new IsmException(-1L);
            throw ismException;
        }
    }

    public static List<Pair<String, String>> getDefaultCategories() {
        ArrayList<Pair<String, String>> list = new ArrayList<Pair<String, String>>();
        list.add(new Pair((Object)"basicDataTypes", (Object)HisResourceManager.getString("perf.his.ui.basic.datatype")));
        list.add(new Pair((Object)"davancedDataTypes", (Object)HisResourceManager.getString("perf.his.ui.advance.datatype")));
        list.add(new Pair((Object)"allDataTypes", (Object)HisResourceManager.getString("perfstat.addLegend.allDataType")));
        return list;
    }

    public static JTextField createCannotStartWithZeroNumberTextField(long bottom, long top, int lengthLimit, int columns) {
        IsmTextField textField = IsmTextField.getNumberTextField((long)bottom, (long)top, (int)lengthLimit, (int)columns);
        textField.addFocusListener(new FocusAdapter((JTextField)textField){
            final /* synthetic */ JTextField val$textField;
            {
                this.val$textField = jTextField;
            }

            @Override
            public void focusLost(FocusEvent e) {
                String valueString = this.val$textField.getText();
                String str = "";
                if (valueString.startsWith("0")) {
                    int in = 0;
                    try {
                        in = Integer.valueOf(valueString);
                    }
                    catch (NumberFormatException e2) {
                        LOGGER.error((Object)"NumberFormatException");
                    }
                    str = String.valueOf(in);
                    this.val$textField.setText(str);
                }
            }
        });
        return textField;
    }

    public static void setSameWidthAndAlign(int alignment, JLabel ... labels) {
        PerfStatUtils.setSameWidth(labels);
        for (JLabel label : labels) {
            label.setHorizontalAlignment(alignment);
        }
    }

    private static void setSameWidth(JComponent ... components) {
        int maxWidth = 0;
        int width = 0;
        for (JComponent component : components) {
            width = component.getPreferredSize().width;
            maxWidth = width > maxWidth ? width : maxWidth;
        }
        for (JComponent component : components) {
            UCD.setJComponentSize((JComponent)component, (int)(maxWidth + 6), (int)component.getPreferredSize().height);
        }
    }

    public static User getSFTPUser(String deviceID, User.AccessType accessType) {
        return ConnManager.getUser(deviceID);
    }

    public static List<PerfStatFile> getAllPerfStateFile(final String deviceID, JDialog parent) {
        List result = AsyncExcutor.execute((Window)parent, (boolean)true, (long)0L, (Callable[])new Callable[]{new Callable<List<Map<Object, Object>>>(){

            @Override
            public List<Map<Object, Object>> call() {
                return PerfStatUtils.getAllPerfStatFile(deviceID);
            }
        }});
        PerfStatUtils.checkResult(result);
        return PerfStatUtils.getPerfStatFile((List)result.get(0));
    }

    private static List<Map<Object, Object>> getAllPerfStatFile(String deviceID) {
        ArrayList<Param> params = new ArrayList<Param>(0);
        HisTLVConnection conn = PerfStatUtils.getConnection(deviceID);
        List<Record> records = conn.getBatch(55847747632L, params);
        ArrayList<Map<Object, Object>> maps = new ArrayList<Map<Object, Object>>(0);
        TLV.PERFORMANCE_STATISTIC_FILE performanceStatisticFile = null;
        for (Record record : records) {
            if (record.getFieldCount() <= 0) continue;
            performanceStatisticFile = new TLV.PERFORMANCE_STATISTIC_FILE();
            maps.add(TLVUtils.record2Map((Record)record, (TLVMsgDefine)performanceStatisticFile));
        }
        return maps;
    }

    private static List<PerfStatFile> getPerfStatFile(List<Map<Object, Object>> fileList) {
        ArrayList<PerfStatFile> perFileList = new ArrayList<PerfStatFile>(0);
        if (null == fileList) {
            return new ArrayList<PerfStatFile>(0);
        }
        PerfStatFile perfStatFile = null;
        String file = null;
        long time = 0L;
        long size = 0L;
        for (Map<Object, Object> property : fileList) {
            if (property == null || property.get(TLV.PERFORMANCE_STATISTIC_FILE.CMO_STATISTIC_FILE) == null || VerifyUtil.isEmpty((String)property.get(TLV.PERFORMANCE_STATISTIC_FILE.CMO_STATISTIC_FILE))) continue;
            file = (String)property.get(TLV.PERFORMANCE_STATISTIC_FILE.CMO_STATISTIC_FILE);
            time = ((Number)property.get(TLV.PERFORMANCE_STATISTIC_FILE.CMO_FILE_UPDATE_TIME)).longValue();
            size = ((Number)property.get(TLV.PERFORMANCE_STATISTIC_FILE.CMO_FILE_UPDATE_SIZE)).longValue();
            perfStatFile = new PerfStatFile(file, time, size);
            perFileList.add(perfStatFile);
        }
        return perFileList;
    }

    public static HisTLVConnection getConnection(String deviceID) {
        return ConnManager.getConnection(deviceID);
    }

    public static boolean populatePerfStatHisFileInfo(Window parent, HisPerfStatHisFileInfo perfStatHisFileInfo) {
        PerfStatHisFileService.PopulateObjectNamesAndDataTypesTask task = new PerfStatHisFileService.PopulateObjectNamesAndDataTypesTask(perfStatHisFileInfo);
        AsyncExcutor.execute((Window)parent, (boolean)true, (long)0L, (Callable[])new Callable[]{task});
        if (!task.isExecuteSucess()) {
            Exception exception = task.getException();
            DialogUtils.showErrorDialog((Window)parent, (Throwable)exception);
            return false;
        }
        return true;
    }

    public static ISftpTransfer createSftp(String deviceID) {
        User user = PerfStatUtils.getSFTPUser(deviceID, User.AccessType.READ_WRITE);
        DeviceInfo deviceInfo = ConnManager.getDeviceInfo(deviceID);
        if (null == user || null == user.getUserName()) {
            throw new IsmException(1073949187L);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("start to new SftpTransfer,use defualt Ip is: " + PerfStatUtils.getConnection(deviceID).getURL()));
        }
        HisSftpTransfer temp = new HisSftpTransfer(PerfStatUtils.getConnection(deviceID).getURL(), user, deviceInfo.getPort());
        return new XVESftpTransfer(temp);
    }

    public static void deleteArchiveFile(String deviceID, String fileName) {
        Param paramOne = new Param(0, ParamType.STRING, fileName);
        HisTLVConnection conn = PerfStatUtils.getConnection(deviceID);
        conn.invoke(55847747631L, TLVUtils.paramList((Param[])new Param[]{paramOne}));
    }

    public static String gmtToString(Date lastModifyTime, String currentDeviceID) {
        return TimeUtil.gmtToString((Date)lastModifyTime, (TimeZone)TimeZone.getDefault());
    }

    public static void deleteTempPerfHisFile(HisPerfStatHisFileInfo tmpFile) {
        File file = new File(tmpFile.getFileName());
        if (file.exists() && !file.delete() && LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("delete performance temporary file(" + tmpFile.getFileName() + ") fail."));
        }
    }
}

