/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.utils;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.pubservice.entity.ScenePathValue;
import com.huawei.ism.tool.framework.pubservice.sceneimpl.SceneEnvironmentImpl;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.CliResolverUtils;
import com.huawei.ism.tool.obase.utils.SystemMode;
import com.huawei.ism.ui.templets.IsmDialog;
import com.huawei.ism.util.VerifyUtil;
import com.huawei.sftp.AbstractSftp;
import com.huawei.xve.utils.ControllerInfo;
import com.huawei.xve.utils.DeviceInfo;
import com.huawei.xve.utils.DeviceVersion;
import com.huawei.xve.utils.QueryUserPermission;
import java.awt.Window;
import java.io.File;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuerInfo {
    private static final Logger log = LoggerFactory.getLogger(QuerInfo.class);
    private static final String QUERY_STSTEM_TIME = "show system general";
    private static final String QUERY_CONTROLLER_INFO = "show controller general";
    private static final String QUERY_CONTROLLER_INFO_BYTV1 = "showcontroller";
    private static final String QUERY_UPGRADE_PACKAGE = "show upgrade package";
    private static final String QUERY_PERFORMANCE_STATISTIC_ENBLED = "show performance statistic_enabled";
    private static final String QUERY_PERFORMANCE_STRATEGY = "show performance strategy";
    private static final String QUERY_SVP_MANAGEMENT_IP = "show system management_ip";
    private static final String QUERY_PERFFILE_BY_TV1 = "showperffile";
    private static final String SCENE_RESULT_PATH = "jsonSceneResultPath";
    private static final String SHOW_USER_USER_NAME = "show user user_name=%s";
    private static final String ROLE_ID = "Role ID";
    private static final String LEVEL = "Level";
    private static final String SUPER_ADMIN = "Super_admin";
    private static final String SUPER_ADMIN_ROLE_ID = "1";
    private static final String ADMIN = "Admin";
    private static final String ADMIN_ROLE_ID = "2";
    private static final String MONITOR_ROLE_ID = "13";
    private static final int SSH_PORT = 22;
    private static int custWidth = 220;
    private static final String SYS_SHOWCLS = "sys showcls";
    private static final String CONTROLLER_LOCAL_NODE_NAME = "local node id";

    public static int querControllerNum(DeviceInfo di) {
        String result = QuerInfo.exCliBySSH(di, QUERY_CONTROLLER_INFO);
        if (VerifyUtil.isEmpty(result)) {
            log.error("Rseult is empty,cmd is:{},IP is:{}", (Object)QUERY_CONTROLLER_INFO, (Object)di.getIp());
            throw new IsmException(HisResourceManager.getString("QUERY_CONTROLLER_INFO_FALED"));
        }
        Pattern p = Pattern.compile("[-]{4,}");
        String[] list = p.split(result);
        int num = 0;
        for (String string : list) {
            String[] list2;
            for (String string2 : list2 = string.split("\r\n")) {
                String c = string2.replaceAll(" ", "");
                if (!c.equals("HealthStatus:Normal")) continue;
                ++num;
            }
        }
        if (num == 0) {
            num = 8;
        }
        return num;
    }

    public static void querControllerInfo(DeviceInfo di) {
        String[] hotVerlist;
        String[] sofVerlist;
        String result1 = QuerInfo.exCliBySSH(di, QUERY_UPGRADE_PACKAGE);
        if (VerifyUtil.isEmpty(result1)) {
            log.error("Rseult is empty,cmd is:{},IP is:{}", (Object)QUERY_UPGRADE_PACKAGE, (Object)di.getIp());
            throw new IsmException(HisResourceManager.getString("QUERY_CONTROLLER_INFO_FALED"));
        }
        String[] result1List = result1.split("HotPatch Version");
        String sofVer = result1List[0];
        for (String string : sofVerlist = sofVer.split("\r\n")) {
            if (string.indexOf("Controller") == -1) continue;
            String[] con = string.split("[ ]{1,}");
            ControllerInfo conInfo = new ControllerInfo(con[2], con[3], con[4]);
            di.getControllerMap().put(con[2], conInfo);
        }
        String hotVer = result1List[1];
        for (String string : hotVerlist = hotVer.split("\r\n")) {
            if (string.indexOf("Controller") == -1) continue;
            String[] con = string.split("[ ]{1,}");
            di.getControllerMap().get(con[2]).setHotPatchVersion(con[4]);
        }
        QuerInfo.querControllerInfoDetailed(di);
    }

    private static void querControllerInfoDetailed(DeviceInfo di) {
        String[] list;
        String result2 = QuerInfo.exCliBySSH(di, QUERY_CONTROLLER_INFO);
        Pattern p = Pattern.compile("[-]{4,}");
        for (String string : list = p.split(result2)) {
            String[] list2;
            ControllerInfo conInfo = null;
            for (String string2 : list2 = string.split("\r\n")) {
                String c = string2.replaceAll(" ", "");
                if (c.indexOf("Controller:") == -1) continue;
                String[] info = c.split(":");
                conInfo = di.getControllerMap().get(info[1]);
            }
            if (conInfo == null) continue;
            QuerInfo.setConInfo(list2, conInfo, di);
        }
    }

    private static void setConInfo(String[] list2, ControllerInfo conInfo, DeviceInfo di) {
        for (String string2 : list2) {
            String[] info;
            String c = string2.replaceAll(" ", "");
            if (c.indexOf("HealthStatus:") != -1) {
                info = c.split(":");
                conInfo.setHealth(info[1]);
                continue;
            }
            if (c.indexOf("RunningStatus:") != -1) {
                info = c.split(":");
                conInfo.setRunning(info[1]);
                continue;
            }
            if (c.indexOf("Role:") == -1) continue;
            info = c.split(":");
            if (info[1].equals("Master")) {
                di.setPrimaryControllerIP(conInfo.getIp());
            }
            conInfo.setRole(info[1]);
        }
    }

    public static List<String> querControllerIPByTV1(DeviceInfo di) {
        String[] controllerList;
        String result = QuerInfo.exCliBySSH(di, QUERY_CONTROLLER_INFO_BYTV1);
        if (VerifyUtil.isEmpty(result)) {
            log.error("Rseult is empty,cmd is:{},IP is:{}", (Object)QUERY_CONTROLLER_INFO_BYTV1, (Object)di.getIp());
            throw new IsmException(HisResourceManager.getString("QUERY_CONTROLLER_INFO_FALED"));
        }
        ArrayList<String> ips = new ArrayList<String>();
        di.cleanConnectIPBy22();
        Pattern contP = Pattern.compile("[-]{4,}");
        for (String controllerInfo : controllerList = contP.split(result)) {
            if (controllerInfo.indexOf("IP Address for Management") == -1) continue;
            QuerInfo.ipVerifyByTV1(di, controllerInfo, ips);
        }
        return ips;
    }

    private static void ipVerifyByTV1(DeviceInfo di, String controllerInfo, List<String> ips) {
        String[] strList = controllerInfo.split("\r\n");
        String controllerID = null;
        String managementID = null;
        for (String string : strList) {
            Pattern p;
            String[] list;
            if (string.indexOf("Controller ID") != -1 && (list = (p = Pattern.compile("Controller ID[ ]{1,}\\|")).split(string)).length > 1) {
                controllerID = list[1].trim();
            }
            if (string.indexOf("IP Address for Management") == -1 || (list = (p = Pattern.compile("IP Address for Management[ ]{1,}\\|")).split(string)).length <= 1) continue;
            managementID = list[1].trim();
        }
        if (controllerID == null || managementID == null) {
            return;
        }
        if (AbstractSftp.isSftpCanConnected(managementID, 22, 1000)) {
            ips.add(managementID);
            di.addConnectIPBy22(controllerID + "(" + managementID + ")");
        } else {
            di.addNotConnectIPBy22(controllerID + "(" + managementID + ")");
        }
    }

    public static void querPerfEnabled(DeviceInfo di) {
        String result = QuerInfo.exCliBySSH(di, QUERY_PERFORMANCE_STATISTIC_ENBLED);
        if (VerifyUtil.isEmpty(result)) {
            log.error("Rseult is empty,cmd is:{},IP is{}", (Object)QUERY_PERFORMANCE_STATISTIC_ENBLED, (Object)di.getIp());
            throw new IsmException(String.format(Locale.ROOT, "Rseult is empty,cmd is:%s", QUERY_PERFORMANCE_STATISTIC_ENBLED));
        }
        String str = result.replaceAll(" ", "");
        if (str.indexOf("StatisticEnabled:Yes") != -1) {
            di.setCollectionSwitch(true);
        }
    }

    public static void querPerfStrategy(DeviceInfo di) {
        String[] strList1;
        String result = QuerInfo.exCliBySSH(di, QUERY_PERFORMANCE_STRATEGY);
        if (VerifyUtil.isEmpty(result)) {
            log.error("Rseult is empty,cmd is:{},IP is{}", (Object)QUERY_PERFORMANCE_STRATEGY, (Object)di.getIp());
            throw new IsmException(String.format(Locale.ROOT, "Rseult is empty,cmd is:{}", QUERY_PERFORMANCE_STRATEGY));
        }
        for (String string : strList1 = result.split("\r\n")) {
            String str;
            if (string.indexOf("Archive Enabled") == -1 || (str = string.replaceAll(" ", "")).indexOf("ArchiveEnabled:Yes") == -1) continue;
            di.setArchiveSwitch(true);
        }
    }

    public static long querTime(DeviceInfo di) {
        String[] list1;
        String time = null;
        long endTime = 0L;
        String result = QuerInfo.exCliBySSH(di, QUERY_STSTEM_TIME);
        if (result == null || result.equals("")) {
            log.error("Querying device information failed,IP is:{}", (Object)di.getIp());
            throw new IsmException(HisResourceManager.getString("QUERY_DEVICE_NOW_TIME_FALED"));
        }
        for (String string2 : list1 = result.split("\r\n")) {
            if (string2.indexOf("Time") == -1) continue;
            try {
                String c = string2.replaceAll(" ", "");
                String[] list2 = c.split("ime:");
                String[] list3 = list2[1].split("UTC");
                time = list3[0];
            }
            catch (Exception e) {
                log.error("Querying device time failed,IP is:{}", (Object)di.getIp());
            }
        }
        if (time == null || time.equals("")) {
            log.error("Querying device information failed,IP is:{}", (Object)di.getIp());
            throw new IsmException(HisResourceManager.getString("QUERY_DEVICE_NOW_TIME_FALED"));
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd/HH:mm:ss");
        try {
            Date date = sdf.parse(time);
            endTime = date.getTime();
        }
        catch (ParseException e) {
            log.error("Time conversion format failed,IP is:" + di.getIp(), (Throwable)e);
            throw new IsmException(HisResourceManager.getString("TIME_FORMAT_FALED"));
        }
        return endTime;
    }

    public static boolean isSvpIp(DeviceInfo di) {
        String result = QuerInfo.exCliBySSH(di, QUERY_SVP_MANAGEMENT_IP);
        if (VerifyUtil.isEmpty(result)) {
            log.error("Rseult is empty,cmd is:{},IP is:{}", (Object)QUERY_SVP_MANAGEMENT_IP, (Object)di.getIp());
            throw new IsmException(HisResourceManager.getString("QUERY_CONTROLLER_INFO_FALED"));
        }
        return result.indexOf(di.getIp()) == -1;
    }

    public static boolean isSuperrAdmin(DeviceInfo di) {
        if (di.getDeviceVersion() == DeviceVersion.TV1) {
            return "admin".equals(di.getUserName());
        }
        String result = QuerInfo.exCliBySSH(di, String.format(Locale.ROOT, SHOW_USER_USER_NAME, QuerInfo.getUserName(di)));
        if (VerifyUtil.isEmpty(result)) {
            log.error("Rseult is empty,cmd is:{},IP is:{}", (Object)QUERY_PERFFILE_BY_TV1, (Object)di.getIp());
            throw new IsmException(HisResourceManager.getString("QUERY_PERMISSION_FALED"));
        }
        List cliRetList = CliResolverUtils.resloveCliRetToList((String)result);
        if (!cliRetList.isEmpty()) {
            Map retMap = (Map)cliRetList.get(0);
            if (SUPER_ADMIN.equalsIgnoreCase((String)retMap.get(LEVEL)) || ADMIN.equalsIgnoreCase((String)retMap.get(LEVEL))) {
                return true;
            }
            if (SUPER_ADMIN_ROLE_ID.equals(retMap.get(ROLE_ID)) || ADMIN_ROLE_ID.equals(retMap.get(ROLE_ID)) || MONITOR_ROLE_ID.equals(retMap.get(ROLE_ID))) {
                return true;
            }
        }
        return false;
    }

    public static String getUserName(DeviceInfo di) {
        return di.getUserName().startsWith("domain/") ? di.getUserName().replace("domain/", "") : di.getUserName();
    }

    public static String getSceneCollectDir() {
        ScenePathValue scenePathValue = null;
        try {
            scenePathValue = (ScenePathValue)SceneEnvironmentImpl.getInstance().getEnvirValueByKey(SCENE_RESULT_PATH);
        }
        catch (ToolException e) {
            log.error("can't get scene path value", (Throwable)e);
            return "";
        }
        catch (RuntimeException e) {
            log.error("can't get scene path value", (Throwable)e);
            return "";
        }
        if (null == scenePathValue) {
            return "";
        }
        return scenePathValue.getJsonSceneResultPathValue();
    }

    public static String getPerfExportDir() {
        return Paths.get(QuerInfo.getSceneCollectDir(), "HistoryPerstat", "HistoryPerformanceFile").toString();
    }

    public static String getA800ClusterPerfExportDir() {
        return String.join((CharSequence)File.separator, QuerInfo.getPerfExportDir(), "OceanStorA800");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String exCliBySSH(DeviceInfo di, String cmd) {
        String result = null;
        ICliConnection ssh = null;
        try {
            ssh = SshConnectionManager.getSshConnection((DevNode)di.getDevNode(), null, (boolean)true, (boolean)true);
            String echo = ssh.execCmd(cmd);
            if (VerifyUtil.isEmpty(echo)) {
                log.error("Rseult is empty,cmd is {} ,IP is:{}", (Object)cmd, (Object)di.getIp());
                String string = result;
                return string;
            }
            int reference = echo.indexOf(cmd);
            if (reference != -1) {
                result = echo.substring(reference);
            }
        }
        catch (Exception e) {
            log.error("Rseult is empty,cmd is {} ,IP is:{}", (Object)cmd, (Object)di.getIp());
        }
        finally {
            if (null != ssh) {
                SshConnectionManager.releaseConnection((ICliConnection)ssh);
            }
        }
        return result;
    }

    public static void querPermission(DeviceInfo deviceInf, IsmDialog dailog) {
        List enResult = AsyncExcutor.execute((Window)dailog, (String)HisResourceManager.getString("QUERY_PERMISSION_TEXT"), (int)custWidth, (Callable[])new Callable[]{new QueryUserPermission(deviceInf)});
        for (Object o : enResult) {
            if (!(o instanceof IsmException)) continue;
            throw (IsmException)((Object)o);
        }
    }

    public static boolean checkPermissionBySuper(String result) {
        List cliRetList = CliResolverUtils.resloveCliRetToList((String)result);
        if (!cliRetList.isEmpty()) {
            Map retMap = (Map)cliRetList.get(0);
            if (SUPER_ADMIN.equalsIgnoreCase((String)retMap.get(LEVEL))) {
                return true;
            }
            if (SUPER_ADMIN_ROLE_ID.equals(retMap.get(ROLE_ID))) {
                return true;
            }
        }
        return false;
    }

    public static boolean querControllerSpecialIPV6(DeviceInfo di) {
        String result = QuerInfo.exCliBySSH(di, QUERY_UPGRADE_PACKAGE);
        if (VerifyUtil.isEmpty(result)) {
            log.error("Rseult is empty, cmd is:{}, IP is:{}", (Object)QUERY_UPGRADE_PACKAGE, (Object)di.getIp());
            throw new IsmException(HisResourceManager.getString("QUERY_CONTROLLER_INFO_FALED"));
        }
        return QuerInfo.hasSpecificIP(result, di.getIp());
    }

    private static boolean hasSpecificIP(String result, String ip) {
        String[] resultArr = result.split("\r\n\r\n");
        if (resultArr.length != 3) {
            log.error("The command output is incorrect. cmd is :{}, result is :{}", (Object)QUERY_UPGRADE_PACKAGE, (Object)result);
            return false;
        }
        String[] sofVer = resultArr[1].split("\r\n");
        int[] fieldLength = QuerInfo.getFieldLength(sofVer);
        int beginPosition = fieldLength[0] + fieldLength[1] + 4;
        for (int i = 2; i < sofVer.length - 1; ++i) {
            String controllerIp = sofVer[i].trim().substring(beginPosition, beginPosition + fieldLength[2]);
            if (!ip.equals(controllerIp)) continue;
            log.info("The controller IP is the same as the login controller IP. Controller IP : {}", (Object)controllerIp);
            return true;
        }
        return false;
    }

    private static int[] getFieldLength(String[] sofVer) {
        String[] length = sofVer[1].trim().split("\\s+");
        int[] fieldLength = new int[length.length];
        for (int i = 0; i < length.length; ++i) {
            fieldLength[i] = length[i].trim().length();
        }
        return fieldLength;
    }

    public static int querLocalNodeId(DeviceInfo di) {
        String result = SystemMode.excuteCmdInDebugModel((DevNode)di.getDevNode(), (String)SYS_SHOWCLS);
        return QuerInfo.parseNodeId(result);
    }

    private static int parseNodeId(String result) {
        int nodeId = -2;
        if (VerifyUtil.isEmpty(result)) {
            log.error("The command output is incorrect. cmd is :{}, result is :{}", (Object)SYS_SHOWCLS, (Object)result);
            return nodeId;
        }
        String[] resultArr = result.trim().split("\r\n");
        return Integer.parseInt(Arrays.stream(resultArr).filter(StringUtils::isNotBlank).filter(line -> line.contains(CONTROLLER_LOCAL_NODE_NAME)).findFirst().orElse(":-2").split(":")[1].trim());
    }
}

