/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.utils;

import com.huawei.ism.common.resourcemanager.HisResourceManager;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.CliResolverUtils;
import com.huawei.ism.tool.protocol.sftp.SftpTransfer;
import com.huawei.ism.util.VerifyUtil;
import com.huawei.ism.util.XmlFileReaderUtil;
import com.huawei.oss.cn.common.anonymize.FileAnonymizeUtil;
import com.huawei.sftp.AbstractSftp;
import com.huawei.xve.monitor.perfstat.PerfStatHistoryPane;
import com.huawei.xve.utils.DeviceInfo;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.sshd.sftp.client.SftpClient;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import utils.FilesUtil;

public class RunningDataCollect {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(RunningDataCollect.class);
    private static final String EXPORT_RUNNING_DATA = "show file export_path file_type=running_data";
    private static final String DELETE_RUNNING_DATA = "delete file filetype=running_data";
    private static final String CHECK_DEV_XML_PATH = "config/hisPerfStat/collectCongfigDevCheck.xml";
    private static final String PRODUCTVERSION = "productVersion";
    private static final String HOTPATCHVERSION = "hotPatchVersion";
    private static final String DEFAULT_STRING = "default";
    private static final String DORADO = "Dorado";
    private static final String QUERY_UPGRADE_PACKAGE = "show upgrade package";
    private static Map<String, Map<String, String>> needCheckDev = new HashMap<String, Map<String, String>>();
    private static int timeOut = 600;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void collect(DeviceInfo di, String toolPath) throws IsmException {
        ICliConnection ssh;
        File directory;
        String localPath;
        String message;
        Boolean collectResult;
        block12: {
            SftpClient sftp;
            if (!RunningDataCollect.checkVersion(di)) {
                return;
            }
            collectResult = true;
            message = "";
            localPath = toolPath + File.separator + "Running_Data";
            directory = new File(localPath);
            RunningDataCollect.mkRunDataDir(directory);
            String result = null;
            ssh = null;
            try {
                ssh = SshConnectionManager.getSshConnection((DevNode)di.getDevNode(), null, (boolean)true, (boolean)true);
                result = ssh.execCmdWithTimout(EXPORT_RUNNING_DATA, timeOut);
            }
            catch (ToolException e) {
                SshConnectionManager.releaseConnection(ssh);
                throw new IsmException(HisResourceManager.getString("Collect.Running.Data.execCmd.error"), (Throwable)e);
            }
            String path = null;
            RunningDataCollect.resultIsEmpty(di, result);
            path = RunningDataCollect.getPath(path, result.split("\r\n"));
            HashMap resultFailMap = new HashMap();
            if (path == null) {
                message = HisResourceManager.getString("Collect.Running.Data.execCmd.null");
                collectResult = false;
            } else {
                sftp = null;
                sftp = AbstractSftp.connect(di.getIp(), di.getUserName(), di.getPassword(), di.getPort());
                SftpTransfer.downloadFile((String)localPath, (String)path, (SftpClient)sftp);
                AbstractSftp.releaseConn(sftp);
            }
            break block12;
            catch (Exception e) {
                try {
                    LOGGER.error(HisResourceManager.getString("Collect.Running.Data.download.error"), (Throwable)e);
                    message = HisResourceManager.getString("Collect.Running.Data.download.error");
                    collectResult = false;
                }
                catch (Throwable throwable) {
                    AbstractSftp.releaseConn(sftp);
                    throw throwable;
                }
                AbstractSftp.releaseConn(sftp);
            }
        }
        try {
            ssh.execCmdWithTimout(DELETE_RUNNING_DATA, timeOut);
        }
        catch (ToolException e1) {
            LOGGER.error(HisResourceManager.getString("Collect.Running.Data.delete.temp"));
            message = HisResourceManager.getString("Collect.Running.Data.delete.temp");
            collectResult = false;
        }
        SshConnectionManager.releaseConnection((ICliConnection)ssh);
        collectResult = RunningDataCollect.anonymize(localPath, directory, message, collectResult);
        if (!collectResult.booleanValue()) {
            throw new IsmException(message);
        }
    }

    private static void resultIsEmpty(DeviceInfo di, String result) {
        if (VerifyUtil.isEmpty(result)) {
            LOGGER.error("Rseult is empty,cmd is:show file export_path file_type=running_data,IP is:" + di.getIp());
            throw new IsmException(HisResourceManager.getString("Collect.Running.Data.execCmd.null"));
        }
    }

    private static void mkRunDataDir(File directory) {
        if (!directory.exists() && !directory.mkdirs()) {
            LOGGER.error("Failed to create Running_Data directory.");
        }
    }

    private static String getPath(String path, String[] list) {
        for (String string : list) {
            String[] filePath;
            if (string.indexOf("File Path") == -1 || (filePath = string.split(":")).length <= 1) continue;
            path = filePath[1].trim();
        }
        return path;
    }

    private static boolean anonymize(String localPath, File directory, String message, boolean collectResult) {
        File configFile = new File(localPath + File.separator + "config.txt");
        boolean isSussAnonumize = true;
        try {
            isSussAnonumize = FileAnonymizeUtil.anonymizeWithEncoding(configFile.getCanonicalPath(), "utf-8");
        }
        catch (Exception e) {
            isSussAnonumize = false;
        }
        if (!isSussAnonumize) {
            LOGGER.error("apear exception when get file CanonicalPath");
            FilesUtil.clearFolder((File)directory);
            directory.delete();
            message = HisResourceManager.getString("Collect.Running.Data.Anonymize");
            collectResult = false;
            throw new IsmException(message);
        }
        return collectResult;
    }

    private static boolean checkVersion(DeviceInfo di) {
        boolean result = false;
        try {
            if (needCheckDev.isEmpty()) {
                RunningDataCollect.initNeedCheckDev();
            }
            result = RunningDataCollect.checkhotPatchVersion(di);
        }
        catch (Exception e) {
            LOGGER.error("Checking Version is error", (Throwable)e);
            return false;
        }
        return result;
    }

    private static void initNeedCheckDev() throws Exception {
        Document doc = XmlFileReaderUtil.load(CHECK_DEV_XML_PATH);
        if (doc == null) {
            LOGGER.error("doc value is null.");
            return;
        }
        Element root = doc.getRootElement();
        Element defaultEle = root.element(DEFAULT_STRING);
        HashMap<String, String> defaultMap = new HashMap<String, String>();
        Iterator itr = defaultEle.elementIterator();
        while (itr.hasNext()) {
            Element ele = (Element)itr.next();
            defaultMap.put(ele.attributeValue(PRODUCTVERSION), ele.attributeValue(HOTPATCHVERSION));
        }
        needCheckDev.put(DEFAULT_STRING, defaultMap);
        Element doradoEle = root.element(DORADO);
        HashMap<String, String> doradoMap = new HashMap<String, String>();
        Iterator itr2 = doradoEle.elementIterator();
        while (itr2.hasNext()) {
            Element ele = (Element)itr2.next();
            doradoMap.put(ele.attributeValue(PRODUCTVERSION), ele.attributeValue(HOTPATCHVERSION));
        }
        needCheckDev.put(DORADO, doradoMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkhotPatchVersion(DeviceInfo di) {
        String productVersion = di.getDevNode().getProductVersion();
        String deviceType = di.getDevNode().getDeviceType().toString();
        if (deviceType.contains(DORADO)) {
            if (!needCheckDev.get(DORADO).containsKey(productVersion)) {
                LOGGER.info("This device is Dorado,and not a restricted version");
                return true;
            }
        } else if (!needCheckDev.get(DEFAULT_STRING).containsKey(productVersion)) {
            LOGGER.info("This device is default,and not a restricted version");
            return true;
        }
        String result = null;
        ICliConnection ssh = null;
        try {
            ssh = SshConnectionManager.getSshConnection((DevNode)di.getDevNode(), null, (boolean)true, (boolean)true);
            result = ssh.execCmd(QUERY_UPGRADE_PACKAGE);
        }
        catch (Exception e) {
            boolean bl;
            try {
                LOGGER.error("EXE show upgrade package is failure", (Throwable)e);
                bl = false;
            }
            catch (Throwable throwable) {
                SshConnectionManager.releaseConnection(ssh);
                throw throwable;
            }
            SshConnectionManager.releaseConnection((ICliConnection)ssh);
            return bl;
        }
        SshConnectionManager.releaseConnection((ICliConnection)ssh);
        String[] resultList = result.split("HotPatch Version");
        if (resultList.length < 2) {
            LOGGER.info("Result don't has HotPatch Version");
            return false;
        }
        String hotPatchVerResult = resultList[1];
        List mapList = CliResolverUtils.resloveCliRetToList((String)hotPatchVerResult);
        for (Map map : mapList) {
            String hotPatchVer = (String)map.get("Current Version");
            if (StringUtils.isNULLStr((String)hotPatchVer) || RunningDataCollect.checkhotPatchVersion(deviceType, productVersion, hotPatchVer)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkhotPatchVersion(String deviceType, String productVersion, String hotPatchVer) {
        if (deviceType.contains(DORADO)) {
            return PerfStatHistoryPane.isVersionAfter(hotPatchVer, needCheckDev.get(DORADO).get(productVersion));
        }
        return PerfStatHistoryPane.isVersionAfter(hotPatchVer, needCheckDev.get(DEFAULT_STRING).get(productVersion));
    }
}

