/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.xve.utils;

import com.huawei.ism.tool.framework.platform.common.data.UserOpTaskResult;
import com.huawei.ism.tool.framework.platform.common.data.UserOpToolBasicData;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.util.VerifyUtil;
import com.huawei.xve.utils.DeviceInfo;
import com.huawei.xve.utils.HisUserOpToolData;
import org.apache.log4j.Logger;

public class UserBehaviorUtil {
    private static final Logger LOGGER = Logger.getLogger(UserBehaviorUtil.class);

    public static void initUserOpData(DeviceInfo di) {
        HisUserOpToolData hisUserOpData = new HisUserOpToolData();
        hisUserOpData.setDeviceVersion(di.getdVersion());
        hisUserOpData.setDeviceSn(di.getDeviceID());
        hisUserOpData.setDeviceType(di.getdType());
        hisUserOpData.setProxyWay("0");
        hisUserOpData.setAuthWay("0");
        di.setHisUserData(hisUserOpData);
    }

    public static void recordUserOpData(DeviceInfo di, UserOpTaskResult taskResult, HisUserOpToolData.ExportDataTypeEnum exportType) {
        try {
            HisUserOpToolData userData = null;
            if (VerifyUtil.isEmpty(di) || VerifyUtil.isEmpty((Object)di.getHisUserData())) {
                userData = new HisUserOpToolData();
                userData.setTaskStartTime(System.currentTimeMillis());
                userData.setExportDataType(exportType.getValue());
            } else {
                userData = di.getHisUserData();
            }
            UserBehaviorUtil.writeUserOp(userData, taskResult);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to record the user behavior.");
        }
    }

    public static void recordUserOpData(DeviceInfo di, UserOpTaskResult taskResult) {
        try {
            HisUserOpToolData userData = di.getHisUserData();
            UserBehaviorUtil.writeUserOp(userData, taskResult);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to record the user behavior.");
        }
    }

    private static void writeUserOp(HisUserOpToolData userData, UserOpTaskResult taskResult) {
        if (VerifyUtil.isEmpty(userData.getTaskResult()) || userData.getTaskResult().getValue() != UserOpTaskResult.IN_COMPLETE.getValue()) {
            userData.setTaskResult(taskResult);
        }
        if (UserOpTaskResult.IN_COMPLETE.getValue() == taskResult.getValue()) {
            return;
        }
        userData.setTaskEndTime(System.currentTimeMillis());
        UserOpDataSaveUtil.saveUserOpdata((UserOpToolBasicData)userData, null);
    }
}

