/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.file;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.XmlUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FileTypeUtils {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(FileTypeUtils.class);
    private Map<String, String> whiteFileTypeMap = new HashMap<String, String>();
    private Map<String, String[]> blackFileTypeMap = new HashMap<String, String[]>();
    private static FileTypeUtils instance = null;
    private static final Object LOCK = new Object();
    public static final String FILETYPE_PROPERTIES = "/config/filetypes.xml";
    private static final FileTypeUtils DINSTANCE = new FileTypeUtils(false, "/config/filetypes.xml");
    private static String sfileTypeProperties = "";
    private static final String NO_FILE_TYPE = "noFileType";
    private static final String FILE_SUFFIX = "filesuffix";

    private FileTypeUtils(boolean subtools, String filename) {
        LOGGER.info("subtools={},filename={}", (Object)subtools, (Object)filename);
        this.getAllFileType(subtools, filename);
    }

    public static FileTypeUtils getInstance() {
        return FileTypeUtils.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileTypeUtils init() {
        String newSfileTypePrperties = null;
        File file = null;
        newSfileTypePrperties = ApplicationContext.getInstance().getWorkPath() + File.separator + "cfg" + File.separator + "filetypes.xml";
        file = FilePathUtils.checkFile((File)new File(newSfileTypePrperties));
        if (!file.exists()) {
            LOGGER.warn("subtools can not find filetypes.xml,use the default filetypes.xml");
            return DINSTANCE;
        }
        Object object = LOCK;
        synchronized (object) {
            if (!newSfileTypePrperties.equals(sfileTypeProperties)) {
                String sfilename = sfileTypeProperties = newSfileTypePrperties;
                instance = new FileTypeUtils(true, sfilename);
                return instance;
            }
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAllFileType(boolean subtools, String file) {
        InputStream inputStream = null;
        this.blackFileTypeMap.clear();
        this.whiteFileTypeMap.clear();
        try {
            if (subtools && file != null && !"".equals(file) && (inputStream = StreamUtils.createInputStream(FilePathUtils.checkFile((File)new File(file)))) != null) {
                LOGGER.info("success to load toolkit filetypes.xml");
            }
            if (inputStream == null && (inputStream = FileTypeUtils.class.getResourceAsStream(file)) != null) {
                LOGGER.info("success to load filetypes.xml");
            }
            Document doc = XmlUtils.parseDocument(inputStream);
            Element root = doc.getDocumentElement();
            this.readBlackList(root);
            this.readWhiteList(root);
        }
        catch (Throwable e1) {
            try {
                LOGGER.error("fail to load filetypes.xml", e1);
            }
            catch (Throwable throwable) {
                StreamUtils.closeStream(null, inputStream);
                throw throwable;
            }
            StreamUtils.closeStream(null, inputStream);
        }
        StreamUtils.closeStream(null, inputStream);
    }

    private void readWhiteList(Element root) {
        Element itemElement = XmlUtils.getChild(root, "whitefiletype");
        if (null != itemElement) {
            for (Element em : XmlUtils.getChildren(itemElement, "type")) {
                String name = em.getAttribute("name");
                String sametype = em.getAttribute("filetype");
                this.whiteFileTypeMap.put(name, sametype);
            }
        }
    }

    private void readBlackList(Element root) {
        Element itemElement = XmlUtils.getChild(root, "filetype");
        if (null != itemElement) {
            for (Element em : XmlUtils.getChildren(itemElement, "type")) {
                String sametype = em.getAttribute("sametype");
                String[] sametypes = sametype.split(",");
                for (Element sitem : XmlUtils.getChildren(em, "code")) {
                    String filecode = sitem.getAttribute("filecode");
                    if (filecode == null || "".equals(filecode)) continue;
                    this.blackFileTypeMap.put(filecode, sametypes);
                }
            }
        }
    }

    private static String bytesToHexString(byte[] bytes) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bytes == null || bytes.length <= 0) {
            return null;
        }
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    public static String getFileCode(FileInputStream fis) {
        String fileCode = null;
        if (fis == null) {
            return null;
        }
        try {
            byte[] bytes = new byte[10];
            if (fis.read(bytes, 0, bytes.length) != -1) {
                fileCode = FileTypeUtils.bytesToHexString(bytes);
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error("file not exist.");
        }
        catch (IOException e) {
            LOGGER.error("read failed", e);
        }
        return fileCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getFileType(String path) {
        ArrayList<String> realfiletypes = new ArrayList<String>();
        FileInputStream is = null;
        try {
            is = new FileInputStream(path);
            String fileCode = FileTypeUtils.getFileCode(is);
            if (fileCode == null) {
                ArrayList<String> arrayList = realfiletypes;
                return arrayList;
            }
            LOGGER.info("fileCode={},filePath={}", (Object)fileCode, (Object)path);
            for (String keyStr : this.blackFileTypeMap.keySet()) {
                if (!fileCode.toLowerCase(Locale.ENGLISH).startsWith(keyStr.toLowerCase(Locale.ENGLISH))) continue;
                String[] types = this.blackFileTypeMap.get(keyStr);
                Collections.addAll(realfiletypes, types);
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error("file not exist.");
        }
        catch (Exception e) {
            LOGGER.error("read failed", e);
        }
        finally {
            StreamUtils.closeStream(null, is);
        }
        LOGGER.info("filetype={},filePath={}", (Object)realfiletypes, (Object)path);
        return realfiletypes;
    }

    public Map<String, Object> getFileTypeIndex(String filePath) {
        File file = new File(filePath);
        String filename = file.getName();
        HashMap<String, Object> ret = new HashMap<String, Object>();
        boolean noFileType = false;
        int idx = filename.lastIndexOf(".");
        if (idx == -1) {
            noFileType = true;
            idx = 0;
        } else {
            ++idx;
        }
        String filesuffix = filename.substring(idx, filename.length()).toLowerCase(Locale.ENGLISH);
        ret.put(NO_FILE_TYPE, noFileType);
        ret.put(FILE_SUFFIX, filesuffix);
        LOGGER.info("filename={},filesuffix={}", (Object)filename, (Object)filesuffix);
        return ret;
    }

    public boolean matchFileType(String path) {
        if (path == null) {
            return false;
        }
        Map<String, Object> ret = this.getFileTypeIndex(path);
        boolean noFileType = (Boolean)ret.get(NO_FILE_TYPE);
        String suffix = (String)ret.get(FILE_SUFFIX);
        if (this.noFileTypeCheck(noFileType)) {
            return true;
        }
        if (this.whiteTypeCheck(suffix)) {
            return true;
        }
        List<String> realfiletypes = this.getFileType(path);
        if (this.noBlackTypeCheck(suffix, realfiletypes)) {
            return true;
        }
        if (realfiletypes.isEmpty()) {
            LOGGER.info("ismatch={}", (Object)false);
            return false;
        }
        return this.isMatchType(suffix, realfiletypes);
    }

    private boolean isMatchType(String filesuffix, List<String> realfiletypes) {
        boolean match = false;
        for (String realtype : realfiletypes) {
            if (!filesuffix.equals(realtype = realtype.toLowerCase(Locale.ENGLISH))) continue;
            match = true;
            break;
        }
        LOGGER.info("ismatch={}", (Object)match);
        return match;
    }

    private boolean noBlackTypeCheck(String filesuffix, List<String> realfiletypes) {
        boolean isWhiteType = false;
        if (realfiletypes.isEmpty()) {
            boolean ischecktype = false;
            for (Map.Entry<String, String[]> blackFileType : this.blackFileTypeMap.entrySet()) {
                String[] filetypes;
                for (String filetype : filetypes = blackFileType.getValue()) {
                    if (!filesuffix.equals(filetype = filetype.toLowerCase(Locale.ENGLISH))) continue;
                    ischecktype = true;
                }
            }
            if (!ischecktype) {
                isWhiteType = true;
                LOGGER.info("filetype not found in xml configuration. iswhiletype={}", (Object)isWhiteType);
                return isWhiteType;
            }
        }
        return isWhiteType;
    }

    private boolean noFileTypeCheck(boolean noFileType) {
        boolean isWhiteType = false;
        if (noFileType) {
            isWhiteType = true;
            LOGGER.info("noFileType={}", (Object)noFileType);
        }
        return isWhiteType;
    }

    private boolean whiteTypeCheck(String filesuffix) {
        boolean isWhiteType = false;
        for (Map.Entry<String, String> whitetype : this.whiteFileTypeMap.entrySet()) {
            String filetype = whitetype.getValue();
            if (!filesuffix.equals(filetype = filetype.toLowerCase(Locale.ENGLISH))) continue;
            isWhiteType = true;
            LOGGER.info("iswhiletype={}", (Object)isWhiteType);
        }
        return isWhiteType;
    }

    public Map<String, String> getWhiteFileTypeMap() {
        return this.whiteFileTypeMap;
    }

    public void setWhiteFileTypeMap(Map<String, String> whiteFileTypeMap) {
        this.whiteFileTypeMap = whiteFileTypeMap;
    }

    public Map<String, String[]> getBlackFileTypeMap() {
        return this.blackFileTypeMap;
    }

    public void setBlackFileTypeMap(Map<String, String[]> blackFileTypeMap) {
        this.blackFileTypeMap = blackFileTypeMap;
    }
}

