/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.config.resource;

import com.huawei.ism.tool.obase.config.log.ConfigLoggerFactory;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;

public class ConfigResource {
    private Map<Locale, ResourceBundle> bundleMap = new HashMap<Locale, ResourceBundle>();
    private Map<Locale, Set<String>> stringsMap = new HashMap<Locale, Set<String>>();

    public ConfigResource(String resource, String[] supportedLocs, ClassLoader cl) {
        for (String locString : supportedLocs) {
            Locale loc = new Locale(locString);
            ResourceBundle bundle = ResourceBundle.getBundle(resource, loc, cl);
            this.bundleMap.put(loc, bundle);
            HashSet<String> strs = new HashSet<String>();
            Enumeration<String> keys = bundle.getKeys();
            while (keys.hasMoreElements()) {
                strs.add(bundle.getString(keys.nextElement()));
            }
            this.stringsMap.put(loc, strs);
        }
    }

    public Locale checkLocale(String key, String value) {
        Locale loc = null;
        for (ResourceBundle bundle : this.bundleMap.values()) {
            if (null == value || !value.equals(bundle.getObject(key))) continue;
            loc = bundle.getLocale();
            break;
        }
        return loc;
    }

    public Set<Locale> getSupportedLocales() {
        HashSet<Locale> locales = new HashSet<Locale>();
        locales.addAll(this.bundleMap.keySet());
        return locales;
    }

    public String getString(Locale loc, String key) {
        String value = "--";
        ResourceBundle bundle = this.bundleMap.get(loc);
        if (null != bundle) {
            try {
                value = bundle.getString(key);
            }
            catch (MissingResourceException e) {
                ConfigLoggerFactory.getLogger(ConfigResource.class).error("Cannot find key: " + key);
            }
        }
        return value;
    }

    public String getStringWithParams(Locale loc, String key, Object ... params) {
        String value = this.getString(loc, key);
        value = StringUtils.fillValues(value, params);
        return value;
    }

    public boolean containsString(Locale loc, String str) {
        Set<String> strs = this.stringsMap.get(loc);
        return null != strs && strs.contains(str);
    }
}

