/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.config.validate;

import com.huawei.ism.tool.obase.config.resource.PromptResource;
import com.huawei.ism.tool.obase.config.validate.AbstractValidator;
import com.huawei.ism.tool.obase.entity.KeyValue;

public abstract class FormatValidator
extends AbstractValidator {
    @Override
    public boolean validate(Object object, String objectDesc, Object ... params) {
        if (null == object || "".equals(object)) {
            return true;
        }
        KeyValue<String, String> kv = this.getFormatAndPrompt();
        if (!object.toString().matches(kv.getKey())) {
            super.setErrMsg(PromptResource.getStringWithParams("validate.error.format", objectDesc, kv.getValue()));
            return false;
        }
        return true;
    }

    protected abstract KeyValue<String, String> getFormatAndPrompt();

    public static class DomainNameValidator
    extends FormatValidator {
        @Override
        protected KeyValue<String, String> getFormatAndPrompt() {
            return new KeyValue<String, String>("^[a-zA-Z][0-9a-zA-Z-\\._]*", PromptResource.getString("validate.error.domainname"));
        }
    }

    public static class NameFormatValidator
    extends FormatValidator {
        @Override
        protected KeyValue<String, String> getFormatAndPrompt() {
            return new KeyValue<String, String>("^[a-zA-Z_][0-9a-zA-Z_-]*", PromptResource.getString("validate.error.username"));
        }
    }
}

