/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.exception;

import com.huawei.ism.tool.obase.utils.ResourceUtil;

public class ToolException
extends Exception {
    private static final long serialVersionUID = -7146824917855557593L;
    private boolean msgIsId = true;
    private String des = "--";
    private String errorId = "";
    private Object[] args = new Object[0];
    private Object operationObject = null;

    public ToolException(String errorId) {
        this(errorId, true);
    }

    public ToolException(String errMsg, boolean msgIsId) {
        this.errorId = errMsg;
        if (msgIsId) {
            this.queryErrorLocaleDescription();
        }
    }

    public ToolException(String errMsg, boolean msgIsId, Throwable throwAble) {
        super(throwAble);
        this.errorId = errMsg;
        if (msgIsId) {
            this.queryErrorLocaleDescription();
        }
    }

    public ToolException(String errorId, Object[] args) {
        Object[] tempArgs = (Object[])args.clone();
        this.errorId = errorId;
        this.args = tempArgs;
        this.queryErrorLocaleDescription();
    }

    public ToolException(String errorId, Throwable throwAble) {
        super(throwAble);
        this.errorId = errorId;
        this.queryErrorLocaleDescription();
    }

    public ToolException(String errorId, String message, Throwable throwAble) {
        super(message, throwAble);
        this.errorId = errorId;
        this.queryErrorLocaleDescription();
    }

    public ToolException(String errorId, Object[] args, String message, Throwable throwAble) {
        super(message, throwAble);
        Object[] tempArgs = (Object[])args.clone();
        this.errorId = errorId;
        this.args = tempArgs;
        this.queryErrorLocaleDescription();
    }

    public ToolException() {
    }

    public Object getOperationObject() {
        return this.operationObject;
    }

    public void setOperationObject(Object operationObject) {
        this.operationObject = operationObject;
    }

    public String getErrorId() {
        return this.errorId;
    }

    private void queryErrorLocaleDescription() {
        this.des = ResourceUtil.getStringWithParams(this.errorId, this.args);
    }

    public String getDes() {
        return this.des;
    }

    public void setDes(String des) {
        this.des = des;
    }

    public String getErrorLocaleDescription() {
        if (!this.msgIsId) {
            return this.errorId;
        }
        if ("--".equals(this.des)) {
            this.des = this.errorId;
        }
        return this.des;
    }

    @Override
    public String toString() {
        return super.toString() + ("\nOperation Object:" + this.getOperationObject()) + ("\nError Code:" + this.getErrorId());
    }
}

