/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.ui.component.treetable;

import com.huawei.ism.tool.obase.ui.component.treetable.TreeTable;
import com.huawei.ism.tool.obase.ui.component.treetable.TreeTableModel;
import com.huawei.ism.tool.obase.ui.component.treetable.TreeTableUtils;
import com.huawei.ism.ui.swing.TernaryCheckBox;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

public class TreeTableNameRenderer
extends JPanel
implements TableCellRenderer {
    public static final int HOTSPOT_SIZE = 10;
    private static final long serialVersionUID = -8298967778107609000L;
    private JLabel textLabel = new JLabel();

    public TreeTableNameRenderer() {
        this.setLayout(new BoxLayout(this, 0));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (!(value instanceof TreeTableModel.RowItem)) {
            return this;
        }
        TreeTableModel.RowItem rowItem = (TreeTableModel.RowItem)value;
        TreeTable treeTable = (TreeTable)((Object)table);
        int indentWidth = treeTable.getCheckBoxLeftIndent(rowItem);
        int left = 10;
        if (!rowItem.hasExpandAndCollapseIcon() || rowItem.getParent() != null) {
            left = indentWidth + 10;
        }
        JLabel iconLabel = new JLabel();
        this.add(Box.createHorizontalStrut(left));
        this.add(iconLabel);
        this.add(Box.createHorizontalStrut(10));
        Object checkBox1 = null;
        if (treeTable.isMutliSelected()) {
            checkBox1 = new TernaryCheckBox();
            if (treeTable.isCheckBoxVisiable()) {
                this.add((Component)checkBox1);
                this.add(Box.createHorizontalStrut(10));
                if (null != rowItem.getParent() && !treeTable.isChildCheckBoxVisiable()) {
                    ((JComponent)checkBox1).setVisible(false);
                }
            }
        } else if (null == rowItem.getParent()) {
            checkBox1 = new JRadioButton();
            this.add((Component)checkBox1);
            this.add(Box.createHorizontalStrut(10));
        }
        rowItem.setCheckBox((JComponent)checkBox1);
        this.add(this.textLabel);
        this.add(Box.createHorizontalGlue());
        if (rowItem.hasExpandAndCollapseIcon()) {
            boolean toggleState = rowItem.isVisible();
            Icon expandedIcon = (Icon)UIManager.get("Tree.expandedIcon");
            Icon collapsedIcon = (Icon)UIManager.get("Tree.collapsedIcon");
            Icon drawIcon = toggleState ? expandedIcon : collapsedIcon;
            iconLabel.setIcon(drawIcon);
        }
        if (null != rowItem.getTableRow() && null != rowItem.getTableRow().getValue(column)) {
            this.textLabel.setText(rowItem.getTableRow().getValue(column).toString());
        }
        this.setSelectStatus(isSelected, rowItem, (JComponent)checkBox1);
        TreeTableUtils.setCompColor(this, isSelected, treeTable, row);
        return this;
    }

    private void setSelectStatus(boolean isSelected, TreeTableModel.RowItem rowItem, JComponent selectComp) {
        if (null == selectComp) {
            return;
        }
        if (selectComp instanceof TernaryCheckBox) {
            TernaryCheckBox checkBox = (TernaryCheckBox)selectComp;
            checkBox.setSelected(isSelected);
            if (TreeTableModel.SelectType.HALF == rowItem.getSelectType()) {
                checkBox.setPartialSelected(true);
            } else if (TreeTableModel.SelectType.UNSELECT == rowItem.getSelectType()) {
                checkBox.setSelected(false);
            } else {
                checkBox.setSelected(true);
            }
        }
        if (selectComp instanceof JRadioButton) {
            JRadioButton radio = (JRadioButton)selectComp;
            radio.setSelected(rowItem.getSelectType().equals((Object)TreeTableModel.SelectType.SELECT));
        }
    }
}

