/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.ui.wizard;

import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.flow.FlowException;
import com.huawei.ism.tool.obase.flow.FlowFactory;
import com.huawei.ism.tool.obase.flow.FlowState;
import com.huawei.ism.tool.obase.flow.IFlow;
import com.huawei.ism.tool.obase.flow.IFlowListener;
import com.huawei.ism.tool.obase.flow.ui.IFlowUI;
import com.huawei.ism.tool.obase.flow.ui.IFlowUIState;
import com.huawei.ism.tool.obase.flow.ui.IStepUI;
import com.huawei.ism.tool.obase.flow.ui.Title;
import com.huawei.ism.tool.obase.ui.component.wizard.IHelpActionCallBack;
import com.huawei.ism.tool.obase.ui.component.wizard.WizardConstants;
import com.huawei.ism.tool.obase.ui.component.wizard.WizardHeadPanel;
import com.huawei.ism.tool.obase.ui.component.wizard.WizardRootPaneUI;
import com.huawei.ism.tool.obase.ui.component.wizard.WizardStepGroup;
import com.huawei.ism.tool.obase.ui.component.wizard.WizardStepItem;
import com.huawei.ism.tool.obase.ui.wizard.FlowWizardCardLayout;
import com.huawei.ism.tool.obase.ui.wizard.FlowWizardState;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class FlowWizardDialog
extends JDialog
implements IFlowUI {
    private static final long serialVersionUID = 5329056444374574123L;
    private static final String TITLE_DECO_ZH = "\u5411\u5bfc \u6b65\u9aa4";
    private static final String TITLE_DECO_EN = " Wizard ";
    private static final int WIZARD_DIALOG_WIDTH = 885;
    private static final int WIZARD_DIALOG_HEIGHT = 600;
    private JPanel contentPane = null;
    private Box southBox = Box.createVerticalBox();
    private transient List<Title> stageTitles = null;
    private String wizardTitle = "";
    private WizardHeadPanel stepsPanel = null;
    private transient Title flowTitle = null;
    private WizardStepGroup stepsGroup = new WizardStepGroup();
    private WizardRootPaneUI rootPaneUI = new WizardRootPaneUI();
    private Box navigationBar = null;
    private transient IFlow flow = null;
    private Locale loc = null;
    private Map<Navigation, JButton> naviBtns = new HashMap<Navigation, JButton>();

    public FlowWizardDialog(Window parent, Locale locale, FlowFactory flowFactory) throws ToolException {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.loc = locale;
        this.initWizard(flowFactory);
    }

    public FlowWizardDialog(Window parent, Locale locale, FlowFactory flowFactory, Image image) throws ToolException {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.setIconImage(image);
        this.loc = locale;
        this.initWizard(flowFactory);
    }

    public FlowWizardDialog(Window parent, Locale loc, ClassLoader clsLoader, InputStream defXmlStream, InputStream flowXmlStream) throws ToolException {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.loc = loc;
        FlowFactory flowFactory = new FlowFactory(defXmlStream, flowXmlStream, clsLoader);
        this.initWizard(flowFactory);
    }

    @Override
    public void initUIState(IFlowUIState state) {
        this.updateNavigation((FlowWizardState)state);
        this.repaint();
    }

    @Override
    public void changeUIState(IFlowUIState state) {
        this.changeEnableState((FlowWizardState)state);
    }

    public String getWizardTitle() {
        return this.wizardTitle;
    }

    public void setWizardTitle(String wizardTitle) {
        this.wizardTitle = wizardTitle;
    }

    public WizardHeadPanel getStepsPanel() {
        return this.stepsPanel;
    }

    public void setStepsPanel(WizardHeadPanel stepsPanel) {
        this.stepsPanel = stepsPanel;
    }

    public List<Title> getStageTitles() {
        return this.stageTitles;
    }

    public void setStageTitles(List<Title> stageTitles) {
        this.stageTitles = stageTitles;
    }

    @Override
    public JPanel getContentPane() {
        return this.contentPane;
    }

    public void setContentPane(JPanel contentPane) {
        this.contentPane = contentPane;
    }

    public Box getSouthBox() {
        return this.southBox;
    }

    public void setSouthBox(Box southBox) {
        this.southBox = southBox;
    }

    @Override
    public void showStep(int index, IStepUI stepUI) {
        if (index < 0 || index > this.stepsGroup.getStepSize() || null == stepUI) {
            return;
        }
        this.updateContent(stepUI);
        this.updateTitle(index);
    }

    @Override
    public void init(Title fTitle, String flowHelp, List<Title> sTitles) {
        if (null == sTitles || sTitles.isEmpty()) {
            return;
        }
        String titleDeco = "zh".equalsIgnoreCase(this.loc.getLanguage()) ? TITLE_DECO_ZH : TITLE_DECO_EN;
        this.wizardTitle = fTitle.getName(this.loc) + titleDeco;
        this.stageTitles = sTitles;
        this.flowTitle = fTitle;
        this.getRootPane().setUI(this.rootPaneUI);
        this.initHelp(flowHelp);
        this.initUI();
    }

    public void addFlowListener(IFlowListener flowListener) {
        this.flow.addListener(flowListener);
    }

    public void initHelp(final String flowHelp) {
        ClassLoader classLoader = FlowWizardDialog.class.getClassLoader();
        if (null == flowHelp || null == classLoader) {
            return;
        }
        FileUtils.createHelpFromClasspath(classLoader, flowHelp);
        this.rootPaneUI.setHelpActionCallBack(new IHelpActionCallBack(){

            @Override
            public void doHelpActionWork() {
                FileUtils.openHelpFile(flowHelp, FlowWizardDialog.this, ".chm");
            }

            public String getListenerName() {
                return "Flow Wizard Help";
            }
        });
    }

    public Title getFlowTitle() {
        return this.flowTitle;
    }

    private void initWizard(FlowFactory flowFactory) throws ToolException {
        this.initComponent();
        this.bondListener();
        try {
            this.flow = flowFactory.createFlow(this);
        }
        catch (FlowException e) {
            throw new ToolException("common.flow.create.error", e);
        }
        this.flow.init();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible && FlowState.ready == this.flow.getCurState()) {
            visible = this.flow.start();
        }
        super.setVisible(visible);
    }

    protected void updateTitle(int index) {
        Title subtitle = this.stageTitles.get(index);
        StringBuffer title = new StringBuffer();
        title.append(this.wizardTitle).append(" ");
        title.append(this.stageTitles.size()).append("-").append(index + 1).append(":").append(subtitle.getName(ApplicationContext.getInstance().getCurrentLanguage()));
        this.setTitle(title.toString());
        this.stepsGroup.setSelect(index);
    }

    private void updateContent(IStepUI stepUI) {
        FlowWizardCardLayout cardLayout = (FlowWizardCardLayout)stepUI;
        this.contentPane.removeAll();
        this.contentPane.add(UiMethod.buildFrameSpace(cardLayout, 20));
        this.contentPane.revalidate();
        this.contentPane.repaint();
        this.repaint();
    }

    private void updateNavigation(FlowWizardState state) {
        this.navigationBar.removeAll();
        this.initButtonState();
        this.navigationBar.add(Box.createHorizontalGlue());
        switch (state) {
            case First_Step: {
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.Next));
                this.navigationBar.add(Box.createHorizontalStrut(15));
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.Cancel));
                break;
            }
            case Last_Step: {
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.Previous));
                this.navigationBar.add(Box.createHorizontalStrut(10));
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.Complete));
                this.navigationBar.add(Box.createHorizontalStrut(15));
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.Cancel));
                break;
            }
            case Last_Step_Success: {
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.Previous));
                this.navigationBar.add(Box.createHorizontalStrut(10));
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.Complete));
                this.navigationBar.add(Box.createHorizontalStrut(15));
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.Cancel));
                this.naviBtns.get((Object)Navigation.Previous).setEnabled(false);
                this.naviBtns.get((Object)Navigation.Cancel).setEnabled(false);
                break;
            }
        }
        this.otherHandle(state);
        this.navigationBar.add(Box.createHorizontalStrut(20));
    }

    private void otherHandle(FlowWizardState state) {
        switch (state) {
            case Last_Step_Failed: {
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.Previous));
                this.navigationBar.add(Box.createHorizontalStrut(10));
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.Complete));
                this.navigationBar.add(Box.createHorizontalStrut(15));
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.Cancel));
                this.naviBtns.get((Object)Navigation.Complete).setEnabled(false);
                break;
            }
            case Last_Step_Running: {
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.Previous));
                this.navigationBar.add(Box.createHorizontalStrut(10));
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.Complete));
                this.navigationBar.add(Box.createHorizontalStrut(15));
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.Cancel));
                this.naviBtns.get((Object)Navigation.Previous).setEnabled(false);
                this.naviBtns.get((Object)Navigation.Complete).setEnabled(false);
                break;
            }
            case Middle_Step: {
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.Previous));
                this.navigationBar.add(Box.createHorizontalStrut(10));
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.Next));
                this.navigationBar.add(Box.createHorizontalStrut(15));
                this.navigationBar.add(this.naviBtns.get((Object)Navigation.Cancel));
                break;
            }
            case Middle_Step_Running: {
                this.middleStepRunningHandle();
                break;
            }
            case Middle_Step_Success: {
                this.middleStepSuccessHandle();
                break;
            }
            case Middle_Step_Failed: {
                this.middleStepFailedHandle();
                break;
            }
        }
    }

    private void middleStepRunningHandle() {
        this.navigationBar.add(this.naviBtns.get((Object)Navigation.Previous));
        this.navigationBar.add(Box.createHorizontalStrut(10));
        this.navigationBar.add(this.naviBtns.get((Object)Navigation.Next));
        this.navigationBar.add(Box.createHorizontalStrut(15));
        this.navigationBar.add(this.naviBtns.get((Object)Navigation.Cancel));
        this.naviBtns.get((Object)Navigation.Previous).setEnabled(false);
        this.naviBtns.get((Object)Navigation.Next).setEnabled(false);
    }

    private void middleStepSuccessHandle() {
        this.navigationBar.add(this.naviBtns.get((Object)Navigation.Previous));
        this.navigationBar.add(Box.createHorizontalStrut(10));
        this.navigationBar.add(this.naviBtns.get((Object)Navigation.Next));
        this.navigationBar.add(Box.createHorizontalStrut(15));
        this.navigationBar.add(this.naviBtns.get((Object)Navigation.Cancel));
        this.naviBtns.get((Object)Navigation.Previous).setEnabled(false);
    }

    private void middleStepFailedHandle() {
        this.navigationBar.add(this.naviBtns.get((Object)Navigation.Previous));
        this.navigationBar.add(Box.createHorizontalStrut(10));
        this.navigationBar.add(this.naviBtns.get((Object)Navigation.Next));
        this.navigationBar.add(Box.createHorizontalStrut(15));
        this.navigationBar.add(this.naviBtns.get((Object)Navigation.Cancel));
        this.naviBtns.get((Object)Navigation.Next).setEnabled(false);
    }

    private void changeEnableState(FlowWizardState state) {
        switch (state) {
            case Last_Step_Success: {
                this.naviBtns.get((Object)Navigation.Complete).setEnabled(true);
                this.naviBtns.get((Object)Navigation.Previous).setEnabled(false);
                this.naviBtns.get((Object)Navigation.Cancel).setEnabled(false);
                break;
            }
            case Last_Step_Failed: {
                this.naviBtns.get((Object)Navigation.Complete).setEnabled(false);
                this.naviBtns.get((Object)Navigation.Previous).setEnabled(true);
                this.naviBtns.get((Object)Navigation.Cancel).setEnabled(true);
                break;
            }
            case Last_Step_Running: {
                this.naviBtns.get((Object)Navigation.Cancel).setEnabled(true);
                this.naviBtns.get((Object)Navigation.Previous).setEnabled(false);
                this.naviBtns.get((Object)Navigation.Complete).setEnabled(false);
                break;
            }
            case Middle_Step_Running: {
                this.naviBtns.get((Object)Navigation.Previous).setEnabled(false);
                this.naviBtns.get((Object)Navigation.Next).setEnabled(false);
                this.naviBtns.get((Object)Navigation.Cancel).setEnabled(true);
                break;
            }
            case Middle_Step_Success: {
                this.naviBtns.get((Object)Navigation.Previous).setEnabled(false);
                this.naviBtns.get((Object)Navigation.Next).setEnabled(true);
                this.naviBtns.get((Object)Navigation.Cancel).setEnabled(true);
                break;
            }
            case Middle_Step_Failed: {
                this.naviBtns.get((Object)Navigation.Next).setEnabled(false);
                this.naviBtns.get((Object)Navigation.Previous).setEnabled(true);
                this.naviBtns.get((Object)Navigation.Cancel).setEnabled(true);
                break;
            }
        }
    }

    private void initComponent() {
        JButton previous = UiMethod.createButton(Navigation.Previous.toString(), 'P');
        JButton next = UiMethod.createButton(Navigation.Next.toString(), 'N');
        JButton complete = UiMethod.createButton(Navigation.Complete.toString(), 'F');
        JButton cancel = UiMethod.createButton(Navigation.Cancel.toString(), 'C');
        this.naviBtns.put(Navigation.Previous, previous);
        this.naviBtns.put(Navigation.Next, next);
        this.naviBtns.put(Navigation.Complete, complete);
        this.naviBtns.put(Navigation.Cancel, cancel);
    }

    private void initButtonState() {
        for (Map.Entry<Navigation, JButton> enty : this.naviBtns.entrySet()) {
            enty.getValue().setEnabled(true);
        }
    }

    private void bondListener() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!FlowWizardDialog.this.flow.exit()) {
                    FlowWizardDialog.this.setDefaultCloseOperation(0);
                } else {
                    FlowWizardDialog.this.setDefaultCloseOperation(2);
                }
            }
        });
        this.naviBtns.get((Object)Navigation.Previous).addActionListener(new PreviousAction());
        this.naviBtns.get((Object)Navigation.Next).addActionListener(new NextAction());
        this.naviBtns.get((Object)Navigation.Cancel).addActionListener(new CancelAction());
        this.naviBtns.get((Object)Navigation.Complete).addActionListener(new CompleteAction());
    }

    private void initUI() {
        ArrayList<WizardStepItem> stepList = new ArrayList<WizardStepItem>();
        int i = 1;
        Locale locale = ApplicationContext.getInstance().getCurrentLanguage();
        for (Title title : this.stageTitles) {
            WizardStepItem step = new WizardStepItem(title.getName(locale), title.getDesc(locale), i);
            if (1 == i) {
                step.setSelected(true);
            }
            stepList.add(step);
            ++i;
        }
        this.stepsGroup.setSetps(stepList.toArray(new WizardStepItem[stepList.size()]));
        this.navigationBar = Box.createHorizontalBox();
        this.contentPane = new JPanel(new BorderLayout());
        this.southBox.add(Box.createVerticalStrut(12));
        this.southBox.add(this.navigationBar);
        JPanel pane = this.getWizardPanel();
        this.southBox.setPreferredSize(new Dimension((int)this.getPreferredSize().getWidth(), 39));
        pane.setBackground(WizardConstants.WIZARD_BACKGROUND);
        pane.setPreferredSize(new Dimension(885, 600));
        JPanel buttomPanel = new JPanel();
        buttomPanel.setPreferredSize(new Dimension((int)this.getPreferredSize().getWidth(), 6));
        buttomPanel.setBackground(WizardConstants.WIZARD_BUTTOM_LINE_COLOR);
        Container container = super.getContentPane();
        this.setLayout(new BorderLayout());
        container.add((Component)pane, "Center");
        container.add((Component)buttomPanel, "South");
        int height = (int)this.stepsGroup.getPreferredSize().getHeight() + 6 + 39;
        this.setSize(height / 3 * 4, height);
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.pack();
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
    }

    protected JPanel getWizardPanel() {
        JPanel jPane = new JPanel(new BorderLayout());
        jPane.add((Component)this.stepsGroup, "West");
        jPane.add((Component)this.contentPane, "Center");
        jPane.add((Component)this.southBox, "South");
        return jPane;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
    }

    private final class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (FlowWizardDialog.this.flow.exit()) {
                FlowWizardDialog.this.dispose();
            }
        }
    }

    private final class CompleteAction
    implements ActionListener {
        private CompleteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (FlowWizardDialog.this.flow.complete()) {
                FlowWizardDialog.this.dispose();
            }
        }
    }

    private final class NextAction
    implements ActionListener {
        private NextAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FlowWizardDialog.this.flow.goNext();
        }
    }

    private final class PreviousAction
    implements ActionListener {
        private PreviousAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FlowWizardDialog.this.flow.goPrevious();
        }
    }

    public static enum Navigation {
        Previous,
        Next,
        Complete,
        Cancel;


        public String toString() {
            String prefix = "toolbase.common.txt.";
            return ResourceUtil.getString(prefix + this.name().toLowerCase(Locale.getDefault()));
        }
    }
}

