/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils;

import com.huawei.ism.exception.IsmException;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemMode {
    private static final Logger log = LoggerFactory.getLogger(SystemMode.class);
    private static final String SHOW_USER_MODE_ENABLED = "show user_mode enabled";
    private static final String DEVELOPER_SWITCH_OPEN = "change user_mode enabled user_mode=developer enabled=yes";
    private static final String DEVELOPER_VIEW = "Developer View";
    private static final String DISABLED_TAG = "Disabled";
    private static final String CHANGE_DEVELOPER = "change user_mode current_mode user_mode=developer";
    private static final String DEVELOPER_CONFIRM = "DANGER: You are about to switch to the developer view.";
    private static final String DEVELOPER_CONFIRM_AGAIN = "Are you sure you really want to perform the operation?(y/n)";
    private static final String DEVELOPER_MODEL_FLAG = "developer@*.*?:/>";
    private static final String MINISYSTEM_MODEL_FLAG = "minisystem>";
    private static final String DEBUG_MODEL_FLAG = ":/diagnose>";
    private static final String DIAGNOSE_RET_END_FLAG = "diagnose>";
    private static final String CLI_EXECUTE_CMD_SUCCESS = "Command executed successfully";
    private static final String EXIT = "exit";
    private static final String YES_OR_NO = "(y/n)";
    private static final String YES = "y";
    private static final String DEBUG = "debug";
    private static final String MINISYSTEM = "minisystem";
    private static final String DEVELOPER = "developer";
    private static final String CLI = "cli";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String excuteCmdInDebugModel(DevNode devNode, String cmd) {
        String result = "";
        ICliConnection ssh = null;
        try {
            ssh = SshConnectionManager.getSshConnection(devNode, null, true, true);
            SystemMode.changeDebugModel(ssh);
            result = ssh.execCmd(cmd);
        }
        catch (Exception e) {
            log.error("Rseult is empty,cmd is {} ,IP is:{}", cmd, devNode.getIp(), e);
        }
        finally {
            if (null != ssh) {
                SshConnectionManager.releaseConnection(ssh);
            }
        }
        return result;
    }

    private static void changeDebugModel(ICliConnection ssh) throws ToolException {
        String model;
        switch (model = SystemMode.getCurModel(ssh)) {
            case "debug": {
                break;
            }
            case "minisystem": {
                SystemMode.enterDeveloperModeFromMinisystemMode(ssh);
                SystemMode.enterDebugModeFromDeveloperMode(ssh);
                break;
            }
            case "developer": {
                SystemMode.enterDebugModeFromDeveloperMode(ssh);
                break;
            }
            default: {
                if (SystemMode.needOpenDeveloperSwitch(ssh)) {
                    SystemMode.openDeveloperSwitch(ssh);
                }
                SystemMode.enterDeveloperModeFromCliMode(ssh);
                SystemMode.enterDebugModeFromDeveloperMode(ssh);
            }
        }
    }

    private static String getCurModel(ICliConnection ssh) throws ToolException {
        String cliRet = ssh.execCmd("test");
        if (SystemMode.isInDebugMode(cliRet)) {
            return DEBUG;
        }
        if (SystemMode.isInMinisystemMode(cliRet)) {
            return MINISYSTEM;
        }
        if (SystemMode.isInDeveloperMode(cliRet)) {
            return DEVELOPER;
        }
        return CLI;
    }

    private static void enterDeveloperModeFromCliMode(ICliConnection ssh) throws ToolException {
        String echo = ssh.execCmd(CHANGE_DEVELOPER);
        if (Pattern.compile(DEVELOPER_MODEL_FLAG).matcher(echo).find()) {
            return;
        }
        if (!StringUtils.contains((CharSequence)echo, (CharSequence)DEVELOPER_CONFIRM)) {
            throw new IsmException("The command output is incorrect.");
        }
        String confirmInfo = ssh.execCmd(YES);
        if (!StringUtils.contains((CharSequence)confirmInfo, (CharSequence)DEVELOPER_CONFIRM_AGAIN)) {
            throw new IsmException("The command output is incorrect.");
        }
        String command = ssh.execCmd(YES);
        if (!Pattern.compile(DEVELOPER_MODEL_FLAG).matcher(command).find()) {
            throw new IsmException("Change cli to developer failed.");
        }
    }

    private static void enterDebugModeFromDeveloperMode(ICliConnection ssh) throws ToolException {
        String echo = ssh.execCmd(DEBUG);
        if (!SystemMode.isInDebugMode(echo)) {
            throw new IsmException("Enter debug mode from developer mode failed.");
        }
    }

    private static void enterDeveloperModeFromMinisystemMode(ICliConnection ssh) throws ToolException {
        String echo = ssh.execCmd(EXIT);
        if (StringUtils.contains((CharSequence)echo, (CharSequence)YES_OR_NO)) {
            echo = ssh.execCmd(YES);
        }
        if (!SystemMode.isInDeveloperMode(echo)) {
            throw new IsmException("Enter developer mode from minisystem mode failed.");
        }
    }

    private static void openDeveloperSwitch(ICliConnection ssh) throws ToolException {
        String echo = ssh.execCmd(DEVELOPER_SWITCH_OPEN);
        if (!StringUtils.contains((CharSequence)echo, (CharSequence)CLI_EXECUTE_CMD_SUCCESS)) {
            throw new IsmException("Open developer switch failed.");
        }
    }

    private static boolean needOpenDeveloperSwitch(ICliConnection ssh) throws ToolException {
        String echo = ssh.execCmd(SHOW_USER_MODE_ENABLED);
        if (!StringUtils.contains((CharSequence)echo, (CharSequence)DEVELOPER_VIEW)) {
            return false;
        }
        return StringUtils.contains((CharSequence)echo, (CharSequence)DISABLED_TAG);
    }

    private static boolean isInDebugMode(String cliRet) {
        return Pattern.compile(DEBUG_MODEL_FLAG).matcher(cliRet).find();
    }

    private static boolean isInMinisystemMode(String cliRet) {
        return Pattern.compile(MINISYSTEM_MODEL_FLAG).matcher(cliRet).find();
    }

    private static boolean isInDeveloperMode(String cliRet) {
        return Pattern.compile(DEVELOPER_MODEL_FLAG).matcher(cliRet).find();
    }
}

