/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils.reflection;

import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static Object refInvoke(Object object, String methodName, Object ... args) {
        if (null == object || null == methodName || null == args) {
            return null;
        }
        try {
            Method methodFromObj = ReflectionUtils.getMethodFromObj(object.getClass(), methodName, ReflectionUtils.getTypes(args));
            if (null != methodFromObj) {
                return methodFromObj.invoke(object, args);
            }
            return null;
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(ReflectionUtils.class).error("refInvoke error", e);
            return null;
        }
    }

    public static Object getRefInvoke(Object object, String methodName, Object ... args) throws InvocationTargetException {
        if (null == object || null == methodName || null == args) {
            return null;
        }
        try {
            Method method = ReflectionUtils.getMethodFromObj(object.getClass(), methodName, ReflectionUtils.getTypes(args));
            if (null == method) {
                return null;
            }
            return method.invoke(object, args);
        }
        catch (InvocationTargetException e1) {
            ToolLoggerFactory.getLogger(ReflectionUtils.class).error("refInvoke error", e1);
            throw e1;
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(ReflectionUtils.class).error("refInvoke error", e);
            return null;
        }
    }

    public static Method getMethodFromObj(Class<?> cls, String methodName, Class<?>[] paramTypes) throws NoSuchMethodException {
        Method method = null;
        try {
            Method[] mds;
            for (Method md : mds = cls.getDeclaredMethods()) {
                if (!methodName.equals(md.getName())) continue;
                method = md;
                break;
            }
        }
        catch (SecurityException e) {
            return null;
        }
        if (null == method) {
            Class<?> superCls = cls.getSuperclass();
            if (null == superCls) {
                throw new NoSuchMethodException("can't find method name:" + methodName);
            }
            method = ReflectionUtils.getMethodFromObj(superCls, methodName, paramTypes);
        }
        return method;
    }

    private static Class<?>[] getTypes(Object ... objs) {
        Class[] cls = new Class[objs.length];
        for (int j = 0; j < cls.length; ++j) {
            cls[j] = objs[j].getClass();
        }
        return cls;
    }

    public static Object newInstance(String className) {
        if (null == className) {
            return null;
        }
        try {
            return com.huawei.ism.tool.base.utils.reflection.ReflectionUtils.newInstance((String)className);
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(ReflectionUtils.class).error("new instance error.", e);
            return null;
        }
    }
}

