/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.service.dev.infoqry;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicemanager.entity.fusioncube.A3000InfoTo;
import com.huawei.ism.tool.devicemanager.entity.fusioncube.ResultVo;
import com.huawei.ism.tool.devicemanager.service.DeviceOpr;
import com.huawei.ism.tool.devicemanager.service.INodeTypeQuery;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.framework.pubservice.entity.DeviceType;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.listener.INodeSupport;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.VersionAndModelInfo;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.protocol.rest.A3000Connection;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class A3000InfoQryServiceImpl
implements INodeTypeQuery {
    private static final Logger log = LoggerFactory.getLogger(A3000InfoQryServiceImpl.class);
    private INodeSupport nodeSupport = null;

    public void setNodeSupport(INodeSupport nodeSupport) {
        this.nodeSupport = nodeSupport;
    }

    @Override
    public TaskResult queryNodeInfo(DevNode devNode, DeviceOpr opr) {
        return this.queryNodeInfo(devNode, opr, null);
    }

    @Override
    public TaskResult queryNodeInfo(DevNode devNode, DeviceOpr opr, ProgressDialog progressDialog) {
        if (!devNode.isA3000()) {
            return new TaskResult(TaskResult.Result.SUCCESS);
        }
        devNode.setStorageVersionInfo(new VersionAndModelInfo(devNode.getDeviceType(), devNode.getProductVersion()));
        return this.queryA3000ExpandInfo(devNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskResult queryA3000ExpandInfo(DevNode devNode) {
        TaskResult taskResult = new TaskResult();
        try {
            DevNode a3000DevNode = this.createA3000RestDevNode(devNode);
            A3000Connection connection = RestConnectionManager.getA3000RestConnection(a3000DevNode);
            if (Objects.isNull(connection) || !connection.isLogin()) {
                String errorId = "devicemanager.layout.device.add.deviceadddialog.deviceconnecterror";
                String errorDes = ResourceUtil.getStringWithParams((String)errorId, (Object[])new Object[]{devNode.getIp()});
                this.updateTaskResultError(taskResult, errorDes, errorId, devNode);
                TaskResult taskResult2 = taskResult;
                return taskResult2;
            }
            ResponseInfo esnResponse = this.getA3000Response(devNode, connection, taskResult, connection.getQueryEsnUrl());
            if (!esnResponse.isSuccess()) {
                TaskResult taskResult3 = taskResult;
                return taskResult3;
            }
            ResponseInfo versionResponse = this.getA3000Response(devNode, connection, taskResult, connection.getVersionUrl());
            if (!versionResponse.isSuccess()) {
                TaskResult taskResult4 = taskResult;
                return taskResult4;
            }
            this.parseA3000EsnAndVersion(devNode, esnResponse, versionResponse, taskResult);
        }
        catch (ToolException e) {
            log.error("query A3000 info error : ", (Throwable)e);
            String errorDes = e.getDes();
            String errorId = e.getErrorId();
            this.updateTaskResultError(taskResult, errorDes, errorId, devNode);
        }
        finally {
            RestConnectionManager.releaseA3000Connection(devNode);
        }
        return taskResult;
    }

    @NotNull
    private ResponseInfo getA3000Response(DevNode devNode, RestConnection connection, TaskResult taskResult, String taskUrl) throws ToolException {
        ResponseInfo resp = connection.execGet(taskUrl);
        if (!resp.isSuccess() || StringUtils.isNULLStr((String)resp.getContent())) {
            log.error("query a3000 version error");
            String errorId = "devicemanager.layout.device.add.deviceadddialog.a30000.query.version.failed";
            String errorDes = ResourceUtil.getStringWithParams((String)errorId, (Object[])new Object[]{devNode.getIp()});
            this.updateTaskResultError(taskResult, errorDes, errorId, devNode);
            return new ResponseInfo();
        }
        return resp;
    }

    private void parseA3000EsnAndVersion(DevNode devNode, ResponseInfo esnResponse, ResponseInfo versionResponse, TaskResult taskResult) {
        JSONObject esnJson = JSONObject.parseObject((String)esnResponse.getContent());
        String esn = esnJson.getString("data");
        ResultVo resultVo = (ResultVo)JSONObject.parseObject((String)versionResponse.getContent(), (TypeReference)new TypeReference<ResultVo<A3000InfoTo>>(){}, (Feature[])new Feature[0]);
        String version = ((A3000InfoTo)resultVo.getData()).getVersion();
        String scenario = ((A3000InfoTo)resultVo.getData()).getDeviceModel();
        this.checkA3000VersionSupport(devNode, taskResult, version, scenario, esn);
    }

    private void checkA3000VersionSupport(DevNode devNode, TaskResult taskResult, String version, String scenario, String esn) {
        if (this.isSupportedVersion(ItDeviceType.A3000.getName(), version, scenario)) {
            this.buildA3000Info(devNode, version, scenario, this.getA3000Esn(devNode, esn));
            taskResult.setResult(TaskResult.Result.SUCCESS);
            taskResult.setErrorLocaleDescription("");
            taskResult.setResultObject((Object)devNode);
        } else {
            this.updateTaskResultError(taskResult, ResourceUtil.getStringWithParams((String)"devicemanager.layout.device.add.deviceadddialog.a3000.not.supported", (Object[])new Object[]{ItDeviceType.A3000.getName() + " " + version + " " + scenario}), "devicemanager.layout.device.add.deviceadddialog.a3000.not.supported", devNode);
        }
    }

    private String getA3000Esn(DevNode devNode, String newEsn) {
        if (!StringUtils.isNULLStr((String)devNode.getDeviceSerialNumber())) {
            return devNode.getDeviceSerialNumber();
        }
        return newEsn;
    }

    private void buildA3000Info(DevNode devNode, String version, String scenario, String esn) {
        devNode.setProductSubVersion(version);
        devNode.setDeviceName(scenario);
        devNode.setScenarioInfo(scenario);
        devNode.setDeviceSerialNumber(esn);
        devNode.setProductVersion(version);
        devNode.setDeviceType(com.huawei.ism.tool.obase.entity.DeviceType.valueOf((String)ItDeviceType.A3000.getName()));
    }

    boolean isSupportedVersion(String deviceType, String version, String scenarioInfo) {
        if (Objects.isNull(this.nodeSupport)) {
            return true;
        }
        com.huawei.ism.tool.framework.pubservice.entity.DevNode newDevNode = new com.huawei.ism.tool.framework.pubservice.entity.DevNode();
        newDevNode.setDeviceType(DeviceType.valueOf((String)deviceType));
        newDevNode.setItDeviceType(ItDeviceType.A3000);
        newDevNode.setDeviceType(DeviceType.valueOf((String)ItDeviceType.A3000.getName()));
        newDevNode.setProductVersion(version);
        newDevNode.setScenarioInfo(scenarioInfo);
        return this.nodeSupport.isNodeSupport(newDevNode);
    }

    private void updateTaskResultError(TaskResult result, String errorDesc, String errorId, DevNode devNode) {
        try {
            if (DefaultNodeProviderImpl.getInstance().isContainsNode(devNode)) {
                DefaultNodeProviderImpl.getInstance().removeNode(devNode);
            }
            log.error("[remove device >> {}][success]", (Object)StringUtils.getCleanMessage((String)devNode.toString()));
        }
        catch (ToolException toolException) {
            log.error("[remove device >> {}][exception]", (Object)StringUtils.getCleanMessage((String)devNode.toString()));
        }
        if (result != null && result.getResult() == TaskResult.Result.SUCCESS) {
            result.setResult(TaskResult.Result.FAILED);
            result.setErrorId(errorId);
            result.setErrorLocaleDescription(errorDesc);
        } else {
            log.info("No need to change the result");
        }
    }

    private DevNode createA3000RestDevNode(DevNode devNode) {
        DevNode a3000Node = new DevNode();
        a3000Node.setItDeviceType(ItDeviceType.A3000);
        a3000Node.setLoginUser(devNode.getLoginUser());
        a3000Node.setIp(devNode.getIp());
        a3000Node.setDeviceType(com.huawei.ism.tool.obase.entity.DeviceType.valueOf((String)ItDeviceType.A3000.getName()));
        return a3000Node;
    }
}

