/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.service.dev.infoqry;

import com.huawei.ism.tool.devicemanager.entity.rest.result.ManageInfo;
import com.huawei.ism.tool.devicemanager.service.DeviceOpr;
import com.huawei.ism.tool.devicemanager.service.INodeTypeQuery;
import com.huawei.ism.tool.devicemanager.ui.action.SceneAddDeviceAction;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.listener.INodeSupport;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.ClusterNodeStatus;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.enums.FsmRole;
import com.huawei.ism.tool.obase.enums.SandboxStatus;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.exception.UserPrivilegeException;
import com.huawei.ism.tool.protocol.exception.UserStatusException;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import com.huawei.json.JSONUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSstorageInfoQryServiceImpl
implements INodeTypeQuery {
    private static final Logger log = LoggerFactory.getLogger(DSstorageInfoQryServiceImpl.class);
    protected INodeSupport nodeSupport = null;
    public static final String DEVICE_CANNOT_CONNECT = "devicemanager.layout.device.add.deviceadddialog.deviceconnecterror";
    public static final String CLUSTER_INFO_QUERY_FAIL = "devicemanager.layout.device.add.deviceadddialog.query.cluster.info.fail";
    public static final String EXE_FAILED = "TOOLKIT_EXE_CMD_FAILED";
    private boolean isQueryDirectPlanes = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskResult queryNodeInfo(com.huawei.ism.tool.obase.entity.DevNode devNode, DeviceOpr opr, ProgressDialog progressDialog) {
        TaskResult ret = new TaskResult();
        ret.setResultObject((Object)devNode);
        try {
            RestConnection restConn = RestConnectionManager.getDstorageLoginRestConnection(devNode);
            if (null == restConn || !restConn.isLogin()) {
                String errId = DEVICE_CANNOT_CONNECT;
                ret.setErrorId(errId);
                ret.setErrorLocaleDescription(ResourceUtil.getStringWithParams((String)errId, (Object[])new Object[]{devNode.getIp()}));
                ret.setResult(TaskResult.Result.FAILED);
                TaskResult taskResult = ret;
                return taskResult;
            }
            if (!this.getClusterDeviceInfo(devNode, restConn)) {
                log.error("Query cluster info by rest failed.");
                this.makeQueryCluserInfoFailResult(devNode, ret);
                TaskResult taskResult = ret;
                return taskResult;
            }
            log.info("Query cluster node info by rest success.");
            ret.setResult(TaskResult.Result.SUCCESS);
            ret.setErrorLocaleDescription("");
            ret.setResultObject((Object)devNode);
            this.nodeSupportCheck(devNode, ret);
            this.checkRestCert(restConn, devNode);
            TaskResult taskResult = ret;
            return taskResult;
        }
        catch (ToolException e) {
            if ("No trusted certificate found".equals(e.getErrorId())) {
                ret.setNeedCertWarn(true);
                TaskResult taskResult = ret;
                return taskResult;
            }
            ret.setErrorId(e.getErrorId());
            ToolLoggerFactory.getLogger(this.getClass()).error("execute cmd error.", (Throwable)e);
            this.makeErrorTaskResult(devNode, ret);
            TaskResult taskResult = ret;
            return taskResult;
        }
        catch (UserStatusException e) {
            ret.setErrorId(e.getErrorId());
            ret.setErrorLocaleDescription(e.getDes());
            ret.setResult(TaskResult.Result.FAILED);
            TaskResult taskResult = ret;
            return taskResult;
        }
        catch (UserPrivilegeException e) {
            ret.setErrorId(e.getErrorId());
            ret.setErrorLocaleDescription(e.getDes());
            ret.setResult(TaskResult.Result.FAILED);
            TaskResult taskResult = ret;
            return taskResult;
        }
        finally {
            RestConnectionManager.releaseConn(devNode);
        }
    }

    protected void nodeSupportCheck(com.huawei.ism.tool.obase.entity.DevNode devNode, TaskResult ret) {
        if (null != this.nodeSupport && !TaskResult.Result.FAILED.equals((Object)ret.getResult())) {
            DeviceType tmpType = DeviceType.valueOf((String)(devNode.getDeviceType() + " " + devNode.getProductVersion()));
            DevNode newDevNode = EntityUtils.toNewDev((com.huawei.ism.tool.obase.entity.DevNode)devNode);
            if (!this.nodeSupport.isNodeSupport(newDevNode)) {
                if (this.nodeSupport instanceof SceneAddDeviceAction) {
                    this.setTaskFailedResultWithSceneNotSupportErrMsg((SceneAddDeviceAction)this.nodeSupport, ret, devNode, tmpType);
                    return;
                }
                this.setTaskFailedResult(ret, devNode, tmpType);
                return;
            }
        }
    }

    protected void setTaskFailedResultWithSceneNotSupportErrMsg(SceneAddDeviceAction sceneAddDeviceAction, TaskResult ret, com.huawei.ism.tool.obase.entity.DevNode devNode, DeviceType tmpType) {
        ret.setResult(TaskResult.Result.FAILED);
        if (!StringUtils.isNULLStr((String)devNode.getErrorDecs())) {
            ret.setErrorLocaleDescription(devNode.getErrorDecs());
        } else {
            ret.setErrorLocaleDescription(ResourceUtil.getStringWithParams((String)sceneAddDeviceAction.getAddDevErrMsgPropKey(), (Object[])new Object[]{devNode.getIp(), tmpType}));
        }
    }

    protected void setTaskFailedResult(TaskResult ret, com.huawei.ism.tool.obase.entity.DevNode devNode, DeviceType tmpType) {
        ret.setResult(TaskResult.Result.FAILED);
        if (!StringUtils.isNULLStr((String)devNode.getErrorDecs())) {
            ret.setErrorLocaleDescription(devNode.getErrorDecs());
            return;
        }
        ret.setErrorLocaleDescription(ResourceUtil.getStringWithParams((String)"devicemanager.layout.device.add.deviceadddialog.nosupportdevtype", (Object[])new Object[]{devNode.getIp(), tmpType}));
    }

    public boolean getClusterDeviceInfo(com.huawei.ism.tool.obase.entity.DevNode devNode, RestConnection conn) {
        try {
            if (!this.queryClusterNodeInfo(devNode, conn)) {
                return false;
            }
            this.queryBmcIpInfo(devNode, conn);
            if (this.isQueryDirectPlanes) {
                this.queryDirectPlanesInfo(devNode, conn);
            }
            return true;
        }
        catch (ToolException te) {
            log.error("Query cluster information tool exception:", (Throwable)te);
            return false;
        }
    }

    private void fusionCube8dot3Compatible(com.huawei.ism.tool.obase.entity.DevNode devNode) {
        boolean isFusionCube8dot3SubDevice;
        boolean bl = isFusionCube8dot3SubDevice = Objects.nonNull(devNode.getFusionCubeLoginUser()) && !devNode.isFusionCube() && org.apache.commons.lang3.StringUtils.equals((CharSequence)devNode.getProductVersion(), (CharSequence)"8.3.RC1") && org.apache.commons.lang3.StringUtils.equals((CharSequence)devNode.getProductModel(), (CharSequence)"OceanStor Pacific");
        if (!isFusionCube8dot3SubDevice) {
            return;
        }
        devNode.setProductVersion("8.2.1");
    }

    public boolean queryClusterNodeInfo(com.huawei.ism.tool.obase.entity.DevNode devNode, RestConnection conn) throws ToolException {
        this.queryClusterProductInfo(devNode, conn);
        this.fusionCube8dot3Compatible(devNode);
        try {
            this.queryClusterSysInfo(devNode, conn);
        }
        catch (JSONException e) {
            log.error("Query Cluster SysInfo error.");
        }
        return this.queryClusterNodes(devNode, conn);
    }

    private void queryDirectPlanesInfo(com.huawei.ism.tool.obase.entity.DevNode devNode, RestConnection conn) {
        try {
            ResponseInfo resp = conn.execGet(RestUtil.getDirectPlanes(devNode));
            log.info("query direct planes is {}.", (Object)resp.getContent());
            JSONObject jsonObj = new JSONObject(resp.getContent());
            if (jsonObj.has("data") && jsonObj.getJSONArray("data").length() > 0) {
                log.info("start to parse direct planes.");
                this.parseDirectPlanesInfo(devNode, jsonObj.getJSONArray("data"));
            }
        }
        catch (Exception e) {
            log.error("query direct planes failed.", (Throwable)e);
        }
    }

    private void parseDirectPlanesInfo(com.huawei.ism.tool.obase.entity.DevNode devNode, JSONArray directPlanes) {
        LinkedList<ClusterNode> directPlaneList = new LinkedList<ClusterNode>();
        ClusterNode.BaseBoardType ssmAtlantic = ClusterNode.BaseBoardType.SSM_ATLANTIC;
        for (int i = 0; i < directPlanes.length(); ++i) {
            JSONObject object = directPlanes.getJSONObject(i);
            ClusterNode cn = new ClusterNode();
            cn.setId(Short.MAX_VALUE + i);
            cn.setBmcIp(object.getString("ip"));
            cn.setManagementIp("--");
            cn.setCabinet("None");
            cn.setSubrack("None");
            cn.setSlotNumber("None");
            cn.setSoftwareVersion("None");
            cn.setInCluster(true);
            cn.setInstallationStatus(true);
            cn.setSandboxStatus(SandboxStatus.UNSUPPORTED);
            cn.getRoles().add("directPlane");
            cn.setSerialNumber(cn.getBmcIp() + "_" + cn.getId());
            cn.setName(ssmAtlantic.getProductName());
            cn.setModel(ssmAtlantic.getDevType());
            cn.setModelByBmc(ssmAtlantic.getDevType());
            cn.setSelected(true);
            cn.setStatus(ClusterNodeStatus.STATUS_ABNORMAL);
            cn.setBaseBoardType(ssmAtlantic.getProductName());
            directPlaneList.add(cn);
        }
        if (CollectionUtils.isNotEmpty((Collection)devNode.getClusterNodes())) {
            devNode.getClusterNodes().addAll(directPlaneList);
        } else {
            devNode.setClusterNodes(directPlaneList);
        }
    }

    private void queryBmcIpInfo(com.huawei.ism.tool.obase.entity.DevNode devNode, RestConnection conn) {
        try {
            ResponseInfo resp = conn.execGet(RestUtil.getDsQueryBmcInfo(devNode));
            String content = resp.getContent();
            JSONObject jsonObj = new JSONObject(content);
            if (content.contains("data")) {
                JSONArray data = jsonObj.getJSONArray("data");
                this.parseBmcInfo(devNode, data);
            }
        }
        catch (Exception e) {
            log.error("Query bmcInfo failed.", (Throwable)e);
        }
    }

    private void parseBmcInfo(com.huawei.ism.tool.obase.entity.DevNode devNode, JSONArray data) {
        for (int i = 0; i < data.length(); ++i) {
            JSONObject obj = data.getJSONObject(i);
            String managementIp = obj.getString("management_ip");
            String bmcIp = obj.getString("bmc_ip");
            devNode.getClusterNodes().stream().filter(node -> node.getManagementIp().equals(managementIp)).findFirst().ifPresent(node -> {
                node.setBmcIp(bmcIp);
                node.setModelByBmc(obj.getStringOrDefault("model", ""));
            });
        }
    }

    private boolean queryClusterNodes(com.huawei.ism.tool.obase.entity.DevNode devNode, RestConnection conn) throws ToolException {
        ResponseInfo clusterNodesResp = conn.execGet(RestUtil.getClusterNodesUri(devNode));
        Long errorCode = (Long)clusterNodesResp.getContentMap().get("errorCode");
        String errorDes = (String)clusterNodesResp.getContentMap().get("description");
        String suggest = (String)clusterNodesResp.getContentMap().get("suggestion");
        if (0L != errorCode) {
            log.error("Query cluster nodes failed, error code:{}, error description:{}, suggestion:{}", new Object[]{errorCode, errorDes, suggest});
            return false;
        }
        ArrayList<ClusterNode> nodeList = new ArrayList<ClusterNode>();
        JSONArray nodesArray = (JSONArray)clusterNodesResp.getContentMap().get("data");
        List<String> masterFsmIp = this.queryFsmMasterIp(devNode, conn);
        for (int i = 0; i < nodesArray.length(); ++i) {
            JSONObject node = nodesArray.getJSONObject(i);
            int idx = node.getInt("status");
            ClusterNodeStatus sta = idx == 0 || idx == -1 ? ClusterNodeStatus.STATUS_NORMAL : ClusterNodeStatus.STATUS_ABNORMAL;
            String name = (String)this.safeGetFromJson(node, "name", "None");
            String softwareVersion = (String)this.safeGetFromJson(node, "software_version", "None");
            String subrack = (String)this.safeGetFromJson(node, "subrack", "None");
            String cabinet = (String)this.safeGetFromJson(node, "cabinet", "None");
            String mgtIp = (String)this.safeGetFromJson(node, "management_ip", "None");
            boolean installStatus = (Boolean)this.safeGetFromJson(node, "installation_status", true);
            String sltNum = (String)this.safeGetFromJson(node, "slot_number", "None");
            String sn = (String)this.safeGetFromJson(node, "serial_number", "None");
            String model = (String)this.safeGetFromJson(node, "model", "None");
            boolean inCluster = (Boolean)this.safeGetFromJson(node, "in_cluster", true);
            int nodeId = (Integer)this.safeGetFromJson(node, "id", -1);
            ClusterNode cn = new ClusterNode(nodeId, name, sn, mgtIp, cabinet, subrack, sltNum, model, inCluster, sta, installStatus, softwareVersion);
            cn.setFsmRole(masterFsmIp.contains(cn.getManagementIp()) ? FsmRole.ACTIVE : FsmRole.ELSE);
            this.initNodeRole(node, cn);
            this.initBaseBoard(node, cn);
            this.initSandboxStatus(node, cn);
            nodeList.add(cn);
        }
        if (nodeList.isEmpty()) {
            log.error("Query no cluster nodes.");
            return false;
        }
        devNode.setClusterNodes(nodeList);
        return true;
    }

    private List<String> queryFsmMasterIp(com.huawei.ism.tool.obase.entity.DevNode devNode, RestConnection conn) {
        List<String> fsmMasterIps = this.tryQueryFsmMasterIpFromFusionStorage(devNode, conn);
        return fsmMasterIps.isEmpty() ? this.tryQueryFsmMasterIpFromPacific(devNode, conn) : fsmMasterIps;
    }

    private List<String> tryQueryFsmMasterIpFromFusionStorage(com.huawei.ism.tool.obase.entity.DevNode devNode, RestConnection conn) {
        try {
            ResponseInfo fusionStorManage = conn.execGet(RestUtil.getFusionStorManagerInfoUri(devNode));
            ManageInfo manageInfo = (ManageInfo)JSONUtils.jsonToBean((String)fusionStorManage.getContent(), ManageInfo.class);
            return manageInfo.getFsmNode().stream().filter(fsmNode -> fsmNode.getCurrentRole().equals("active")).map(ManageInfo.FsmNode::getManagerIp).collect(Collectors.toList());
        }
        catch (Exception exception) {
            log.warn("query fsm master ip from fusion storage failed. no big deal.");
            return Collections.emptyList();
        }
    }

    private List<String> tryQueryFsmMasterIpFromPacific(com.huawei.ism.tool.obase.entity.DevNode devNode, RestConnection conn) {
        try {
            ResponseInfo pacificFsmNodeInfo = conn.execGet(RestUtil.getFsmNodeInfoUri(devNode));
            String exterIp = JSONUtils.jsonToMaps((String)pacificFsmNodeInfo.getContent()).get("nodeIpPrimaryExter").toString();
            String innerIp = JSONUtils.jsonToMaps((String)pacificFsmNodeInfo.getContent()).get("nodeIpPrimaryInner").toString();
            return Arrays.asList(exterIp, innerIp);
        }
        catch (Exception exception) {
            log.warn("query fsm master ip from pacific failed. no big deal.");
            return Collections.emptyList();
        }
    }

    private void initBaseBoard(JSONObject node, ClusterNode cn) {
        try {
            cn.setBaseBoardType((String)this.safeGetFromJson(node, "base_board", "None"));
        }
        catch (JSONException e) {
            log.warn("Query cluster nodes base board error: {}", (Object)cn.getManagementIp());
        }
    }

    private void initSandboxStatus(JSONObject node, ClusterNode clusterNode) {
        try {
            Object sandboxStatusCode = this.safeGetFromJson(node, "sandbox_status", -1);
            if (sandboxStatusCode instanceof Integer) {
                clusterNode.setSandboxStatus(SandboxStatus.getStatusByCode((int)((Integer)sandboxStatusCode)));
            }
        }
        catch (JSONException jsonException) {
            log.warn("query sandbox status failed.");
        }
    }

    private void initNodeRole(JSONObject node, ClusterNode cn) {
        try {
            JSONArray roles = node.getJSONArray("role");
            if (null == roles || JSONObject.NULL == roles) {
                return;
            }
            for (int i = 0; i < roles.length(); ++i) {
                cn.getRoles().add(roles.getString(i));
            }
        }
        catch (JSONException e) {
            log.error("Query cluster nodes role error.", (Throwable)e);
        }
    }

    private Object safeGetFromJson(JSONObject obj, String key, Object defaultVal) {
        try {
            Object val = obj.get(key);
            if (null == val || JSONObject.NULL == val) {
                return defaultVal;
            }
            return val;
        }
        catch (JSONException e) {
            log.warn("key :{} not found return default value", (Object)key);
            return defaultVal;
        }
    }

    private void queryClusterSysInfo(com.huawei.ism.tool.obase.entity.DevNode devNode, RestConnection conn) throws ToolException {
        ResponseInfo clusterSysInfoResp = conn.execGet(RestUtil.getClusterSystemInfoUri(devNode));
        Long errorCode = (Long)clusterSysInfoResp.getContentMap().get("errorCode");
        String errorDes = (String)clusterSysInfoResp.getContentMap().get("description");
        String suggest = (String)clusterSysInfoResp.getContentMap().get("suggestion");
        if (0L != errorCode) {
            log.error("Query cluster nodes failed, error code:" + errorCode + ", error description:" + errorDes + ", suggestion:" + suggest);
        } else {
            JSONObject sysObj = (JSONObject)clusterSysInfoResp.getContentMap().get("data");
            if (sysObj.has("cluster_name")) {
                devNode.setDeviceName(sysObj.getString("cluster_name"));
            }
            if (sysObj.has("esn")) {
                devNode.setDeviceSerialNumber(sysObj.getString("esn"));
            }
        }
    }

    public void queryClusterProductInfo(com.huawei.ism.tool.obase.entity.DevNode devNode, RestConnection conn) throws ToolException {
        ResponseInfo clusterPdtInfoResp = conn.execGet(RestUtil.getClusterProductInfoUri(devNode));
        Long errorCode = (Long)clusterPdtInfoResp.getContentMap().get("errorCode");
        String errorDes = (String)clusterPdtInfoResp.getContentMap().get("description");
        if (0L != errorCode) {
            String suggest = (String)clusterPdtInfoResp.getContentMap().get("suggestion");
            log.error("Query cluster nodes failed, error code:" + errorCode + ", error description:" + errorDes + ", suggestion:" + suggest);
        } else {
            JSONObject obj = (JSONObject)clusterPdtInfoResp.getContentMap().get("data");
            if (obj.has("cluster_name")) {
                devNode.setDeviceName(obj.getString("cluster_name"));
            }
            if (obj.has("product_model")) {
                String pdtMdl = obj.getString("product_model");
                devNode.setDeviceType(DeviceType.valueOf((String)pdtMdl));
                devNode.setProductModel(pdtMdl);
            }
            if (obj.has("version")) {
                devNode.setProductVersion(obj.getString("version"));
            }
            if (obj.has("patch_version")) {
                devNode.setHotPatchVersion(obj.getString("patch_version"));
            }
            if (obj.has("hotpatch_version")) {
                devNode.setDistributedHotPatchVersion(obj.getStringOrDefault("hotpatch_version", ""));
            }
            devNode.setItDeviceType(ItDeviceType.DStorage);
            devNode.setPort(8088);
        }
    }

    private void makeErrorTaskResult(com.huawei.ism.tool.obase.entity.DevNode devNode, TaskResult ret) {
        String errorDes = ResourceUtil.getStringWithParams((String)DEVICE_CANNOT_CONNECT, (Object[])new Object[]{devNode.getIp()});
        ret.setErrorLocaleDescription(errorDes);
        ret.setResult(TaskResult.Result.FAILED);
    }

    private void makeQueryCluserInfoFailResult(com.huawei.ism.tool.obase.entity.DevNode devNode, TaskResult ret) {
        String errorDes = ResourceUtil.getStringWithParams((String)CLUSTER_INFO_QUERY_FAIL, (Object[])new Object[]{devNode.getIp()});
        ret.setErrorLocaleDescription(errorDes);
        ret.setResult(TaskResult.Result.FAILED);
    }

    public void setNodeSupport(INodeSupport nodeSupport) {
        this.nodeSupport = nodeSupport;
    }

    public INodeSupport getNodeSupport() {
        return this.nodeSupport;
    }

    @Override
    public TaskResult queryNodeInfo(com.huawei.ism.tool.obase.entity.DevNode devNode, DeviceOpr opr) {
        return this.queryNodeInfo(devNode, opr, null);
    }

    public void setQueryDirectPlanes(boolean isQueryDirectPlanes) {
        this.isQueryDirectPlanes = isQueryDirectPlanes;
    }
}

