/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.service.pub;

import com.google.common.base.Objects;
import com.huawei.ism.tool.base.ui.LookAndFeelInstaller;
import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicemanager.service.SettingService;
import com.huawei.ism.tool.devicemanager.service.VerSpcGainer;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.service.implement.ToolLoginServiceImpl;
import com.huawei.ism.tool.devicemanager.service.pub.ConnSettingServiceImpl;
import com.huawei.ism.tool.devicemanager.service.pub.DeviceManageContext;
import com.huawei.ism.tool.devicemanager.service.pub.DeviceManageImpl;
import com.huawei.ism.tool.devicemanager.ui.action.support.SubDialogUtils;
import com.huawei.ism.tool.devicemanager.ui.former.DeviceSaveServiceFactory;
import com.huawei.ism.tool.devicemanager.ui.former.ExtendNodeSaveUtil;
import com.huawei.ism.tool.devicemanager.ui.former.GetTooolSupportList;
import com.huawei.ism.tool.devicemanager.ui.former.service.IntelligentComputeSceneImpl;
import com.huawei.ism.tool.devicemanager.ui.former.service.NodeSceneOptionService;
import com.huawei.ism.tool.devicemanager.utils.DeviceContext;
import com.huawei.ism.tool.devicemanager.utils.DeviceForbidLoginUtil;
import com.huawei.ism.tool.devicemanager.utils.FileHostUtils;
import com.huawei.ism.tool.devicemanager.utils.ProductParser;
import com.huawei.ism.tool.framework.platform.context.AbstractContext;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.framework.pubservice.PublicServiceManage;
import com.huawei.ism.tool.framework.pubservice.common.AbstractPublicService;
import com.huawei.ism.tool.framework.pubservice.common.IPublicService;
import com.huawei.ism.tool.framework.pubservice.common.IToolLoginService;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.scenedata.SceneXmlData;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.MultiRouteNode;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.ComputeStorageDevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.entity.PriKeyInfo;
import com.huawei.ism.tool.obase.entity.Socks5Proxy;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ArrayUtils;
import com.huawei.ism.tool.obase.utils.Base64EncodeUtils;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.KeyOrderedHashMap;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.util.Utils;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.AppUtils;

public class DeviceManageService
extends AbstractPublicService {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(DeviceManageService.class);
    boolean isFromNew = true;
    private static final String JSON_SCENE = "jsonScene";
    private static final String STEP_ID = "stepID";
    private static final String TOOL_INSPECT = "Inspector";
    private static final String SCENE_HOST_DEVICE_LIST = "sceneHostDeviceList.xml";
    private static final String[] SINGLE_SUB_TOOL_SCENE = new String[]{"HotPatch", "Storage Collect", "Upgrade Disk", "eBackup Upgrade", "Upgrade_Centralized_FW", "PatchEvalu", "FaultDiagnose", "Fusionstorage Expansion Evaluation", "DeployInfoCollect", "Disk Rework", "Upgrade"};
    private static final String[] LDAP_TOOL_SCENE = new String[]{"Storage Collect", "History"};
    private static final List<String> UPGRADE_SCENE_STEPS = Collections.unmodifiableList(Arrays.asList("RestartControllers", "Inspector"));

    public List<IPublicService> getImplementedServices() {
        ArrayList<IPublicService> services = new ArrayList<IPublicService>();
        services.add((IPublicService)new DeviceManageImpl());
        services.add((IPublicService)new ConnSettingServiceImpl());
        services.add((IPublicService)new ToolLoginServiceImpl());
        return services;
    }

    protected AbstractContext getContext() {
        return DeviceManageContext.getInstance();
    }

    protected boolean init() {
        LOGGER.info("get device data");
        this.judgeToolkitNewOrOld();
        this.handleDevAdd();
        this.getDevFromContext();
        return true;
    }

    private void judgeToolkitNewOrOld() {
        try {
            if (StringUtils.isNULLStr((String)System.getenv("newDev"))) {
                LOGGER.info("getenv from old toolkit");
                this.isFromNew = false;
            } else {
                LOGGER.info("getenv from new toolkit");
            }
        }
        catch (Exception e) {
            LOGGER.error("getenv from old toolkit", (Throwable)e);
            this.isFromNew = false;
        }
    }

    private void getDevFromContext() {
        boolean isOKSelected;
        ArrayList<ArrayList<Object>> devRemindList = new ArrayList<ArrayList<Object>>();
        LOGGER.info("getCurrentSubScene:{},stepId:{}", (Object)SceneUtils.getCurrentSubScene(), (Object)SceneUtils.getCurrentStepId());
        if ("true".equals(UserOpDataSaveUtil.getToolIniProp((String)"tool.standalone.start")) || "true".equals(System.getProperty("tool.standalone.start"))) {
            LOGGER.info("get device data from env");
            this.addDevFromEnv(devRemindList);
        } else if (SceneUtils.isScene() && "true".equals(System.getProperty("tool.scene.start"))) {
            LOGGER.info("get scene device data from file");
            this.getDevFromSceneFile();
        } else if (SceneUtils.isScene() && !SceneUtils.isSceneSettingStep() && !SceneUtils.isSpecialSubScence((String)SceneUtils.getCurrentSubScene(), (String[])SINGLE_SUB_TOOL_SCENE)) {
            LOGGER.info("get scene device data from file");
            this.getDevFromSceneFile();
        } else if (SceneUtils.isScene() && Objects.equal((Object)SceneUtils.getCurrentSubScene(), (Object)"Upgrade") && UPGRADE_SCENE_STEPS.contains(SceneUtils.getCurrentStepId())) {
            LOGGER.info("get Upgrade Inspector step scene device data from file");
            this.getDevFromSceneFile();
        } else if ((SceneUtils.isA800Upgrade() || SceneUtils.isA800UpgradeCheck()) && SceneUtils.isSceneSettingStep()) {
            LOGGER.info("get ai device data from env");
            this.addAiNodeFromEnv();
        } else {
            LOGGER.info("get device data from env");
            this.addDevFromEnv(devRemindList);
        }
        if (!devRemindList.isEmpty() && !(isOKSelected = SubDialogUtils.showMultiInfoDialogOnTop(devRemindList, true, ResourceUtil.getString((String)"devicemanager.start.needdbgpsd.remind")))) {
            AppUtils.notifyToolBoxFailed((String)"{\"failedAction\":\"none\"}");
            LOGGER.info("user choose to exit");
            Runtime.getRuntime().exit(0);
        }
        this.handleSettingData();
        String path = FileUtils.getProductSuprotPkgPath();
        DeviceContext.getInstance().loadProductSupportPkg(path);
        DeviceContext.getInstance().analyForDev();
    }

    private void getDevFromSceneFile() {
        LOGGER.info("get scene devicedata from file");
        try {
            String sceneInfo = System.getenv(JSON_SCENE);
            if (!StringUtils.isNULLStr((String)sceneInfo)) {
                LOGGER.info("sceneInfo:{}", (Object)StringUtils.getCleanMessage((String)sceneInfo));
                JSONObject jsonObject = new JSONObject(sceneInfo);
                if (jsonObject.has(STEP_ID) && TOOL_INSPECT.equals(jsonObject.getString(STEP_ID))) {
                    DeviceManageService.getToolDevsFromSceneFile(SCENE_HOST_DEVICE_LIST);
                }
            }
            List<DevNode> newNodeLists = SceneXmlData.getInstance().loadSceneFromFile();
            if (null == (newNodeLists = DeviceForbidLoginUtil.filterForbidDevContainsShowErrMsg(newNodeLists))) {
                throw new NullPointerException("NodeLists is null.");
            }
            FileHostUtils.removeNoUseSceneFileHosts(newNodeLists);
            List nodeList = EntityUtils.toOldDevList(newNodeLists);
            if (null == nodeList) {
                LOGGER.error("scene read data from file is failed");
                throw new NullPointerException();
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("nodeList:" + nodeList);
            }
            Optional<List> extendNodes = DeviceSaveServiceFactory.buildServiceByEnvScene().map(NodeSceneOptionService::readExtend);
            for (com.huawei.ism.tool.obase.entity.DevNode devNode : nodeList) {
                if (extendNodes.isPresent()) {
                    com.huawei.ism.tool.obase.entity.DevNode newNode = this.readExtendInfo(devNode, extendNodes.get());
                    DefaultNodeProviderImpl.getInstance().addNode(newNode);
                    continue;
                }
                DefaultNodeProviderImpl.getInstance().addNode(devNode);
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info("DefaultNodeProviderImpl data" + DefaultNodeProviderImpl.getInstance());
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("scene get data from file is failed(runtime exception)", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("scene get data from file is failed");
        }
    }

    private com.huawei.ism.tool.obase.entity.DevNode readExtendInfo(com.huawei.ism.tool.obase.entity.DevNode node, List<?> list) {
        com.huawei.ism.tool.obase.entity.DevNode matchNode;
        if ((SceneUtils.isA800Upgrade() || SceneUtils.isA800UpgradeCheck()) && (matchNode = this.matchAiNode(node, list)) != null) {
            return matchNode;
        }
        if (ItDeviceType.DME_NODE.equals((Object)node.getItDeviceType()) && (matchNode = this.matchAiNode(node, list)) != null) {
            return matchNode;
        }
        return node;
    }

    @Nullable
    private com.huawei.ism.tool.obase.entity.DevNode matchAiNode(com.huawei.ism.tool.obase.entity.DevNode node, List<?> list) {
        Optional<AiDevNode> matchNode = list.stream().filter(AiDevNode.class::isInstance).map(AiDevNode.class::cast).filter(aiNode -> aiNode.getIp().equals(node.getIp())).findFirst();
        if (matchNode.isPresent()) {
            return (com.huawei.ism.tool.obase.entity.DevNode)matchNode.get();
        }
        return null;
    }

    public static void getToolDevsFromSceneFile(String fileName) {
        try {
            File devFile;
            String currentFile = FilePathUtils.filterPath((String)SceneUtils.getSceneFilePath((String)fileName));
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("host xml path is :" + currentFile);
            }
            if ((devFile = new File(currentFile)).exists()) {
                List<DevNode> devsXML = SceneXmlData.getInstance().loadSceneFromFile(fileName);
                if (null != (devsXML = DeviceForbidLoginUtil.filterForbidDevContainsShowErrMsg(devsXML))) {
                    FileHostUtils.removeNoUseSceneFileHosts(devsXML);
                    List newDevsXML = EntityUtils.toOldDevList(devsXML);
                    DefaultNodeProviderImpl.getInstance().addNodes(newDevsXML);
                }
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("scene get data from file is failed(runtime exception)", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("scene get data from file is failed");
        }
    }

    private void addAiNodeFromEnv() {
        IntelligentComputeSceneImpl intelligentComputeScene = new IntelligentComputeSceneImpl();
        List<AiDevNode> aiDevNodes = intelligentComputeScene.readAiExtend(ExtendNodeSaveUtil.TO_PREPARE_FILE);
        aiDevNodes.forEach(devNode -> {
            try {
                DefaultNodeProviderImpl.getInstance().addNode((com.huawei.ism.tool.obase.entity.DevNode)devNode);
            }
            catch (ToolException e) {
                LOGGER.error("[Add device >> {} ][Failed]", devNode, (Object)e);
            }
        });
    }

    private void addDevFromEnv(List<ArrayList<Object>> devRemaindList) {
        int i = 1;
        String str = null;
        String env = this.isFromNew ? "jsonDevEncodeNew_" : "jsonDevEncode_";
        String isRemindOnNodbgPsd = this.getConfig();
        ArrayList<ArrayList<Object>> failRet = new ArrayList<ArrayList<Object>>();
        while (!StringUtils.isNULLStr((String)(str = System.getenv(env + i++)))) {
            try {
                com.huawei.ism.tool.obase.entity.DevNode devNode;
                block8: {
                    JSONObject jsonObject = new JSONObject(str);
                    devNode = new com.huawei.ism.tool.obase.entity.DevNode();
                    this.initDevBaseInfo(jsonObject, devNode);
                    if (this.isUnSupportAddedOutOfSVp(failRet, devNode) || this.isUnSupportAddDomainUser(failRet, devNode)) continue;
                    devNode.setDeveloperPwd(AESEncrypt.decrypt((String)jsonObject.getString("developerPwd")));
                    User user = new User(this.decodeByBase64(jsonObject.getString("username"), this.isFromNew), AESEncrypt.decrypt((String)jsonObject.getString("password")));
                    this.setDevNodeValue(jsonObject, devNode, user);
                    if (this.dbgpsdInVlaid(devNode, isRemindOnNodbgPsd)) {
                        LOGGER.info("device {} dbgpsd invalid.PDV: {} type:{}", new Object[]{devNode.getIp(), devNode.getProductVersion(), devNode.getDeviceType()});
                        this.addToList(devRemaindList, devNode);
                        continue;
                    }
                    try {
                        if (DeviceForbidLoginUtil.isForbidDev(devNode)) {
                            failRet.add(this.createUnSupportInfo(devNode, DeviceForbidLoginUtil.createErrMsg(devNode)));
                        }
                        break block8;
                    }
                    catch (ToolException e) {
                        failRet.add(this.createUnSupportInfo(devNode, e.getDes()));
                    }
                    continue;
                }
                if (ItDeviceType.DME_NODE.equals((Object)devNode.getItDeviceType())) continue;
                DefaultNodeProviderImpl.getInstance().addNode(devNode);
            }
            catch (JSONException e) {
                LOGGER.error("parse JsonObj Error : ", (Throwable)e);
            }
            catch (Exception e) {
                LOGGER.error("addNOde Error : ", (Throwable)e);
            }
        }
        this.resourceUtilSet(failRet);
    }

    private void setCubeUserInfo(com.huawei.ism.tool.obase.entity.DevNode devNode, JSONObject jsonObject) {
        if (!devNode.isFusionCube()) {
            return;
        }
        devNode.setFusionCubeLoginUser(new User(this.decodeByBase64(jsonObject.getString("sshUsername"), this.isFromNew), AESEncrypt.decrypt((String)jsonObject.getString("sshPassword"))));
    }

    private void initDevBaseInfo(JSONObject jsonObject, com.huawei.ism.tool.obase.entity.DevNode devNode) {
        devNode.setIp(jsonObject.getString("devIp"));
        String itDevTypeName = jsonObject.has("itDeviceTypeName") ? jsonObject.getString("itDeviceTypeName") : null;
        devNode.setStorageDeviceType(ItDeviceType.valueOf((String)jsonObject.getStringOrDefault("storageDeviceType", ItDeviceType.Storage.getName())));
        this.setComputeStorageInfo(devNode, jsonObject);
        this.devNodeDeviceType(jsonObject, devNode, itDevTypeName);
        devNode.setProductVersion(jsonObject.getString("devVersion"));
        devNode.setVerifyCertificate(jsonObject.optBoolean("isVerifyCertificate"));
        this.tryDevNodeGetConfig(jsonObject, devNode);
        devNode.setDeviceName(this.decodeByBase64(jsonObject.getString("devName"), this.isFromNew));
        devNode.setDeviceSerialNumber(jsonObject.getString("serialNo"));
        devNode.setCanEnterDiagnose(jsonObject.optBoolean("canEnterDiagnose", false));
        devNode.setScenarioInfo(jsonObject.getStringOrDefault("scenarioInfo", ""));
        User user = new User();
        user.setDomain(jsonObject.optBoolean("domain", false));
        devNode.setLoginUser(user);
    }

    private void setComputeStorageInfo(com.huawei.ism.tool.obase.entity.DevNode devNode, JSONObject jsonObject) {
        if (jsonObject.has("computeStorageInfoFcvOpenApiUserName")) {
            ComputeStorageDevNode csDevnode = new ComputeStorageDevNode();
            User user = new User();
            user.setUserName(this.decodeByBase64(jsonObject.getStringOrDefault("computeStorageInfoFcvOpenApiUserName", ""), this.isFromNew));
            user.setPassword(AESEncrypt.decrypt((String)jsonObject.getStringOrDefault("computeStorageInfoFcvOpenApiUserPwd", "")));
            csDevnode.setOpenapiUser(user);
            csDevnode.setFcvIp(jsonObject.getStringOrDefault("computeStorageInfoFcvIp", ""));
            csDevnode.setFcvPort(Integer.parseInt(jsonObject.getStringOrDefault("computeStorageInfoFcvPort", "443")));
            csDevnode.setComputeStorageFcvDeviceId(jsonObject.getStringOrDefault("computeStorageInfoFcvDeviceId", ""));
            csDevnode.setComputeStorageFcvDeviceId(jsonObject.getStringOrDefault("computeStorageInfoFcvDeviceId", ""));
            csDevnode.setChassisNum(jsonObject.getStringOrDefault("computeStorageInfoChassisNum", "1"));
            csDevnode.setStorageNodesInfo(EntityUtils.jsonToListHashMap((JSONObject)jsonObject, (String)"computeStorageInfoList"));
            devNode.setComputeStorageDevNode(csDevnode);
        }
    }

    private ArrayList<Object> createUnSupportInfo(com.huawei.ism.tool.obase.entity.DevNode devNode, String msg) {
        ArrayList<Object> unSupportDev = new ArrayList<Object>();
        unSupportDev.add(devNode.getIp());
        unSupportDev.add(devNode.getDeviceSerialNumber());
        unSupportDev.add(msg);
        return unSupportDev;
    }

    private void setDevNodeValue(JSONObject jsonObject, com.huawei.ism.tool.obase.entity.DevNode devNode, User user) {
        user.setDomain(jsonObject.optBoolean("domain", false));
        devNode.setLoginUser(user);
        this.devNodeSetConfig(jsonObject, devNode);
        this.handleDevIpsAndSocks(jsonObject, devNode);
        this.handleDevSshForward(jsonObject, devNode);
        this.handDevRelatedSNIPs(jsonObject, devNode);
        this.handleDevPriKey(jsonObject, devNode);
        this.handleDevRemoteSNs(jsonObject, devNode);
        this.setCubeUserInfo(devNode, jsonObject);
    }

    private void devNodeSetConfig(JSONObject jsonObject, com.huawei.ism.tool.obase.entity.DevNode devNode) {
        if (jsonObject.has("rootPassword")) {
            User rootUser = new User("root", AESEncrypt.decrypt((String)jsonObject.getString("rootPassword")));
            devNode.setRootUser(rootUser);
        }
        if (jsonObject.has("ipListAreInnerIp")) {
            String ipListAreInnerIp = jsonObject.getString("ipListAreInnerIp");
            devNode.setIpListAreInnerIp(Boolean.valueOf(ipListAreInnerIp).booleanValue());
        }
    }

    private void devNodeDeviceType(JSONObject jsonObject, com.huawei.ism.tool.obase.entity.DevNode devNode, String itDevTypeName) {
        if (!StringUtils.isNULLStr((String)itDevTypeName)) {
            devNode.setItDeviceType(ItDeviceType.of((String)itDevTypeName));
        }
        if (jsonObject.has("devType")) {
            devNode.setDeviceType(DeviceType.valueOf((String)jsonObject.getString("devType")));
        }
    }

    private void tryDevNodeGetConfig(JSONObject jsonObject, com.huawei.ism.tool.obase.entity.DevNode devNode) {
        try {
            devNode.setHotPatchVersion(jsonObject.getString("hotpatchversion"));
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(DeviceManageService.class).error("Toolkit Frame is old");
        }
        try {
            devNode.setPort(jsonObject.getInt("port"));
            devNode.setHighDevSVPModuleInfo(jsonObject.getString("highDevSVPModuleInfo"));
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(DeviceManageService.class).error("Toolkit Frame is old", (Throwable)e);
        }
    }

    private void resourceUtilSet(final ArrayList<ArrayList<Object>> failRet) {
        if (!failRet.isEmpty()) {
            LookAndFeelInstaller.installToolCustomUI();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SubDialogUtils.showMultiInfoDialogOnTop(ResourceUtil.getString((String)"devicemanager.device.add.failed"), new String[]{ResourceUtil.getString((String)"devicemanager.layout.device.tablecolume.devip"), ResourceUtil.getString((String)"devicemanager.layout.device.tablecolume.devsn"), ResourceUtil.getString((String)"scene.remind.errormessage.reason")}, failRet);
                }
            });
        }
    }

    private String getConfig() {
        String isRemindOnNodbgPsd = null;
        try {
            isRemindOnNodbgPsd = com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().getAppConfig("isRemindOnNodbgPsd");
        }
        catch (RuntimeException e) {
            return isRemindOnNodbgPsd;
        }
        catch (Exception e) {
            return isRemindOnNodbgPsd;
        }
        return isRemindOnNodbgPsd;
    }

    private void addToList(List<ArrayList<Object>> devRemaindList, com.huawei.ism.tool.obase.entity.DevNode devNode) {
        ArrayList<String> msgs = new ArrayList<String>();
        msgs.add(devNode.getIp());
        msgs.add(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.developer.check.msg"));
        devRemaindList.add(msgs);
    }

    private boolean dbgpsdInVlaid(com.huawei.ism.tool.obase.entity.DevNode devNode, String isRemindOnNodbgPsd) {
        return "true".equals(isRemindOnNodbgPsd) && ProductParser.isDevNeedDbgPsd(EntityUtils.toNewDev((com.huawei.ism.tool.obase.entity.DevNode)devNode));
    }

    private void handleDevPriKey(JSONObject jsonObject, com.huawei.ism.tool.obase.entity.DevNode devNode) {
        if (jsonObject.has("priKey")) {
            JSONObject jsonDevPriKey = new JSONObject(jsonObject.getString("priKey"));
            PriKeyInfo info = new PriKeyInfo();
            info.setKeyName(this.decodeByBase64(jsonDevPriKey.getString("keyname"), this.isFromNew));
            info.setKeyPath(this.decodeByBase64(jsonDevPriKey.getString("keypath"), this.isFromNew));
            info.setKeyPwd(AESEncrypt.decrypt((String)jsonDevPriKey.getString("keypwd")));
            devNode.setPriKey(info);
        }
    }

    private void handleDevRemoteSNs(JSONObject jsonObject, com.huawei.ism.tool.obase.entity.DevNode devNode) {
        if (jsonObject.has("remoteSNs")) {
            JSONArray remoteSNs = jsonObject.getJSONArray("remoteSNs");
            ArrayList<String> remoteSNList = new ArrayList<String>();
            for (int j = 0; j < remoteSNs.length(); ++j) {
                String remoteSn = remoteSNs.getString(j);
                remoteSNList.add(remoteSn);
            }
            devNode.setRemoteSNs(remoteSNList);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("device " + devNode.getIp() + " remote SN is : " + devNode.getRemoteSNs().toString());
            }
        }
    }

    private String decodeByBase64(String code, boolean isFromNewBoolNum) {
        if (isFromNewBoolNum) {
            return Base64EncodeUtils.decodeNew((String)code);
        }
        return Base64EncodeUtils.decode((String)code);
    }

    private void handleSettingData() {
        ArrayList<Socks5Proxy> socks5List = null;
        String envSocks = this.isFromNew ? "jsonSocks5EncodeNew" : "jsonSocks5Encode";
        String jsonSocks5 = System.getenv(envSocks);
        if (jsonSocks5 != null) {
            try {
                socks5List = new ArrayList<Socks5Proxy>();
                socks5List.addAll(this.toSocks5List(jsonSocks5));
            }
            catch (Exception e) {
                LoggerFactory.getLogger(DeviceManageService.class).error("Json conversion socks5Proxy failed : ", (Throwable)e);
            }
        }
        KeyOrderedHashMap sshMap = null;
        String envSsh = this.isFromNew ? "jsonSshEncodeNew" : "jsonSshEncode";
        String jsonSsh = System.getenv(envSsh);
        if (jsonSsh != null) {
            try {
                sshMap = new KeyOrderedHashMap();
                sshMap.putAll(this.toSshMap(jsonSsh));
            }
            catch (Exception e) {
                LoggerFactory.getLogger(DeviceManageService.class).error("Json conversion Ssh failed : ", (Throwable)e);
            }
        }
        SettingService.saveProxies(sshMap, socks5List);
    }

    private void handleDevIpsAndSocks(JSONObject jsonObject, com.huawei.ism.tool.obase.entity.DevNode devNode) {
        JSONArray ipList = jsonObject.getJSONArray("devInnerIps");
        for (int j = 0; j < ipList.length(); ++j) {
            String ip = ipList.getString(j);
            devNode.addIp(ip);
        }
        try {
            if (jsonObject.has("sock5")) {
                JSONObject jsonDevSocks5 = new JSONObject(jsonObject.getString("sock5"));
                Socks5Proxy socks5Proxy = this.toDevNodeSocks5(jsonDevSocks5);
                devNode.setSocks5Proxy(socks5Proxy);
            } else {
                devNode.setSocks5Proxy(null);
            }
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Socks5 does not exist on the device", (Throwable)e);
            devNode.setSocks5Proxy(null);
        }
    }

    private void handleDevSshForward(JSONObject jsonObject, com.huawei.ism.tool.obase.entity.DevNode devNode) {
        try {
            if (jsonObject.has("sshForward")) {
                JSONArray jsonArraySsh = new JSONArray(jsonObject.getString("sshForward"));
                ArrayList<MultiRouteNode> muList = new ArrayList<MultiRouteNode>();
                for (int k = 0; k < jsonArraySsh.length(); ++k) {
                    JSONObject jsonSsh = jsonArraySsh.getJSONObject(k);
                    MultiRouteNode multiRouteNode = new MultiRouteNode(jsonSsh.getString("host"), jsonSsh.getInt("port"), this.decodeByBase64(jsonSsh.getString("uname"), this.isFromNew), AESEncrypt.decrypt((String)jsonSsh.getString("pwd")));
                    muList.add(multiRouteNode);
                }
                devNode.setSshForwardList(muList);
            } else {
                devNode.setSshForwardList(null);
            }
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("SSH does not exist on the device", (Throwable)e);
            devNode.setSshForwardList(null);
        }
    }

    private void handDevRelatedSNIPs(JSONObject jsonObject, com.huawei.ism.tool.obase.entity.DevNode devNode) {
        HashMap<String, String> relatedSNIPs = new HashMap<String, String>();
        try {
            if (jsonObject.has("relatedSNIPs")) {
                JSONObject relatedSNIPsJO = jsonObject.getJSONObject("relatedSNIPs");
                Iterator it = relatedSNIPsJO.keys();
                while (it.hasNext()) {
                    String key = String.valueOf(it.next());
                    String value = (String)relatedSNIPsJO.get(key);
                    relatedSNIPs.put(key, value);
                }
                devNode.setRelatedSNIPs(relatedSNIPs);
            }
        }
        catch (JSONException e) {
            ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("RelatedSNIPs does not exist on the device", (Throwable)e);
            devNode.setRelatedSNIPs(relatedSNIPs);
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("RelatedSNIPs does not exist on the device", (Throwable)e);
            devNode.setRelatedSNIPs(relatedSNIPs);
        }
    }

    private void handleDevAdd() {
        block7: {
            try {
                IToolLoginService toolLoginService = (IToolLoginService)PublicServiceManage.getInstance().getService(IToolLoginService.class);
                if (!ApplicationContext.getInstance().isSpecificDeviceMode() || null == toolLoginService) break block7;
                com.huawei.ism.tool.obase.entity.DevNode device = EntityUtils.toOldDev((DevNode)toolLoginService.getLogedInDevice());
                if (null == device) {
                    return;
                }
                try {
                    ICliConnection sshConn = SshConnectionManager.getSshConnection((com.huawei.ism.tool.obase.entity.DevNode)device, null, (boolean)true, (boolean)true);
                    String spcVer = new VerSpcGainer().query(sshConn);
                    if (!StringUtils.isNULLStr((String)spcVer)) {
                        device.setProductVersion(spcVer);
                    }
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Get SPC version failed.", (Throwable)e);
                }
                if (DefaultNodeProviderImpl.getInstance().isContainsNode(device)) {
                    DefaultNodeProviderImpl.getInstance().removeNode(device);
                }
                DefaultNodeProviderImpl.getInstance().addNode(device);
            }
            catch (ToolException t) {
                LoggerFactory.getLogger(DeviceManageService.class).error("DeviceManagerActivator start failed!", (Throwable)t);
            }
        }
    }

    private Socks5Proxy toDevNodeSocks5(JSONObject jsonSocks5) throws JSONException {
        Socks5Proxy socks5Proxy = new Socks5Proxy();
        socks5Proxy.setPort(jsonSocks5.getString("port"));
        socks5Proxy.setName(this.decodeByBase64(jsonSocks5.getString("name"), this.isFromNew));
        socks5Proxy.setServerIp(jsonSocks5.getString("serverIp"));
        socks5Proxy.setUuid(jsonSocks5.getString("uuid"));
        socks5Proxy.setUser(this.decodeByBase64(jsonSocks5.getString("user"), this.isFromNew));
        socks5Proxy.setPass(AESEncrypt.decrypt((String)jsonSocks5.getString("pass")));
        socks5Proxy.setAuthentic(jsonSocks5.getBoolean("authentic"));
        return socks5Proxy;
    }

    private KeyOrderedHashMap<String, List<MultiRouteNode>> toSshMap(String jsonSsh) throws JSONException {
        KeyOrderedHashMap sshMap = new KeyOrderedHashMap();
        JSONArray jsonArray = new JSONArray(jsonSsh);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = (JSONObject)jsonArray.get(i);
            String key = jsonObject.getString("key");
            JSONArray valArr = (JSONArray)jsonObject.get("val");
            ArrayList<MultiRouteNode> oldListMu = new ArrayList<MultiRouteNode>();
            for (int j = 0; j < valArr.length(); ++j) {
                JSONObject valObj = valArr.getJSONObject(j);
                String uname = this.decodeByBase64(valObj.getString("uname"), this.isFromNew);
                String pwd = AESEncrypt.decrypt((String)valObj.getString("pwd"));
                String host = valObj.getString("host");
                int port = valObj.getInt("port");
                MultiRouteNode oldMultiRouteNode = new MultiRouteNode(host, port, uname, pwd);
                oldListMu.add(oldMultiRouteNode);
            }
            sshMap.put((Object)key, oldListMu);
        }
        return sshMap;
    }

    private List<Socks5Proxy> toSocks5List(String jsonSocks5) throws JSONException {
        ArrayList<Socks5Proxy> socks5List = new ArrayList<Socks5Proxy>();
        JSONArray jsonArray = new JSONArray(jsonSocks5);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = (JSONObject)jsonArray.get(i);
            socks5List.add(this.toDevNodeSocks5(jsonObject));
        }
        return socks5List;
    }

    public void registerFailed(String id) {
    }

    public void registerSuccess(String id) {
    }

    private boolean isUnSupportAddedOutOfSVp(ArrayList<ArrayList<Object>> failRet, com.huawei.ism.tool.obase.entity.DevNode devNode) {
        if (!(ArrayUtils.isDevSupportOutSvpAdd((com.huawei.ism.tool.obase.entity.DevNode)devNode) || devNode.canEnterDiagnose() || ArrayUtils.isHighEndDevSupportSvpAdd((String)GetTooolSupportList.getNeededSceneID()))) {
            String messageKey = SceneUtils.supportAddDeviceViaSvp() ? "devicemanager.device.start.filter.support_svp" : "devicemanager.device.start.filter.dev";
            failRet.add(this.createUnSupportInfo(devNode, ResourceUtil.getString((String)messageKey)));
            return true;
        }
        return false;
    }

    private boolean isUnSupportAddDomainUser(ArrayList<ArrayList<Object>> failRet, com.huawei.ism.tool.obase.entity.DevNode devNode) {
        if (!devNode.getLoginUser().isDomain() || SceneUtils.isSpecialSubScence((String)SceneUtils.getCurrentSubScene(), (String[])LDAP_TOOL_SCENE) || this.isInspectorScene()) {
            return false;
        }
        failRet.add(this.createUnSupportInfo(devNode, ResourceUtil.getString((String)"scene.domain.user.not.support")));
        return true;
    }

    private boolean isInspectorScene() {
        return Utils.isNullStr((String)SceneUtils.getCurrentSubScene()) && UserOpDataSaveUtil.getToolIniBoolProp((String)"tool.support.domain") || this.isInspectorStartCollect();
    }

    private boolean isInspectorStartCollect() {
        File anotherToolFile = new File(String.join((CharSequence)File.separator, ApplicationContext.getInstance().getWorkPath(), "temp", "anothertool"));
        if (!anotherToolFile.exists()) {
            return false;
        }
        String fileInfo = StreamUtils.readStringFormFile((File)anotherToolFile);
        return fileInfo.contains("inspector") && fileInfo.contains("collect");
    }
}

