/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.service.task;

import com.huawei.ism.tool.devicemanager.service.task.DevResultDisplayer;
import com.huawei.ism.tool.devicemanager.service.task.IDeviceOperaObserver;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.ResourceUtil;

public class DeviceModifyObserver
implements IDeviceOperaObserver {
    private DevResultDisplayer displayer = null;

    public DeviceModifyObserver(DevResultDisplayer displayer) {
        this.displayer = displayer;
    }

    @Override
    public void observe(TaskResult taskResult, String ip) {
        if (null == taskResult) {
            ToolLoggerFactory.getLogger(this.getClass()).error("observe error. taskResult is null.");
            return;
        }
        if (taskResult.getResult() == TaskResult.Result.FAILED) {
            if (taskResult.getErrorLocaleDescription().equals("devicemanager.layout.device.modifydialog.deviceconnecterror")) {
                String msg = ResourceUtil.getString((String)taskResult.getErrorLocaleDescription());
                this.displayer.addResultMap(ip, msg);
            } else if (taskResult.getErrorLocaleDescription().equals("devicemanager.layout.device.add.deviceadddialog.deviceconnecterror")) {
                String msg = ResourceUtil.getStringWithParams((String)taskResult.getErrorLocaleDescription(), (Object[])new Object[]{ip});
                this.displayer.addResultMap(ip, msg);
            } else if (taskResult.getErrorLocaleDescription().equals("devicemanager.layout.device.add.deviceadddialog.developer.error")) {
                String msg = ResourceUtil.getString((String)taskResult.getErrorLocaleDescription());
                this.displayer.addResultMap(ip, msg);
            } else if (taskResult.getErrorLocaleDescription().equals("devicemanager.layout.device.add.deviceadddialog.developer.notfound")) {
                String msg = ResourceUtil.getStringWithParams((String)taskResult.getErrorLocaleDescription(), (Object[])new Object[0]);
                this.displayer.addResultMap(ip, msg);
            } else {
                this.displayer.addResultMap(ip, taskResult.getErrorLocaleDescription());
            }
        }
    }
}

