/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.auth;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.FsClusterNode;
import com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.conn.HttpConnectionCallback;
import com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.entity.ClusterEvalInfo;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.enums.ClusterMode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.protocol.rest.GetRequest;
import com.huawei.ism.tool.protocol.rest.PostRequest;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.RequestInfo;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import java.util.Collections;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FusionStorageRestfulService
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(FusionStorageRestfulService.class);
    private final RestConnection restConnection;
    private final ClusterEvalInfo clusterInfo;
    private final String baseUrl;

    public FusionStorageRestfulService(ClusterEvalInfo clusterInfo) throws ToolException {
        this.clusterInfo = clusterInfo;
        this.baseUrl = "https://" + RestUtil.processIPByURL(clusterInfo.getFloatIp()) + ":" + clusterInfo.getRestPort();
        HttpConnectionCallback restCallback = new HttpConnectionCallback();
        RequestInfo loginInfo = this.getLoginInfo();
        this.restConnection = RestConnectionManager.getRestConnection((DevNode)clusterInfo.getFloatNode(), loginInfo, restCallback);
    }

    public void fetchFSANodeTopography() throws ToolException {
        JSONArray poolTopo;
        JSONObject clusterTopo;
        String url = "https://" + RestUtil.processIPByURL(this.clusterInfo.getFloatIp()) + ":" + this.clusterInfo.getRestPort() + "/dsware/service/upgrade/getFsaNodeTopo";
        GetRequest requestInfo = new GetRequest(url);
        this.initRequestInfo(requestInfo);
        ResponseInfo response = this.restConnection.doRequest(requestInfo, true, true);
        if (response == null || response.getStatusLine().getStatusCode() != 200) {
            throw new ToolException("fsa.node.topo.fetch.failed");
        }
        JSONObject resultJson = JSON.parseObject((String)response.getContent());
        JSONObject clientTopo = resultJson.getJSONObject("clientTopo");
        if (clientTopo != null) {
            JSONArray clientIPs = clientTopo.getJSONArray("clientIpList");
            this.appendFsaNodeInfos(clientIPs);
        }
        if ((clusterTopo = resultJson.getJSONObject("clusterTopo")) != null) {
            JSONArray mdcIps = clusterTopo.getJSONArray("mdcIpList");
            this.appendFsaNodeInfos(mdcIps);
            this.clusterInfo.setClusterName(clusterTopo.getOrDefault((Object)"clusterName", (Object)"").toString());
        }
        if ((poolTopo = resultJson.getJSONArray("poolTopo")) != null && !poolTopo.isEmpty()) {
            poolTopo.stream().filter(JSONObject.class::isInstance).map(JSONObject.class::cast).map(json -> json.getJSONArray("osdIpList")).forEach(this::appendFsaNodeInfos);
        }
    }

    public String fetchFSMNodeInfo() throws ToolException {
        String url = this.baseUrl + "/dsware/service/upgrade/getFsmNodeInfo";
        GetRequest requestInfo = new GetRequest(url);
        this.initRequestInfo(requestInfo);
        ResponseInfo response = this.restConnection.doRequest(requestInfo, true, true);
        if (response == null || response.getStatusLine().getStatusCode() != 200) {
            throw new ToolException("fsm.node.info.fetch.failed");
        }
        return response.getContent();
    }

    private RequestInfo getLoginInfo() {
        String url = "https://" + RestUtil.processIPByURL(this.clusterInfo.getFloatIp()) + ":" + this.clusterInfo.getRestPort() + "/sec/service/login";
        PostRequest loginInfo = new PostRequest(url);
        this.initRequestInfo(loginInfo);
        loginInfo.setHeader("X-Auth-User", this.clusterInfo.getLoginUser().getUserName());
        loginInfo.setHeader("X-Auth-Key", this.clusterInfo.getLoginUser().getPassword());
        return loginInfo;
    }

    private String getAcceptLanguage() {
        Locale lang = LanguageManager.getInstance().getCurrentLanguage();
        return Locale.ENGLISH.equals(lang) ? "en_US" : "zh_CN";
    }

    private void appendFsaNodeInfos(JSONArray clientIPs) {
        for (int poi = 0; poi < clientIPs.size(); ++poi) {
            if (this.clusterInfo.getFsaNode(clientIPs.getString(poi)) != null) continue;
            FsClusterNode node = new FsClusterNode();
            node.setManagementIp(clientIPs.getString(poi));
            node.setSerialNumber(node.getManagementIp() + "Agent");
            if (this.isMasterNode(node)) {
                node.getRoles().add("Manager");
            }
            node.getRoles().add("Agent");
            node.setDeviceType("Agent");
            this.clusterInfo.putFsaNode(node);
        }
    }

    private boolean isMasterNode(FsClusterNode node) {
        if (this.clusterInfo.getModel() == ClusterMode.SINGLE) {
            return this.clusterInfo.getPrimaryNode().getIp().equals(node.getManagementIp());
        }
        return this.clusterInfo.getPrimaryNode().getIp().equals(node.getManagementIp()) || this.clusterInfo.getStandbyNode().getIp().equals(node.getManagementIp());
    }

    private void initRequestInfo(RequestInfo requestInfo) {
        requestInfo.setHeader("Host", RestUtil.processIPByURL(this.clusterInfo.getFloatIp()) + ":" + this.clusterInfo.getRestPort());
        requestInfo.setHeader("Accept", "application/json;version=1.0");
        requestInfo.setHeader("Accept-Language", this.getAcceptLanguage());
    }

    public void closeConnection() {
        RestConnectionManager.releaseConn((DevNode)this.clusterInfo.getFloatNode());
    }

    @Override
    public void close() throws Exception {
        this.closeConnection();
    }

    public void fetchFSANodeDetails() throws ToolException {
        String url = "https://" + RestUtil.processIPByURL(this.clusterInfo.getFloatIp()) + ":" + this.clusterInfo.getRestPort() + "/dsware/service/upgrade/getFsaNodeInfo";
        PostRequest requestInfo = new PostRequest(url);
        requestInfo.setHeader("Host", RestUtil.processIPByURL(this.clusterInfo.getFloatIp()) + ":" + this.clusterInfo.getRestPort());
        requestInfo.setHeader("Accept", "application/json;version=1.0");
        requestInfo.setHeader("Accept-Language", this.getAcceptLanguage());
        requestInfo.setHeader("Content-Type", "application/json");
        requestInfo.addParam("fsaNodeIpList", this.getAllFSAIps());
        ResponseInfo response = null;
        response = this.restConnection.doRequest(requestInfo, true, true);
        if (response == null || response.getStatusLine().getStatusCode() != 200) {
            throw new ToolException("fsa.node.detail.fetch.failed");
        }
        JSONObject resultJson = JSON.parseObject((String)response.getContent());
        JSONArray fsaNodesDetails = resultJson.getJSONArray("fsaNodeInfoList");
        this.checkFsaNodesDetails(fsaNodesDetails);
    }

    void checkFsaNodesDetails(JSONArray fsaNodesDetails) {
        for (int poi = 0; poi < fsaNodesDetails.size(); ++poi) {
            JSONObject fsaNode = JSON.parseObject((String)fsaNodesDetails.getString(poi));
            String nodeIp = fsaNode.getString("nodeIp");
            String nodeName = fsaNode.getString("nodeName");
            ClusterNode node = this.clusterInfo.getFsaNode(nodeIp);
            node.setName(nodeName);
        }
    }

    private String getAllFSAIps() {
        if (this.clusterInfo.getFsaNodes().isEmpty()) {
            return JSON.toJSONString(Collections.emptyList());
        }
        return JSON.toJSONString(this.clusterInfo.getFsaNodes().keySet());
    }
}

