/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.util;

import com.huawei.ism.tool.devicemanager.ui.action.support.SubDialogUtils;
import com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.entity.MultiTaskResultMsg;
import com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.entity.NodeMsg;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthResultShowUtil {
    private static final Logger log = LoggerFactory.getLogger(AuthResultShowUtil.class);

    public static void showAuthResult(Window parent, Future<TaskResult> result) {
        try {
            TaskResult taskResult = result.get();
            Object resultObject = taskResult.getResultObject();
            if (resultObject instanceof MultiTaskResultMsg) {
                AuthResultShowUtil.showTableInfos(parent, (MultiTaskResultMsg)resultObject, ResourceUtil.getString((String)"auth.result.info"));
                return;
            }
            DialogUtils.showInfoDialog((Window)parent, (String)ResourceUtil.getString((String)"auth.state.success"));
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("get a800 batch auth result error", (Throwable)e);
            DialogUtils.showErrorDialog((Window)parent, (String)ResourceUtil.getString((String)"device.manager.result.get.error"));
        }
    }

    public static void showTableInfos(Window parent, MultiTaskResultMsg resultObject, String tableTitle) {
        List showLines = resultObject.getResults().stream().map(AuthResultShowUtil::buildOneLine).collect(Collectors.toList());
        SubDialogUtils.showMultiInfoDialog(parent, tableTitle, new String[]{ResourceUtil.getString((String)"devicemanager.layout.device.errormsg.ip"), ResourceUtil.getString((String)"devicemanager.layout.device.errormsg.result")}, showLines);
    }

    private static List<Object> buildOneLine(NodeMsg msg) {
        ArrayList<Object> lineMsg = new ArrayList<Object>();
        lineMsg.add(msg.getIp());
        lineMsg.add(msg.getResultMsg());
        return lineMsg;
    }

    private AuthResultShowUtil() {
    }
}

