/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicemanager.ui.dialog.layout.aistorage;

import cn.hutool.core.bean.BeanUtil;
import com.huawei.ism.tool.devicemanager.ui.dialog.component.LoginInfoInputPanel;
import com.huawei.ism.tool.devicemanager.ui.dialog.deviceadd.util.AsyncBatchAuthUtil;
import com.huawei.ism.tool.devicemanager.ui.dialog.layout.AbstractLoginPanel;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmeLoginPanel
extends AbstractLoginPanel {
    private static final Logger log = LoggerFactory.getLogger(DmeLoginPanel.class);
    private final LoginInfoInputPanel loginComponent = new LoginInfoInputPanel();
    private AiDevNode devNode;

    public DmeLoginPanel() {
        this.initUi();
        this.loginComponent.setDefaultPort("26335");
    }

    private void initUi() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.buildShowComponent(), "North");
    }

    @NotNull
    private JComponent buildShowComponent() {
        return UCD.buildVerticalBox(null, (Component[])new Component[]{Box.createHorizontalStrut(0), this.createTopPanel(), Box.createHorizontalStrut(0), this.createMiddlePanel()});
    }

    private JComponent createTopPanel() {
        JLabel titleBasic = UiMethod.createHtmlLabel((String)ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.dme.login"));
        JTextArea basicInfoJLab = UiMethod.createJTextArea((String)ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.dme.login.info"));
        return UCD.buildVerticalBox(null, (int)0, (Component[])new Component[]{Box.createHorizontalStrut(0), UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), titleBasic}), UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(0), basicInfoJLab})});
    }

    private JComponent createMiddlePanel() {
        JComponent ipPan = UCD.buildVerticalBox(null, (Component[])new Component[]{this.loginComponent, Box.createVerticalStrut(0)});
        ipPan.setBorder(new TitledBorder(ResourceUtil.getString((String)"devicemanager.layout.device.add.deviceadddialog.middletitleborder")));
        return UCD.buildHorizotalBox(null, (Component[])new Component[]{Box.createHorizontalStrut(0), ipPan, Box.createHorizontalStrut(0)});
    }

    @Override
    public boolean process(Window parent) {
        log.info("start process dme login");
        try {
            this.validInput();
            return this.doLoginDme(parent);
        }
        catch (ToolException e) {
            log.error("login dme failed", (Throwable)e);
            DialogUtils.showInfoDialog((Window)parent, (String)e.getErrorLocaleDescription());
            return false;
        }
    }

    private boolean doLoginDme(Window parent) throws ToolException {
        this.devNode = this.buildLoginNode();
        return AsyncBatchAuthUtil.authDme(parent, this.devNode);
    }

    @NotNull
    private AiDevNode buildLoginNode() {
        DevNode basicNodeInfo = this.loginComponent.buildLoginNode();
        AiDevNode loginNode = new AiDevNode();
        BeanUtil.copyProperties((Object)basicNodeInfo, (Object)loginNode, (String[])new String[0]);
        loginNode.setDeviceType(DeviceType.valueOf((String)ItDeviceType.DME_NODE.getName()));
        loginNode.setItDeviceType(ItDeviceType.DME_NODE);
        loginNode.setProductModel(ItDeviceType.DME_NODE.getName());
        loginNode.setDeviceName(ItDeviceType.DME_NODE.getName());
        return loginNode;
    }

    private void validInput() throws ToolException {
        this.loginComponent.validInput();
    }

    public AiDevNode getDevNode() {
        return this.devNode;
    }
}

