/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.devicegraph.ui;

import com.huawei.ism.model.MOType;
import com.huawei.ism.tool.devicegraph.config.DeviceGraphConfig;
import com.huawei.ism.tool.devicegraph.config.EnclosureCfg;
import com.huawei.ism.tool.devicegraph.config.ModuleCfg;
import com.huawei.ism.tool.devicegraph.config.SlotCfg;
import com.huawei.ism.tool.devicegraph.ui.components.EnclosurePanel;
import com.huawei.ism.tool.devicegraph.ui.components.HighlightGraphCell;
import com.huawei.ism.tool.devicegraph.ui.components.RackPanel;
import com.huawei.ism.tool.devicegraph.util.GraphUtils;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.exception.EncapsulatedRuntimeException;
import com.huawei.ism.tool.framework.pubservice.hardware.HardwareDetail;
import com.huawei.ism.tool.framework.pubservice.hardware.IEnclosureInfo;
import com.huawei.ism.tool.framework.pubservice.hardware.IHardwareInfo;
import com.huawei.ism.tool.framework.pubservice.hardware.IPortInfo;
import com.huawei.ism.tool.framework.pubui.common.ui.AbstractDeviceGraph;
import com.huawei.ism.tool.framework.pubui.common.ui.EnclosureMenuItem;
import com.huawei.ism.tool.framework.pubui.entity.DeviceStatusEnum;
import com.mxgraph.model.mxCell;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxConstants;
import com.mxgraph.view.mxGraph;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class EnclosureGraphPanel
extends AbstractDeviceGraph {
    private static final long serialVersionUID = 8487015371166378702L;
    private static final int DEFAULT_WIDTH = 800;
    private static final int DEFAULT_HEIGHT = 600;
    private static final int TITLE_PANEL_HEIGHT = 30;
    private static final int INT_2 = 2;
    private List<RackPanel> rackList = null;
    private mxGraphComponent canvasGraph = null;
    private EnclosurePanel enc;
    private Map<String, Map<String, IHardwareInfo>> hardwareMap = new HashMap<String, Map<String, IHardwareInfo>>();

    public EnclosureGraphPanel(EnclosurePanel encPanel, boolean isSupportLight, boolean isBack) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        JPanel titlePanel = this.buildGraphTitleX(encPanel);
        this.add((Component)titlePanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.enc = encPanel;
        this.add((Component)this.enc, gbc);
    }

    public List<RackPanel> getRackList() {
        return this.rackList;
    }

    @Override
    public Dimension getDefaultSize() {
        return new Dimension(800, 600);
    }

    @Override
    public void highlightCable(IPortInfo from, IPortInfo to, DeviceStatusEnum status) {
    }

    @Override
    public void highlightModule(IHardwareInfo module) {
    }

    @Override
    public void highlightModules(List<IHardwareInfo> moduleList, DeviceStatusEnum status) {
        IEnclosureInfo encInfo = null;
        ArrayList<HighlightGraphCell> cells = new ArrayList<HighlightGraphCell>();
        ArrayList<IHardwareInfo> srcIntfLocs = new ArrayList<IHardwareInfo>();
        for (IHardwareInfo module : moduleList) {
            if (module.getTypeName().equals(MOType.ENCLOSURE.name())) {
                encInfo = (IEnclosureInfo)module;
                continue;
            }
            if (!module.getTypeName().equals(MOType.INTF_MODULE.name())) continue;
            srcIntfLocs.add(module);
        }
        if (null == encInfo || srcIntfLocs.isEmpty()) {
            return;
        }
        for (IHardwareInfo srcIntfLoc : srcIntfLocs) {
            if (this.hilight(encInfo, srcIntfLoc, status) == null) continue;
            cells.add(this.hilight(encInfo, srcIntfLoc, status));
        }
        this.highLight(cells);
    }

    @Override
    public List<Rectangle> getModulesLocation(List<IHardwareInfo> moduleList) {
        return null;
    }

    @Override
    public void highLightModule(Rectangle rectangle, DeviceStatusEnum status) {
        ArrayList<HighlightGraphCell> cells = new ArrayList<HighlightGraphCell>();
        cells.add(new HighlightGraphCell(status, rectangle));
        this.highLight(cells);
    }

    @Override
    public void turnOffLocatingLight(IHardwareInfo module, Window parent) {
    }

    @Override
    public void turnOnLocatingLight(IHardwareInfo module, Window parent) {
    }

    @Override
    public void updateGraph(List<HardwareDetail> hardwareList) {
        for (HardwareDetail hardware : hardwareList) {
            this.updateGraph(hardware);
        }
    }

    @Override
    public void updateGraph(HardwareDetail hardware) {
        if (null == hardware) {
            return;
        }
        IHardwareInfo selfInfo = hardware.getInfo();
        Map<String, IHardwareInfo> selfMap = this.hardwareMap.get(selfInfo.getTypeName());
        if (null == selfMap) {
            selfMap = new HashMap<String, IHardwareInfo>();
            this.hardwareMap.put(selfInfo.getTypeName(), selfMap);
        }
        selfMap.put(selfInfo.getID(), selfInfo);
        for (HardwareDetail subHardware : hardware.getSubModules()) {
            this.updateGraph(subHardware);
        }
    }

    @Override
    public void addHardware(String typeName, IHardwareInfo hardware) {
        Map<String, IHardwareInfo> map = this.hardwareMap.get(typeName);
        if (map == null) {
            map = new HashMap<String, IHardwareInfo>();
            this.hardwareMap.put(typeName, map);
        }
        map.put(hardware.getID(), hardware);
    }

    @Override
    public void addEnclosurePopupMenuItem(List<EnclosureMenuItem> items) {
    }

    @Override
    public void clearDeviceGraph() {
        if (this.canvasGraph != null) {
            this.canvasGraph.removeAll();
        }
    }

    @Override
    public void clearEnclosurePopupMenuItem(String enTypeName) {
    }

    @Override
    public void cancelHighlightModules() {
    }

    @Override
    public void cancelHighlightCables() {
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        String imgPath = "/config/images/grid_background.png";
        URL url = RackPanel.class.getResource(imgPath);
        ImageIcon imgIcon = new ImageIcon(url);
        Image img = imgIcon.getImage();
        graphics.drawImage(img, 0, 0, this.getWidth(), this.getHeight(), this);
    }

    private HighlightGraphCell hilight(IEnclosureInfo enclosureInfo, IHardwareInfo module, DeviceStatusEnum status) {
        boolean isHDGraph = ApplicationContext.getInstance().isHDGraph();
        Rectangle r = null;
        r = isHDGraph ? this.getHdHardwareLocation(enclosureInfo, module) : this.getHardwareLocation(enclosureInfo, module);
        if (null == r) {
            return null;
        }
        return new HighlightGraphCell(status, r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void highLight(List<HighlightGraphCell> cells) {
        mxGraph graph = this.enc.getGraph().getGraph();
        graph.getModel().beginUpdate();
        try {
            for (HighlightGraphCell cell : cells) {
                Map<Object, Object> style;
                Rectangle r = cell.getRectangle();
                int x = (int)r.getX();
                int y = (int)r.getY();
                int w = (int)r.getWidth();
                int h = (int)r.getHeight();
                mxCell old = (mxCell)this.enc.getGraph().getCellAt(x, y);
                if (old == null) {
                    style = new HashMap();
                    int count = graph.getStylesheet().getStyles().size();
                    String styleName = "overlay" + count;
                    style.put(mxConstants.STYLE_STROKECOLOR, cell.getStatus().getColorStr());
                    style.put(mxConstants.STYLE_STROKEWIDTH, 2);
                    style.put(mxConstants.STYLE_FILLCOLOR, "none");
                    graph.getStylesheet().putCellStyle(styleName, style);
                    graph.insertVertex(graph.getDefaultParent(), null, null, x, y, w, h, styleName);
                    continue;
                }
                style = graph.getStylesheet().getCellStyle(old.getStyle(), new HashMap<String, Object>());
                style.put(mxConstants.STYLE_IMAGE_BORDER, cell.getStatus().getColorStr());
                style.put(mxConstants.STYLE_STROKEWIDTH, 2);
                graph.getStylesheet().putCellStyle(old.getStyle(), style);
                graph.insertVertex(graph.getDefaultParent(), null, null, x, y, w, h, old.getStyle());
            }
        }
        finally {
            graph.getModel().endUpdate();
            this.updateUI();
        }
    }

    private Rectangle getHardwareLocation(IEnclosureInfo encInfo, IHardwareInfo module) {
        int w = 0;
        int h = 0;
        EnclosureCfg enclosureCfg = DeviceGraphConfig.getInstance().getEnclosureCfg(encInfo.getLogicTypeName(), encInfo.getModelName());
        if (enclosureCfg == null) {
            throw new EncapsulatedRuntimeException("enclosureCfg is null");
        }
        SlotCfg slotCfg = enclosureCfg.getBackCfgByLocation(module.getTypeName(), module.getLocation());
        if (null == slotCfg) {
            throw new EncapsulatedRuntimeException("slotCfg is null.");
        }
        int x = slotCfg.getxCoordinates();
        int y = slotCfg.getyCoordinates();
        ModuleCfg enCfg = DeviceGraphConfig.getInstance().getModuleCfg(module.getTypeName(), module.getModelName());
        if (null == enCfg) {
            throw new EncapsulatedRuntimeException("enCfg is null.");
        }
        w = slotCfg.getWidth();
        h = slotCfg.getHeight();
        return new Rectangle(x, y, w, h);
    }

    private Rectangle getHdHardwareLocation(IEnclosureInfo encInfo, IHardwareInfo module) {
        int w = 0;
        int h = 0;
        EnclosureCfg enclosureCfg = DeviceGraphConfig.getInstance().getHdEnclosureCfg(encInfo.getLogicTypeName(), encInfo.getModelName());
        if (enclosureCfg == null) {
            throw new EncapsulatedRuntimeException("enclosureCfg is null");
        }
        SlotCfg slotCfg = enclosureCfg.getHdBackCfgByLocation(module.getTypeName(), module.getLocation());
        if (null == slotCfg) {
            throw new EncapsulatedRuntimeException("slotCfg is null.");
        }
        int x = slotCfg.getxCoordinates();
        int y = slotCfg.getyCoordinates();
        ModuleCfg enCfg = DeviceGraphConfig.getInstance().getHdModuleCfg(module.getTypeName(), module.getModelName());
        if (null == enCfg) {
            throw new EncapsulatedRuntimeException("enCfg is null.");
        }
        w = slotCfg.getWidth();
        h = slotCfg.getHeight();
        return new Rectangle(x, y, w, h);
    }

    private JPanel buildGraphTitleX(EnclosurePanel enclosurePanel) {
        JPanel titlePanel = new JPanel();
        JLabel titleLabel = new JLabel(enclosurePanel.getEncInfo().getName());
        titleLabel.setFont(new Font(null, 1, 12));
        titlePanel.add((Component)titleLabel, "Center");
        EnclosureCfg ec = DeviceGraphConfig.getInstance().getEnclosureCfg(enclosurePanel.getEncInfo().getLogicTypeName(), enclosurePanel.getEncInfo().getModelName());
        if (null == ec) {
            throw new EncapsulatedRuntimeException("ec is null.");
        }
        int width = ec.getWidth();
        Dimension dimension = new Dimension(width, 30);
        GraphUtils.setChangelessSize(titlePanel, dimension);
        titlePanel.setOpaque(false);
        return titlePanel;
    }
}

